/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileDeleteStrategy;
import org.wso2.msf4j.HttpStreamer;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.beanconversion.MediaTypeConverter;
import org.wso2.msf4j.formparam.FileInfo;
import org.wso2.msf4j.formparam.FormDataParam;
import org.wso2.msf4j.formparam.FormItem;
import org.wso2.msf4j.formparam.FormParamIterator;
import org.wso2.msf4j.formparam.exception.FormUploadException;
import org.wso2.msf4j.formparam.util.StreamUtil;
import org.wso2.msf4j.internal.beanconversion.BeanConverter;
import org.wso2.msf4j.internal.router.HandlerException;
import org.wso2.msf4j.internal.router.HttpMethodInfo;
import org.wso2.msf4j.internal.router.HttpResourceModel;
import org.wso2.msf4j.util.QueryStringDecoderUtil;

public class HttpResourceModelProcessor {
    private final HttpResourceModel httpResourceModel;
    private HttpStreamer httpStreamer;
    private MultivaluedMap<String, Object> formParameters = null;
    private Map<String, String> formParamContentType = new HashMap<String, String>();
    private static Path tempRepoPath = Paths.get(System.getProperty("java.io.tmpdir"), "msf4jtemp");
    private Path tmpPathForRequest;
    private static FileCleaningTracker fileCleaningTracker = new FileCleaningTracker();
    private static final String FILEINFO_POSTFIX = "file.info";

    public HttpResourceModelProcessor(HttpResourceModel httpResourceModel) {
        this.httpResourceModel = httpResourceModel;
    }

    public HttpMethodInfo buildHttpMethodInfo(Request request, Response responder, Map<String, String> groupValues) throws HandlerException {
        try {
            List<HttpResourceModel.ParameterInfo<?>> paramInfoList = this.httpResourceModel.getParamInfoList();
            Object[] args = new Object[paramInfoList.size()];
            int idx = 0;
            for (HttpResourceModel.ParameterInfo<Object> parameterInfo : paramInfoList) {
                if (parameterInfo.getAnnotation() != null) {
                    Class<? extends Annotation> annotationType = parameterInfo.getAnnotation().annotationType();
                    if (PathParam.class.isAssignableFrom(annotationType)) {
                        args[idx] = this.getPathParamValue(parameterInfo, groupValues);
                    } else if (QueryParam.class.isAssignableFrom(annotationType)) {
                        args[idx] = this.getQueryParamValue(parameterInfo, request.getUri());
                    } else if (HeaderParam.class.isAssignableFrom(annotationType)) {
                        args[idx] = this.getHeaderParamValue(parameterInfo, request);
                    } else if (CookieParam.class.isAssignableFrom(annotationType)) {
                        args[idx] = this.getCookieParamValue(parameterInfo, request);
                    } else if (Context.class.isAssignableFrom(annotationType)) {
                        args[idx] = this.getContextParamValue(parameterInfo, request, responder);
                    } else if (FormParam.class.isAssignableFrom(annotationType)) {
                        args[idx] = this.getFormParamValue(parameterInfo, request);
                    } else if (FormDataParam.class.isAssignableFrom(annotationType)) {
                        args[idx] = this.getFormDataParamValue(parameterInfo, request);
                    } else {
                        this.createObject(request, args, idx, parameterInfo);
                    }
                } else {
                    this.createObject(request, args, idx, parameterInfo);
                }
                ++idx;
            }
            if (this.httpStreamer == null) {
                return new HttpMethodInfo(this.httpResourceModel.getMethod(), this.httpResourceModel.getHttpHandler(), args, this.formParameters, responder);
            }
            return new HttpMethodInfo(this.httpResourceModel.getMethod(), this.httpResourceModel.getHttpHandler(), args, this.formParameters, responder, this.httpStreamer);
        }
        catch (Throwable e) {
            throw new HandlerException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Error in executing request: %s %s", request.getHttpMethod(), request.getUri()), e);
        }
    }

    private void createObject(Request request, Object[] args, int idx, HttpResourceModel.ParameterInfo<?> paramInfo) throws IOException {
        try (InputStream inputStream = request.getMessageContentStream();){
            Type paramType = paramInfo.getParameterType();
            args[idx] = BeanConverter.getConverter(request.getContentType() != null ? request.getContentType() : "*/*").convertToObject(inputStream, paramType);
        }
    }

    private Object getFormDataParamValue(HttpResourceModel.ParameterInfo<List<Object>> paramInfo, Request request) throws FormUploadException, IOException {
        List<Object> parameter;
        boolean isNotNull;
        Type paramType = paramInfo.getParameterType();
        FormDataParam formDataParam = (FormDataParam)paramInfo.getAnnotation();
        if (this.getFormParameters() == null) {
            this.setFormParameters(this.extractRequestFormParams(request, paramInfo, true));
        }
        boolean bl = isNotNull = (parameter = this.getParameter(formDataParam.value())) != null;
        if (paramInfo.getConverter() != null) {
            if (paramType instanceof ParameterizedType && isNotNull && parameter.get(0).getClass().isAssignableFrom(File.class)) {
                return parameter;
            }
            if (isNotNull && parameter.get(0).getClass().isAssignableFrom(File.class)) {
                return parameter.get(0);
            }
            if ("text/plain".equalsIgnoreCase(this.formParamContentType.get(formDataParam.value()))) {
                return paramInfo.convert(parameter);
            }
            if ("application/x-www-form-urlencoded".equals(request.getContentType())) {
                return paramInfo.convert(parameter);
            }
            return this.createBean(parameter, formDataParam, paramType, isNotNull);
        }
        if (paramType == InputStream.class && isNotNull && parameter.get(0).getClass().isAssignableFrom(File.class)) {
            return new FileInputStream((File)parameter.get(0));
        }
        if (paramType == FileInfo.class) {
            List<Object> fileInfo = this.getParameter(formDataParam.value() + FILEINFO_POSTFIX);
            return fileInfo == null ? null : fileInfo.get(0);
        }
        return this.createBean(parameter, formDataParam, paramType, isNotNull);
    }

    private MultivaluedMap<String, Object> extractRequestFormParams(Request request, HttpResourceModel.ParameterInfo paramInfo, boolean addFileInfo) throws IOException {
        MultivaluedHashMap parameters = new MultivaluedHashMap();
        if ("multipart/form-data".equals(request.getContentType())) {
            FormParamIterator formParamIterator = new FormParamIterator(request);
            while (formParamIterator.hasNext()) {
                FormItem item = formParamIterator.next();
                String cType = item.getContentType();
                if (cType != null && cType.contains(";")) {
                    cType = cType.split(";")[0];
                }
                if (cType == null) {
                    cType = "text/plain";
                }
                boolean isFile = item.getHeaders().getHeader("content-disposition").contains("filename") || "application/octet-stream".equals(item.getHeaders().getHeader("content-type"));
                this.formParamContentType.putIfAbsent(item.getFieldName(), cType);
                List existingValues = (List)parameters.get((Object)item.getFieldName());
                if (existingValues == null) {
                    parameters.put((Object)item.getFieldName(), isFile ? new ArrayList<File>(Collections.singletonList(this.createAndTrackTempFile(item))) : new ArrayList<String>(Collections.singletonList(StreamUtil.asString(item.openStream()))));
                } else {
                    existingValues.add(isFile ? this.createAndTrackTempFile(item) : StreamUtil.asString(item.openStream()));
                }
                if (!addFileInfo || !isFile) continue;
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(item.getName());
                fileInfo.setContentType(item.getContentType());
                parameters.putSingle((Object)(item.getFieldName() + FILEINFO_POSTFIX), (Object)fileInfo);
            }
        } else if ("application/x-www-form-urlencoded".equals(request.getContentType())) {
            try (InputStream inputStream = request.getMessageContentStream();){
                String bodyStr = BeanConverter.getConverter(request.getContentType() != null ? request.getContentType() : "*/*").convertToObject(inputStream, paramInfo.getParameterType()).toString();
                QueryStringDecoderUtil queryStringDecoderUtil = new QueryStringDecoderUtil(bodyStr, false);
                queryStringDecoderUtil.parameters().entrySet().forEach(arg_0 -> HttpResourceModelProcessor.lambda$extractRequestFormParams$71((MultivaluedMap)parameters, arg_0));
            }
        }
        return parameters;
    }

    private Object createBean(List<Object> parameter, FormDataParam formDataParam, Type paramType, boolean isNotNull) {
        if (isNotNull) {
            MediaTypeConverter converter = BeanConverter.getConverter(this.formParamContentType.get(formDataParam.value()));
            ByteBuffer value = ByteBuffer.wrap(parameter.get(0).toString().getBytes(Charset.defaultCharset()));
            return converter.convertToObject(value, paramType);
        }
        return null;
    }

    private File createAndTrackTempFile(FormItem item) throws IOException {
        if (this.tmpPathForRequest == null) {
            if (Files.notExists(tempRepoPath, new LinkOption[0])) {
                Files.createDirectory(tempRepoPath, new FileAttribute[0]);
            }
            this.tmpPathForRequest = Files.createTempDirectory(tempRepoPath, "tmp", new FileAttribute[0]);
        }
        Path path = Paths.get(this.tmpPathForRequest.toString(), item.getName());
        File file = path.toFile();
        StreamUtil.copy(item.openStream(), new FileOutputStream(file), true);
        fileCleaningTracker.track(file, (Object)file);
        fileCleaningTracker.track(this.tmpPathForRequest.toFile(), (Object)file, FileDeleteStrategy.FORCE);
        return file;
    }

    private Object getFormParamValue(HttpResourceModel.ParameterInfo<List<Object>> paramInfo, Request request) throws FormUploadException, IOException {
        String defaultVal;
        List<Object> paramValue;
        FormParam formParam = (FormParam)paramInfo.getAnnotation();
        if (this.getFormParameters() == null) {
            MultivaluedHashMap parameters = new MultivaluedHashMap();
            if ("multipart/form-data".equals(request.getContentType())) {
                FormParamIterator formParamIterator = new FormParamIterator(request);
                while (formParamIterator.hasNext()) {
                    FormItem item = formParamIterator.next();
                    List existingValues = (List)parameters.get((Object)item.getFieldName());
                    if (existingValues == null) {
                        parameters.put((Object)item.getFieldName(), new ArrayList<String>(Collections.singletonList(StreamUtil.asString(item.openStream()))));
                        continue;
                    }
                    existingValues.add(StreamUtil.asString(item.openStream()));
                }
            } else if ("application/x-www-form-urlencoded".equals(request.getContentType())) {
                try (InputStream inputStream = request.getMessageContentStream();){
                    String bodyStr = BeanConverter.getConverter(request.getContentType() != null ? request.getContentType() : "*/*").convertToObject(inputStream, paramInfo.getParameterType()).toString();
                    QueryStringDecoderUtil queryStringDecoderUtil = new QueryStringDecoderUtil(bodyStr, false);
                    queryStringDecoderUtil.parameters().entrySet().forEach(arg_0 -> HttpResourceModelProcessor.lambda$getFormParamValue$72((MultivaluedMap)parameters, arg_0));
                }
            }
            this.setFormParameters((MultivaluedMap<String, Object>)parameters);
        }
        if ((paramValue = this.getParameter(formParam.value())) == null && (defaultVal = paramInfo.getDefaultVal()) != null) {
            paramValue = Collections.singletonList(defaultVal);
        }
        return paramInfo.convert(paramValue);
    }

    private Object getContextParamValue(HttpResourceModel.ParameterInfo<Object> paramInfo, Request request, Response responder) throws FormUploadException, IOException {
        Type paramType = paramInfo.getParameterType();
        MultivaluedMap<String, Object> value = null;
        if (((Class)paramType).isAssignableFrom(Request.class)) {
            value = request;
        } else if (((Class)paramType).isAssignableFrom(Response.class)) {
            value = responder;
        } else if (((Class)paramType).isAssignableFrom(HttpStreamer.class)) {
            if (this.httpStreamer == null) {
                this.httpStreamer = new HttpStreamer();
            }
            value = this.httpStreamer;
        } else if (((Class)paramType).isAssignableFrom(FormParamIterator.class)) {
            value = new FormParamIterator(request);
        } else if (((Class)paramType).isAssignableFrom(MultivaluedMap.class)) {
            MultivaluedMap<String, Object> listMultivaluedMap = new MultivaluedMap<String, Object>();
            if ("multipart/form-data".equals(request.getContentType())) {
                listMultivaluedMap = this.extractRequestFormParams(request, paramInfo, false);
            } else if ("application/x-www-form-urlencoded".equals(request.getContentType())) {
                try (InputStream inputStream = request.getMessageContentStream();){
                    String bodyStr = BeanConverter.getConverter(request.getContentType() != null ? request.getContentType() : "*/*").convertToObject(inputStream, paramInfo.getParameterType()).toString();
                    QueryStringDecoderUtil queryStringDecoderUtil = new QueryStringDecoderUtil(bodyStr, false);
                    MultivaluedMap<String, Object> finalListMultivaluedMap = listMultivaluedMap;
                    queryStringDecoderUtil.parameters().entrySet().forEach(entry -> {
                        List cfr_ignored_0 = (List)finalListMultivaluedMap.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
                    });
                }
            }
            value = listMultivaluedMap;
        }
        Objects.requireNonNull(value, String.format("Could not resolve parameter %s", paramType.getTypeName()));
        return value;
    }

    private Object getPathParamValue(HttpResourceModel.ParameterInfo<String> info, Map<String, String> groupValues) {
        String defaultVal;
        PathParam pathParam = (PathParam)info.getAnnotation();
        String value = groupValues.get(pathParam.value());
        if (value == null && (defaultVal = info.getDefaultVal()) != null) {
            value = defaultVal;
        }
        Objects.requireNonNull(value, String.format("Could not resolve value for parameter %s", pathParam.value()));
        return info.convert(value);
    }

    private Object getQueryParamValue(HttpResourceModel.ParameterInfo<List<String>> info, String uri) {
        String defaultVal;
        QueryParam queryParam = (QueryParam)info.getAnnotation();
        List<String> values = new QueryStringDecoderUtil(uri).parameters().get(queryParam.value());
        if ((values == null || values.isEmpty()) && (defaultVal = info.getDefaultVal()) != null) {
            values = Collections.singletonList(defaultVal);
        }
        return info.convert(values);
    }

    private Object getHeaderParamValue(HttpResourceModel.ParameterInfo<List<String>> info, Request request) {
        String defaultVal;
        HeaderParam headerParam = (HeaderParam)info.getAnnotation();
        String headerName = headerParam.value();
        String header = request.getHeader(headerName);
        if ((header == null || header.isEmpty()) && (defaultVal = info.getDefaultVal()) != null) {
            header = defaultVal;
        }
        return info.convert(Collections.singletonList(header));
    }

    private Object getCookieParamValue(HttpResourceModel.ParameterInfo<String> info, Request request) {
        CookieParam cookieParam = (CookieParam)info.getAnnotation();
        String cookieName = cookieParam.value();
        String cookieHeader = request.getHeader("Cookie");
        if (cookieHeader != null) {
            String cookieValue = Arrays.stream(cookieHeader.split(";")).filter(cookie -> cookie.startsWith(cookieName + "=")).findFirst().map(cookie -> cookie.substring((cookieName + "=").length())).orElseGet(info::getDefaultVal);
            return info.convert(cookieValue);
        }
        return null;
    }

    private List<Object> getParameter(String key) {
        return (List)this.formParameters.get((Object)key);
    }

    public Map<String, List<Object>> getFormParameters() {
        return this.formParameters;
    }

    public void setFormParameters(MultivaluedMap<String, Object> parameters) {
        this.formParameters = parameters;
    }

    private static /* synthetic */ void lambda$getFormParamValue$72(MultivaluedMap multivaluedMap, Map.Entry entry) {
        List cfr_ignored_0 = (List)multivaluedMap.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
    }

    private static /* synthetic */ void lambda$extractRequestFormParams$71(MultivaluedMap multivaluedMap, Map.Entry entry) {
        List cfr_ignored_0 = (List)multivaluedMap.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
    }
}

