/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHeadersImpl
implements HttpHeaders {
    private static final String DATE_FORMAT_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String GMT_TIMEZONE = "GMT";
    private final io.netty.handler.codec.http.HttpHeaders nettyHttpHeaders;
    private static final Logger log = LoggerFactory.getLogger(HttpHeadersImpl.class);

    public HttpHeadersImpl(io.netty.handler.codec.http.HttpHeaders httpHeaders) {
        this.nettyHttpHeaders = httpHeaders;
    }

    public List<String> getRequestHeader(String name) {
        return this.nettyHttpHeaders.getAll(name);
    }

    public String getHeaderString(String name) {
        List headerValues = this.nettyHttpHeaders.getAll(name);
        if (headerValues == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < headerValues.size(); ++i) {
            String value = (String)headerValues.get(i);
            if (value == null || value.isEmpty()) continue;
            sb.append(value);
            if (i + 1 >= headerValues.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        MultivaluedHashMap newHeaders = new MultivaluedHashMap();
        for (Map.Entry headerEntry : this.nettyHttpHeaders.entries()) {
            if (headerEntry == null) continue;
            newHeaders.add(headerEntry.getKey(), headerEntry.getValue());
        }
        return newHeaders;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        List values = this.nettyHttpHeaders.getAll("Accept");
        if (values == null || values.isEmpty() || values.get(0) == null) {
            return Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        LinkedList<MediaType> mediaTypes = new LinkedList<MediaType>();
        for (String value : values) {
            mediaTypes.add(MediaType.valueOf((String)value));
        }
        return mediaTypes;
    }

    public List<Locale> getAcceptableLanguages() {
        List values = this.nettyHttpHeaders.getAll("Accept-Language");
        if (values.isEmpty()) {
            return Collections.singletonList(new Locale("*"));
        }
        ArrayList<Locale> localeValues = new ArrayList<Locale>();
        HashMap<Locale, Float> prefs = new HashMap<Locale, Float>();
        for (String value : values) {
            String[] pair = value != null ? value.split(";") : new String[]{};
            Locale locale = new Locale(pair[0].trim());
            localeValues.add(locale);
            if (pair.length > 1) {
                String[] pair2;
                String[] stringArray = pair2 = pair[1] != null ? pair[1].split("=") : new String[]{};
                if (pair2.length > 1) {
                    prefs.put(locale, Float.valueOf(this.getLanguageQualityFactor(pair2[1].trim())));
                    continue;
                }
                prefs.put(locale, Float.valueOf(1.0f));
                continue;
            }
            prefs.put(locale, Float.valueOf(1.0f));
        }
        if (localeValues.size() <= 1) {
            return localeValues;
        }
        localeValues.sort(new AcceptLanguageComparator(prefs));
        return localeValues;
    }

    private float getLanguageQualityFactor(String q) {
        if (q == null) {
            return 1.0f;
        }
        if (q.charAt(0) == '.') {
            q = '0' + q;
        }
        try {
            return Float.parseFloat(q);
        }
        catch (NumberFormatException numberFormatException) {
            return 1.0f;
        }
    }

    public MediaType getMediaType() {
        String value = this.nettyHttpHeaders.get("Content-Type");
        return value == null ? null : MediaType.valueOf((String)value);
    }

    public Locale getLanguage() {
        String value = this.nettyHttpHeaders.get("Content-Language");
        return value == null ? null : new Locale(value.trim());
    }

    public Map<String, Cookie> getCookies() {
        List values = this.nettyHttpHeaders.getAll("Cookie");
        if (values == null || values.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        for (String value : values) {
            if (value == null) continue;
            Cookie cookie = Cookie.valueOf((String)value);
            cookieMap.put(cookie.getName(), cookie);
        }
        return cookieMap;
    }

    public Date getDate() {
        String value = this.nettyHttpHeaders.get("Date");
        if (value == null || value.isEmpty()) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN, Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone(GMT_TIMEZONE));
        try {
            return dateFormat.parse(value);
        }
        catch (ParseException e) {
            log.error("Error while parsing the Date value. Hence return null", (Throwable)e);
            return null;
        }
    }

    public int getLength() {
        String value = this.nettyHttpHeaders.get("Content-Length");
        if (value == null || value.isEmpty()) {
            return -1;
        }
        int length = Integer.parseInt(value);
        return length >= 0 ? length : -1;
    }

    private static class AcceptLanguageComparator
    implements Comparator<Locale>,
    Serializable {
        private Map<Locale, Float> preferences;
        private static final long serialVersionUID = 6006269076155338045L;

        AcceptLanguageComparator(Map<Locale, Float> prefs) {
            this.preferences = prefs;
        }

        @Override
        public int compare(Locale lang1, Locale lang2) {
            float p1 = this.preferences.get(lang1).floatValue();
            float p2 = this.preferences.get(lang2).floatValue();
            return Float.compare(p1, p2) * -1;
        }
    }
}

