/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.swagger;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.annotations.Extension;
import io.swagger.annotations.Info;
import io.swagger.annotations.ResponseHeader;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.PATCH;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.DefaultReaderConfig;
import io.swagger.jaxrs.config.ReaderConfig;
import io.swagger.jaxrs.config.ReaderListener;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.jaxrs.utils.ReaderUtils;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.BaseReaderUtils;
import io.swagger.util.ParameterProcessor;
import io.swagger.util.PathUtils;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtendedSwaggerReader
extends Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedSwaggerReader.class);
    private static final String SUCCESSFUL_OPERATION = "successful operation";
    private static final String PATH_DELIMITER = "/";
    private final ReaderConfig config;
    private Swagger swagger;
    private String basePath;

    ExtendedSwaggerReader(String basePath, Swagger swagger) {
        super(swagger);
        this.swagger = swagger;
        this.config = new DefaultReaderConfig(null);
        this.basePath = basePath;
    }

    public Swagger read(Set<Class<?>> classes) {
        HashMap listeners = new HashMap();
        for (Class<Object> cls : classes) {
            if (!ReaderListener.class.isAssignableFrom(cls) || listeners.containsKey(cls)) continue;
            try {
                listeners.put(cls, (ReaderListener)cls.newInstance());
            }
            catch (Exception e) {
                LOGGER.error("Failed to create ReaderListener", (Throwable)e);
            }
        }
        for (ReaderListener listener : listeners.values()) {
            try {
                listener.beforeScan((Reader)this, this.swagger);
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error invoking beforeScan listener [" + listener.getClass().getName() + "]", (Throwable)e);
            }
        }
        for (Class<Object> cls : classes) {
            SwaggerDefinition swaggerDefinition = cls.getAnnotation(SwaggerDefinition.class);
            if (swaggerDefinition == null) continue;
            this.readSwaggerConfig(cls, swaggerDefinition);
        }
        for (Class<Object> cls : classes) {
            this.read(cls, "", null, false, new String[0], new String[0], new HashMap<String, Tag>(), new ArrayList<Parameter>(), new HashSet());
        }
        for (ReaderListener listener : listeners.values()) {
            try {
                listener.afterScan((Reader)this, this.swagger);
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error invoking afterScan listener [" + listener.getClass().getName() + "]", (Throwable)e);
            }
        }
        return this.swagger;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public Swagger read(Class<?> cls) {
        SwaggerDefinition swaggerDefinition = cls.getAnnotation(SwaggerDefinition.class);
        if (swaggerDefinition != null) {
            this.readSwaggerConfig(cls, swaggerDefinition);
        }
        return this.read(cls, "", null, false, new String[0], new String[0], new HashMap<String, Tag>(), new ArrayList<Parameter>(), new HashSet());
    }

    protected Swagger read(Class<?> cls, String parentPath, String parentMethod, boolean isSubresource, String[] parentConsumes, String[] parentProduces, Map<String, Tag> parentTags, List<Parameter> parentParameters) {
        return this.read(cls, parentPath, parentMethod, isSubresource, parentConsumes, parentProduces, parentTags, parentParameters, new HashSet());
    }

    private Swagger read(Class<?> cls, String parentPath, String parentMethod, boolean isSubresource, String[] parentConsumes, String[] parentProduces, Map<String, Tag> parentTags, List<Parameter> parentParameters, Set<Class<?>> scannedResources) {
        Method[] methods;
        boolean readable;
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
        String[] consumes = new String[]{};
        String[] produces = new String[]{};
        EnumSet<Scheme> globalSchemes = EnumSet.noneOf(Scheme.class);
        Api api = cls.getAnnotation(Api.class);
        boolean hasPathAnnotation = ReflectionUtils.getAnnotation(cls, Path.class) != null;
        boolean hasApiAnnotation = api != null;
        boolean isApiHidden = hasApiAnnotation && api.hidden();
        boolean classReadable = (hasPathAnnotation || isSubresource) && !isApiHidden;
        boolean bl = readable = classReadable || !isApiHidden && this.config.isScanAllResources();
        if (!readable) {
            return this.swagger;
        }
        boolean apiReadable = hasApiAnnotation;
        if (apiReadable) {
            Authorization[] authorizations;
            Set<String> tagStrings = this.extractTags(api);
            for (String string : tagStrings) {
                Tag tag = new Tag().name(string);
                tags.put(string, tag);
            }
            tags.keySet().forEach(tagName -> this.swagger.tag((Tag)tags.get(tagName)));
            if (!api.produces().isEmpty()) {
                produces = ReaderUtils.splitContentValues((String[])new String[]{api.produces()});
            }
            if (!api.consumes().isEmpty()) {
                consumes = ReaderUtils.splitContentValues((String[])new String[]{api.consumes()});
            }
            globalSchemes.addAll(ExtendedSwaggerReader.parseSchemes(api.protocols()));
            for (Authorization auth : authorizations = api.authorizations()) {
                AuthorizationScope[] scopes;
                if (auth.value() == null || "".equals(auth.value())) continue;
                SecurityRequirement security = new SecurityRequirement();
                security.setName(auth.value());
                for (AuthorizationScope scope : scopes = auth.scopes()) {
                    if (scope.scope() == null || "".equals(scope.scope())) continue;
                    security.addScope(scope.scope());
                }
                securities.add(security);
            }
        }
        if (isSubresource && parentTags != null) {
            tags.putAll(parentTags);
        }
        if (consumes.length == 0 && cls.getAnnotation(Consumes.class) != null) {
            consumes = ReaderUtils.splitContentValues((String[])cls.getAnnotation(Consumes.class).value());
        }
        if (produces.length == 0 && cls.getAnnotation(Produces.class) != null) {
            produces = ReaderUtils.splitContentValues((String[])cls.getAnnotation(Produces.class).value());
        }
        ArrayList<Parameter> globalParameters = new ArrayList<Parameter>();
        globalParameters.addAll(ReaderUtils.collectConstructorParameters(cls, (Swagger)this.swagger));
        globalParameters.addAll(ReaderUtils.collectFieldParameters(cls, (Swagger)this.swagger));
        ApiResponses classResponseAnnotation = (ApiResponses)ReflectionUtils.getAnnotation(cls, ApiResponses.class);
        ArrayList<ApiResponse> arrayList = new ArrayList<ApiResponse>();
        if (classResponseAnnotation != null) {
            arrayList.addAll(Arrays.asList(classResponseAnnotation.value()));
        }
        Path apiPath = this.basePath != null && !this.basePath.isEmpty() ? new Path(){

            public Class<? extends Annotation> annotationType() {
                return Path.class;
            }

            public String value() {
                return ExtendedSwaggerReader.this.basePath;
            }
        } : (Path)ReflectionUtils.getAnnotation(cls, Path.class);
        for (Method method : methods = cls.getMethods()) {
            io.swagger.models.Path path;
            Class<?> subResource;
            if (ReflectionUtils.isOverriddenMethod((Method)method, cls)) continue;
            Path methodPath = (Path)ReflectionUtils.getAnnotation((Method)method, Path.class);
            String operationPath = this.getPath(apiPath, methodPath, parentPath);
            HashMap regexMap = new HashMap();
            if ((operationPath = PathUtils.parsePath((String)operationPath, regexMap)) == null || this.isIgnored(operationPath)) continue;
            ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
            String httpMethod = this.extractOperationMethod(apiOperation, method, SwaggerExtensions.chain());
            Operation operation = null;
            if (apiOperation != null || this.config.isScanAllResources() || httpMethod != null || methodPath != null) {
                operation = this.parseMethod(cls, method, globalParameters, arrayList);
            }
            if (operation == null) continue;
            if (parentParameters != null) {
                for (Parameter param2 : parentParameters) {
                    operation.parameter(param2);
                }
            }
            operation.getParameters().stream().filter(param -> regexMap.get(param.getName()) != null).forEach(param -> {
                String pattern = (String)regexMap.get(param.getName());
                param.setPattern(pattern);
            });
            if (apiOperation != null) {
                for (Scheme scheme : ExtendedSwaggerReader.parseSchemes(apiOperation.protocols())) {
                    operation.scheme(scheme);
                }
            }
            if (operation.getSchemes() == null || operation.getSchemes().isEmpty()) {
                for (Scheme scheme : globalSchemes) {
                    operation.scheme(scheme);
                }
            }
            String[] apiConsumes = consumes;
            if (parentConsumes != null) {
                HashSet<String> both = new HashSet<String>(Arrays.asList(apiConsumes));
                both.addAll(new HashSet<String>(Arrays.asList(parentConsumes)));
                if (operation.getConsumes() != null) {
                    both.addAll(new HashSet(operation.getConsumes()));
                }
                apiConsumes = both.toArray(new String[both.size()]);
            }
            String[] apiProduces = produces;
            if (parentProduces != null) {
                HashSet<String> both = new HashSet<String>(Arrays.asList(apiProduces));
                both.addAll(new HashSet<String>(Arrays.asList(parentProduces)));
                if (operation.getProduces() != null) {
                    both.addAll(new HashSet(operation.getProduces()));
                }
                apiProduces = both.toArray(new String[both.size()]);
            }
            if ((subResource = this.getSubResourceWithJaxRsSubresourceLocatorSpecs(method)) != null && !scannedResources.contains(subResource)) {
                scannedResources.add(subResource);
                this.read(subResource, operationPath, httpMethod, true, apiConsumes, apiProduces, tags, operation.getParameters(), scannedResources);
                scannedResources.remove(subResource);
            }
            String string = httpMethod = httpMethod == null ? parentMethod : httpMethod;
            if (httpMethod == null) continue;
            if (apiOperation != null) {
                for (String string2 : apiOperation.tags()) {
                    if ("".equals(string2)) continue;
                    operation.tag(string2);
                    this.swagger.tag(new Tag().name(string2));
                }
                operation.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])apiOperation.extensions()));
            }
            if (operation.getConsumes() == null) {
                for (String string3 : apiConsumes) {
                    operation.consumes(string3);
                }
            }
            if (operation.getProduces() == null) {
                for (String string4 : apiProduces) {
                    operation.produces(string4);
                }
            }
            if (operation.getTags() == null) {
                for (String tagString : tags.keySet()) {
                    operation.tag(tagString);
                }
            }
            if (operation.getSecurity() == null) {
                for (SecurityRequirement security : securities) {
                    operation.security(security);
                }
            }
            if ((path = this.swagger.getPath(operationPath)) == null) {
                path = new io.swagger.models.Path();
                this.swagger.path(operationPath, path);
            }
            path.set(httpMethod, operation);
            this.readImplicitParameters(method, operation);
        }
        return this.swagger;
    }

    private void readImplicitParameters(Method method, Operation operation) {
        ApiImplicitParams implicitParams = method.getAnnotation(ApiImplicitParams.class);
        if (implicitParams != null && implicitParams.value().length > 0) {
            for (ApiImplicitParam param : implicitParams.value()) {
                Parameter p = this.readImplicitParam(param);
                if (p == null) continue;
                operation.addParameter(p);
            }
        }
    }

    protected Parameter readImplicitParam(ApiImplicitParam param) {
        PathParameter p;
        if (param.paramType().equalsIgnoreCase("path")) {
            p = new PathParameter();
        } else if (param.paramType().equalsIgnoreCase("query")) {
            p = new QueryParameter();
        } else if (param.paramType().equalsIgnoreCase("form") || param.paramType().equalsIgnoreCase("formData")) {
            p = new FormParameter();
        } else if (param.paramType().equalsIgnoreCase("body")) {
            p = null;
        } else if (param.paramType().equalsIgnoreCase("header")) {
            p = new HeaderParameter();
        } else {
            LOGGER.warn("Unkown implicit parameter type: [" + param.paramType() + "]");
            return null;
        }
        Type type = ReflectionUtils.typeFromString((String)param.dataType());
        return ParameterProcessor.applyAnnotations((Swagger)this.swagger, (Parameter)p, (Type)(type == null ? String.class : type), Collections.singletonList(param));
    }

    protected void readSwaggerConfig(Class<?> cls, SwaggerDefinition config) {
        if (!config.basePath().isEmpty()) {
            this.swagger.setBasePath(config.basePath());
        }
        if (!config.host().isEmpty()) {
            this.swagger.setHost(config.host());
        }
        this.readInfoConfig(config);
        for (String string : config.consumes()) {
            if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
            this.swagger.addConsumes(string);
        }
        for (String string : config.produces()) {
            if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
            this.swagger.addProduces(string);
        }
        if (!config.externalDocs().value().isEmpty()) {
            ExternalDocs externalDocs = this.swagger.getExternalDocs();
            if (externalDocs == null) {
                externalDocs = new ExternalDocs();
                this.swagger.setExternalDocs(externalDocs);
            }
            externalDocs.setDescription(config.externalDocs().value());
            if (!config.externalDocs().url().isEmpty()) {
                externalDocs.setUrl(config.externalDocs().url());
            }
        }
        for (String string : config.tags()) {
            if (string.name().isEmpty()) continue;
            Tag tag = new Tag();
            tag.setName(string.name());
            tag.setDescription(string.description());
            if (!string.externalDocs().value().isEmpty()) {
                tag.setExternalDocs(new ExternalDocs(string.externalDocs().value(), string.externalDocs().url()));
            }
            tag.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])string.extensions()));
            this.swagger.addTag(tag);
        }
        for (String string : config.schemes()) {
            if (string == SwaggerDefinition.Scheme.DEFAULT) continue;
            this.swagger.addScheme(Scheme.forValue((String)string.name()));
        }
    }

    protected void readInfoConfig(SwaggerDefinition config) {
        Info infoConfig = config.info();
        io.swagger.models.Info info = this.swagger.getInfo();
        if (info == null) {
            info = new io.swagger.models.Info();
            this.swagger.setInfo(info);
        }
        if (!infoConfig.description().isEmpty()) {
            info.setDescription(infoConfig.description());
        }
        if (!infoConfig.termsOfService().isEmpty()) {
            info.setTermsOfService(infoConfig.termsOfService());
        }
        if (!infoConfig.title().isEmpty()) {
            info.setTitle(infoConfig.title());
        }
        if (!infoConfig.version().isEmpty()) {
            info.setVersion(infoConfig.version());
        }
        if (!infoConfig.contact().name().isEmpty()) {
            Contact contact = info.getContact();
            if (contact == null) {
                contact = new Contact();
                info.setContact(contact);
            }
            contact.setName(infoConfig.contact().name());
            if (!infoConfig.contact().email().isEmpty()) {
                contact.setEmail(infoConfig.contact().email());
            }
            if (!infoConfig.contact().url().isEmpty()) {
                contact.setUrl(infoConfig.contact().url());
            }
        }
        if (!infoConfig.license().name().isEmpty()) {
            License license = info.getLicense();
            if (license == null) {
                license = new License();
                info.setLicense(license);
            }
            license.setName(infoConfig.license().name());
            if (!infoConfig.license().url().isEmpty()) {
                license.setUrl(infoConfig.license().url());
            }
        }
        info.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])infoConfig.extensions()));
    }

    protected Class<?> getSubResource(Method method) {
        Class<?> type;
        Class<?> rawType = method.getReturnType();
        if (Class.class.equals(rawType)) {
            type = ExtendedSwaggerReader.getClassArgument(method.getGenericReturnType());
            if (type == null) {
                return null;
            }
        } else {
            type = rawType;
        }
        if (type.getAnnotation(Api.class) != null) {
            return type;
        }
        for (Method m : type.getMethods()) {
            if (this.extractOperationMethod(null, m, null) == null) continue;
            return type;
        }
        return null;
    }

    protected Class<?> getSubResourceWithJaxRsSubresourceLocatorSpecs(Method method) {
        Class<?> type;
        Class<?> rawType = method.getReturnType();
        if (Class.class.equals(rawType)) {
            type = ExtendedSwaggerReader.getClassArgument(method.getGenericReturnType());
            if (type == null) {
                return null;
            }
        } else {
            type = rawType;
        }
        if (method.getAnnotation(Path.class) != null && this.extractOperationMethod(null, method, null) == null) {
            return type;
        }
        return null;
    }

    private static Class<?> getClassArgument(Type cls) {
        if (cls instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)cls;
            Type[] args = parameterized.getActualTypeArguments();
            if (args.length != 1) {
                LOGGER.error(String.format("Unexpected class definition: %s", cls));
                return null;
            }
            Type first = args[0];
            if (first instanceof Class) {
                return (Class)first;
            }
            return null;
        }
        LOGGER.error(String.format("Unknown class definition: %s", cls));
        return null;
    }

    protected Set<String> extractTags(Api api) {
        String tagString;
        LinkedHashSet<String> output = new LinkedHashSet<String>();
        boolean hasExplicitTags = false;
        for (String tag : api.tags()) {
            if ("".equals(tag)) continue;
            hasExplicitTags = true;
            output.add(tag);
        }
        if (!hasExplicitTags && !"".equals(tagString = api.value().replace(PATH_DELIMITER, ""))) {
            output.add(tagString);
        }
        return output;
    }

    private String getPath(Path classLevelPath, Path methodLevelPath, String parentPath) {
        String output;
        if (classLevelPath == null && methodLevelPath == null && StringUtils.isEmpty((CharSequence)parentPath)) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        if (parentPath != null && !"".equals(parentPath) && !PATH_DELIMITER.equals(parentPath)) {
            if (!parentPath.startsWith(PATH_DELIMITER)) {
                parentPath = PATH_DELIMITER + parentPath;
            }
            if (parentPath.endsWith(PATH_DELIMITER)) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
            b.append(parentPath);
        }
        if (classLevelPath != null) {
            b.append(classLevelPath);
        }
        if (methodLevelPath != null && !PATH_DELIMITER.equals(methodLevelPath.value())) {
            String methodPath = methodLevelPath.value();
            if (!methodPath.startsWith(PATH_DELIMITER) && !b.toString().endsWith(PATH_DELIMITER)) {
                b.append(PATH_DELIMITER);
            }
            if (methodPath.endsWith(PATH_DELIMITER)) {
                methodPath = methodPath.substring(0, methodPath.length() - 1);
            }
            b.append(methodPath);
        }
        if (!(output = b.toString()).startsWith(PATH_DELIMITER)) {
            output = PATH_DELIMITER + output;
        }
        if (output.endsWith(PATH_DELIMITER) && output.length() > 1) {
            return output.substring(0, output.length() - 1);
        }
        return output;
    }

    private Map<String, Property> parseResponseHeaders(ResponseHeader[] headers) {
        HashMap<String, Property> responseHeaders = null;
        if (headers != null && headers.length > 0) {
            for (ResponseHeader header : headers) {
                Property property;
                String name = header.name();
                if ("".equals(name)) continue;
                if (responseHeaders == null) {
                    responseHeaders = new HashMap<String, Property>();
                }
                String description = header.description();
                Class cls = header.response();
                if (ExtendedSwaggerReader.isVoid(cls) || (property = ModelConverters.getInstance().readAsProperty((Type)cls)) == null) continue;
                Property responseProperty = ContainerWrapper.wrapContainer(header.responseContainer(), property, ContainerWrapper.ARRAY, ContainerWrapper.LIST, ContainerWrapper.SET);
                responseProperty.setDescription(description);
                responseHeaders.put(name, responseProperty);
                this.appendModels(cls);
            }
        }
        return responseHeaders;
    }

    public Operation parseMethod(Method method) {
        return this.parseMethod(method.getDeclaringClass(), method, Collections.emptyList(), Collections.emptyList());
    }

    private Operation parseMethod(Class<?> cls, Method method, List<Parameter> globalParameters, List<ApiResponse> classApiResponses) {
        Produces produces;
        Consumes consumes;
        Property property;
        Operation operation = new Operation();
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        ApiResponses responseAnnotation = (ApiResponses)ReflectionUtils.getAnnotation((Method)method, ApiResponses.class);
        String operationId = method.getName();
        String responseContainer = null;
        Type responseType = null;
        Map<Object, Object> defaultResponseHeaders = new HashMap();
        if (apiOperation != null) {
            int n;
            int n2;
            Object[] objectArray;
            if (apiOperation.hidden()) {
                return null;
            }
            if (!"".equals(apiOperation.nickname())) {
                operationId = apiOperation.nickname();
            }
            defaultResponseHeaders = this.parseResponseHeaders(apiOperation.responseHeaders());
            operation.summary(apiOperation.value()).description(apiOperation.notes());
            if (apiOperation.response() != null && !ExtendedSwaggerReader.isVoid(apiOperation.response())) {
                responseType = apiOperation.response();
            }
            if (!"".equals(apiOperation.responseContainer())) {
                responseContainer = apiOperation.responseContainer();
            }
            if (apiOperation.authorizations() != null) {
                ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
                objectArray = apiOperation.authorizations();
                n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    AuthorizationScope[] scopes;
                    Authorization auth = objectArray[n];
                    if (auth.value() == null || "".equals(auth.value())) continue;
                    SecurityRequirement security = new SecurityRequirement();
                    security.setName(auth.value());
                    for (AuthorizationScope scope : scopes = auth.scopes()) {
                        if (scope.scope() == null || "".equals(scope.scope())) continue;
                        security.addScope(scope.scope());
                    }
                    securities.add(security);
                }
                if (securities.size() > 0) {
                    securities.forEach(arg_0 -> ((Operation)operation).security(arg_0));
                }
            }
            if (apiOperation.consumes() != null && !apiOperation.consumes().isEmpty()) {
                String[] consumesAr = ReaderUtils.splitContentValues((String[])new String[]{apiOperation.consumes()});
                objectArray = consumesAr;
                n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    Authorization consume = objectArray[n];
                    operation.consumes((String)consume);
                }
            }
            if (apiOperation.produces() != null && !apiOperation.produces().isEmpty()) {
                String[] producesAr = ReaderUtils.splitContentValues((String[])new String[]{apiOperation.produces()});
                objectArray = producesAr;
                n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    Authorization produce = objectArray[n];
                    operation.produces((String)produce);
                }
            }
        }
        if (apiOperation != null && StringUtils.isNotEmpty((CharSequence)apiOperation.responseReference())) {
            io.swagger.models.Response response = new io.swagger.models.Response().description(SUCCESSFUL_OPERATION);
            response.schema((Property)new RefProperty(apiOperation.responseReference()));
            operation.addResponse(String.valueOf(apiOperation.code()), response);
        } else if (responseType == null) {
            LOGGER.debug("picking up response class from method " + method);
            responseType = method.getGenericReturnType();
        }
        if (ExtendedSwaggerReader.isValidResponse(responseType) && (property = ModelConverters.getInstance().readAsProperty(responseType)) != null) {
            String[] responseProperty = ContainerWrapper.wrapContainer(responseContainer, property, new ContainerWrapper[0]);
            int responseCode = apiOperation == null ? 200 : apiOperation.code();
            operation.response(responseCode, new io.swagger.models.Response().description(SUCCESSFUL_OPERATION).schema((Property)responseProperty).headers(defaultResponseHeaders));
            this.appendModels(responseType);
        }
        operation.operationId(operationId);
        if ((operation.getConsumes() == null || operation.getConsumes().isEmpty()) && (consumes = (Consumes)ReflectionUtils.getAnnotation((Method)method, Consumes.class)) != null) {
            for (String mediaType : ReaderUtils.splitContentValues((String[])consumes.value())) {
                operation.consumes(mediaType);
            }
        }
        if ((operation.getProduces() == null || operation.getProduces().isEmpty()) && (produces = (Produces)ReflectionUtils.getAnnotation((Method)method, Produces.class)) != null) {
            for (String mediaType : ReaderUtils.splitContentValues((String[])produces.value())) {
                operation.produces(mediaType);
            }
        }
        ArrayList<ApiResponse> apiResponses = new ArrayList<ApiResponse>();
        if (responseAnnotation != null) {
            apiResponses.addAll(Arrays.asList(responseAnnotation.value()));
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        for (Class<?> exceptionType : exceptionTypes) {
            ApiResponses exceptionResponses = (ApiResponses)ReflectionUtils.getAnnotation(exceptionType, ApiResponses.class);
            if (exceptionResponses == null) continue;
            apiResponses.addAll(Arrays.asList(exceptionResponses.value()));
        }
        for (ApiResponse apiResponse : apiResponses) {
            this.addResponse(operation, apiResponse);
        }
        for (ApiResponse apiResponse : classApiResponses) {
            String key;
            String string = key = apiResponse.code() == 0 ? "default" : String.valueOf(apiResponse.code());
            if (operation.getResponses().containsKey(key)) continue;
            this.addResponse(operation, apiResponse);
        }
        if (ReflectionUtils.getAnnotation((Method)method, Deprecated.class) != null) {
            operation.setDeprecated(Boolean.valueOf(true));
        }
        globalParameters.forEach(arg_0 -> ((Operation)operation).parameter(arg_0));
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            JavaType type = TypeFactory.defaultInstance().constructType(genericParameterTypes[i], cls);
            List<Parameter> parameters = this.getParameters((Type)type, Arrays.asList(paramAnnotations[i]));
            parameters.forEach(arg_0 -> ((Operation)operation).parameter(arg_0));
        }
        if (operation.getResponses() == null) {
            io.swagger.models.Response response = new io.swagger.models.Response().description(SUCCESSFUL_OPERATION);
            operation.defaultResponse(response);
        }
        return operation;
    }

    private void addResponse(Operation operation, ApiResponse apiResponse) {
        Map<String, Property> responseHeaders = this.parseResponseHeaders(apiResponse.responseHeaders());
        io.swagger.models.Response response = new io.swagger.models.Response().description(apiResponse.message()).headers(responseHeaders);
        if (apiResponse.code() == 0) {
            operation.defaultResponse(response);
        } else {
            operation.response(apiResponse.code(), response);
        }
        if (StringUtils.isNotEmpty((CharSequence)apiResponse.reference())) {
            response.schema((Property)new RefProperty(apiResponse.reference()));
        } else if (!ExtendedSwaggerReader.isVoid(apiResponse.response())) {
            Class responseType = apiResponse.response();
            Property property = ModelConverters.getInstance().readAsProperty((Type)responseType);
            if (property != null) {
                response.schema(ContainerWrapper.wrapContainer(apiResponse.responseContainer(), property, new ContainerWrapper[0]));
                this.appendModels(responseType);
            }
        }
    }

    private List<Parameter> getParameters(Type type, List<Annotation> annotations) {
        Parameter param;
        Iterator chain = SwaggerExtensions.chain();
        if (!chain.hasNext()) {
            return Collections.emptyList();
        }
        LOGGER.debug("getParameters for " + type);
        HashSet typesToSkip = new HashSet();
        SwaggerExtension extension = (SwaggerExtension)chain.next();
        LOGGER.debug("trying extension " + extension);
        List parameters = extension.extractParameters(annotations, type, typesToSkip, chain);
        if (parameters.size() > 0) {
            ArrayList<Parameter> processed = new ArrayList<Parameter>(parameters.size());
            processed.addAll(parameters.stream().filter(parameter -> ParameterProcessor.applyAnnotations((Swagger)this.swagger, (Parameter)parameter, (Type)type, (List)annotations) != null).collect(Collectors.toList()));
            return processed;
        }
        LOGGER.debug("no parameter found, looking at body params");
        ArrayList<Parameter> body = new ArrayList<Parameter>();
        if (!typesToSkip.contains(type) && (param = ParameterProcessor.applyAnnotations((Swagger)this.swagger, null, (Type)type, annotations)) != null) {
            body.add(param);
        }
        return body;
    }

    public String extractOperationMethod(ApiOperation apiOperation, Method method, Iterator<SwaggerExtension> chain) {
        if (apiOperation != null && apiOperation.httpMethod() != null && !"".equals(apiOperation.httpMethod())) {
            return apiOperation.httpMethod().toLowerCase(Locale.US);
        }
        if (method.getAnnotation(GET.class) != null) {
            return "get";
        }
        if (method.getAnnotation(PUT.class) != null) {
            return "put";
        }
        if (method.getAnnotation(POST.class) != null) {
            return "post";
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return "delete";
        }
        if (method.getAnnotation(OPTIONS.class) != null) {
            return "options";
        }
        if (method.getAnnotation(HEAD.class) != null) {
            return "head";
        }
        if (method.getAnnotation(PATCH.class) != null) {
            return "patch";
        }
        if (method.getAnnotation(HttpMethod.class) != null) {
            HttpMethod httpMethod = method.getAnnotation(HttpMethod.class);
            return httpMethod.value().toLowerCase(Locale.US);
        }
        if (!StringUtils.isEmpty((CharSequence)this.getHttpMethodFromCustomAnnotations(method))) {
            return this.getHttpMethodFromCustomAnnotations(method);
        }
        if (ReflectionUtils.getOverriddenMethod((Method)method) != null) {
            return this.extractOperationMethod(apiOperation, ReflectionUtils.getOverriddenMethod((Method)method), chain);
        }
        if (chain != null && chain.hasNext()) {
            return chain.next().extractOperationMethod(apiOperation, method, chain);
        }
        return null;
    }

    private String getHttpMethodFromCustomAnnotations(Method method) {
        for (Annotation methodAnnotation : method.getAnnotations()) {
            HttpMethod httpMethod = methodAnnotation.annotationType().getAnnotation(HttpMethod.class);
            if (httpMethod == null) continue;
            return httpMethod.value().toLowerCase(Locale.US);
        }
        return null;
    }

    private static Set<Scheme> parseSchemes(String schemes) {
        EnumSet<Scheme> result = EnumSet.noneOf(Scheme.class);
        for (String item : StringUtils.trimToEmpty((String)schemes).split(",")) {
            Scheme scheme = Scheme.forValue((String)StringUtils.trimToNull((String)item));
            if (scheme == null) continue;
            result.add(scheme);
        }
        return result;
    }

    private void appendModels(Type type) {
        Map models = ModelConverters.getInstance().readAll(type);
        for (Map.Entry entry : models.entrySet()) {
            this.swagger.model((String)entry.getKey(), (Model)entry.getValue());
        }
    }

    private static boolean isVoid(Type type) {
        Class cls = TypeFactory.defaultInstance().constructType(type).getRawClass();
        return Void.class.isAssignableFrom(cls) || Void.TYPE.isAssignableFrom(cls);
    }

    private boolean isIgnored(String path) {
        for (String item : this.config.getIgnoredRoutes()) {
            int length = item.length();
            if (!path.startsWith(item) || path.length() != length && !path.startsWith(PATH_DELIMITER, length)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidResponse(Type type) {
        if (type == null) {
            return false;
        }
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        if (ExtendedSwaggerReader.isVoid((Type)javaType)) {
            return false;
        }
        Class cls = javaType.getRawClass();
        return !Response.class.isAssignableFrom(cls) && !ExtendedSwaggerReader.isResourceClass(cls);
    }

    private static boolean isResourceClass(Class<?> cls) {
        return cls.getAnnotation(Api.class) != null;
    }

    public ReaderConfig getConfig() {
        return this.config;
    }

    static enum ContainerWrapper {
        LIST("list"){

            @Override
            protected Property doWrap(Property property) {
                return new ArrayProperty(property);
            }
        }
        ,
        ARRAY("array"){

            @Override
            protected Property doWrap(Property property) {
                return new ArrayProperty(property);
            }
        }
        ,
        MAP("map"){

            @Override
            protected Property doWrap(Property property) {
                return new MapProperty(property);
            }
        }
        ,
        SET("set"){

            @Override
            protected Property doWrap(Property property) {
                ArrayProperty arrayProperty = new ArrayProperty(property);
                arrayProperty.setUniqueItems(Boolean.valueOf(true));
                return arrayProperty;
            }
        };

        private final String container;

        private ContainerWrapper(String container) {
            this.container = container;
        }

        public static Property wrapContainer(String container, Property property, ContainerWrapper ... allowed) {
            EnumSet<ContainerWrapper> tmp = allowed.length > 0 ? EnumSet.copyOf(Arrays.asList(allowed)) : EnumSet.allOf(ContainerWrapper.class);
            for (ContainerWrapper wrapper : tmp) {
                Property prop = wrapper.wrap(container, property);
                if (prop == null) continue;
                return prop;
            }
            return property;
        }

        public Property wrap(String container, Property property) {
            if (this.container.equalsIgnoreCase(container)) {
                return this.doWrap(property);
            }
            return null;
        }

        protected abstract Property doWrap(Property var1);
    }
}

