/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.HttpWsServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerReqRespStateManager;
import org.wso2.transport.http.netty.message.BlockingEntityCollector;
import org.wso2.transport.http.netty.message.DefaultFullHttpMessageFuture;
import org.wso2.transport.http.netty.message.DefaultObservable;
import org.wso2.transport.http.netty.message.EntityCollector;
import org.wso2.transport.http.netty.message.FullHttpMessageFuture;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpPipeliningFuture;
import org.wso2.transport.http.netty.message.Listener;
import org.wso2.transport.http.netty.message.MessageFuture;
import org.wso2.transport.http.netty.message.Observable;

public class HttpCarbonMessage {
    protected HttpMessage httpMessage;
    private EntityCollector blockingEntityCollector;
    private Map<String, Object> properties = new HashMap<String, Object>(64);
    private MessageFuture messageFuture;
    private final ServerConnectorFuture httpOutboundRespFuture = new HttpWsServerConnectorFuture();
    private final DefaultHttpResponseFuture httpOutboundRespStatusFuture = new DefaultHttpResponseFuture();
    private final Observable contentObservable = new DefaultObservable();
    private IOException ioException;
    public ListenerReqRespStateManager listenerReqRespStateManager;
    private Http2MessageStateContext http2MessageStateContext;
    private FullHttpMessageFuture fullHttpMessageFuture;
    private long sequenceId;
    private ChannelHandlerContext sourceContext;
    private ChannelHandlerContext targetContext;
    private HttpPipeliningFuture pipeliningFuture;
    private boolean keepAlive;
    private boolean pipeliningEnabled;
    private boolean passthrough = false;
    private boolean lastHttpContentArrived = false;
    private String httpVersion;
    private String httpMethod;
    private String requestUrl;
    private Integer httpStatusCode;

    public HttpCarbonMessage(HttpMessage httpMessage, Listener contentListener) {
        this.httpMessage = httpMessage;
        this.setBlockingEntityCollector(new BlockingEntityCollector(300000));
        this.contentObservable.setListener(contentListener);
    }

    public HttpCarbonMessage(HttpMessage httpMessage, int maxWaitTime, Listener contentListener) {
        this.httpMessage = httpMessage;
        this.setBlockingEntityCollector(new BlockingEntityCollector(maxWaitTime));
        this.contentObservable.setListener(contentListener);
    }

    public HttpCarbonMessage(HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
        this.setBlockingEntityCollector(new BlockingEntityCollector(300000));
    }

    public synchronized void addHttpContent(HttpContent httpContent) {
        this.contentObservable.notifyAddListener(httpContent);
        if (this.messageFuture != null) {
            if (this.ioException != null) {
                this.blockingEntityCollector.addHttpContent((HttpContent)new DefaultLastHttpContent());
                this.messageFuture.notifyMessageListener(this.blockingEntityCollector.getHttpContent());
                this.removeMessageFuture();
                throw new RuntimeException(this.getIoException());
            }
            this.blockingEntityCollector.addHttpContent(httpContent);
            if (this.messageFuture.isMessageListenerSet()) {
                this.messageFuture.notifyMessageListener(this.blockingEntityCollector.getHttpContent());
                this.contentObservable.notifyGetListener(httpContent);
            }
            if (httpContent instanceof LastHttpContent) {
                this.removeMessageFuture();
            }
        } else {
            if (this.ioException != null) {
                this.blockingEntityCollector.addHttpContent((HttpContent)new DefaultLastHttpContent());
                throw new RuntimeException(this.getIoException());
            }
            this.blockingEntityCollector.addHttpContent(httpContent);
        }
    }

    public HttpContent getHttpContent() {
        HttpContent httpContent = this.blockingEntityCollector.getHttpContent();
        this.contentObservable.notifyGetListener(httpContent);
        return httpContent;
    }

    public synchronized MessageFuture getHttpContentAsync() {
        this.messageFuture = new MessageFuture(this);
        return this.messageFuture;
    }

    @Deprecated
    public ByteBuf getMessageBody() {
        return this.blockingEntityCollector.getMessageBody();
    }

    public boolean isEmpty() {
        return this.blockingEntityCollector.isEmpty();
    }

    public long countMessageLengthTill(long maxLength) throws IllegalStateException {
        return this.blockingEntityCollector.countMessageLengthTill(maxLength);
    }

    public long getFullMessageLength() {
        return this.blockingEntityCollector.getFullMessageLength();
    }

    @Deprecated
    public void addMessageBody(ByteBuffer msgBody) {
        this.blockingEntityCollector.addMessageBody(msgBody);
    }

    public void completeMessage() {
        this.blockingEntityCollector.completeMessage();
    }

    public HttpHeaders getHeaders() {
        return this.httpMessage.headers();
    }

    public String getHeader(String key) {
        return this.httpMessage.headers().get(key);
    }

    public void setHeader(String key, String value) {
        this.httpMessage.headers().set(key, (Object)value);
    }

    public void setHeader(String key, Object value) {
        this.httpMessage.headers().set(key, value);
    }

    public void setHeaders(HttpHeaders httpHeaders) {
        this.httpMessage.headers().setAll(httpHeaders);
    }

    public void removeHeader(String key) {
        this.httpMessage.headers().remove(key);
    }

    public Object getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public synchronized void removeMessageFuture() {
        this.messageFuture = null;
        this.passthrough = false;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public Integer getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    private void setBlockingEntityCollector(BlockingEntityCollector blockingEntityCollector) {
        this.blockingEntityCollector = blockingEntityCollector;
    }

    public ServerConnectorFuture getHttpResponseFuture() {
        return this.httpOutboundRespFuture;
    }

    public HttpResponseFuture getHttpOutboundRespStatusFuture() {
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseFuture respond(HttpCarbonMessage httpCarbonMessage) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(httpCarbonMessage);
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseFuture pushResponse(HttpCarbonMessage httpCarbonMessage, Http2PushPromise pushPromise) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(httpCarbonMessage, pushPromise);
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseFuture pushPromise(Http2PushPromise pushPromise) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(pushPromise);
        return this.httpOutboundRespStatusFuture;
    }

    public HttpCarbonMessage cloneCarbonMessageWithOutData() {
        HttpCarbonMessage newCarbonMessage = this.getNewHttpCarbonMessage();
        Map<String, Object> propertiesMap = this.getProperties();
        propertiesMap.forEach(newCarbonMessage::setProperty);
        newCarbonMessage.setHttpStatusCode(this.getHttpStatusCode());
        newCarbonMessage.setHttpMethod(this.getHttpMethod());
        newCarbonMessage.setRequestUrl(this.getRequestUrl());
        newCarbonMessage.setHttpVersion(this.getHttpVersion());
        return newCarbonMessage;
    }

    private HttpCarbonMessage getNewHttpCarbonMessage() {
        DefaultHttpHeaders httpHeaders;
        DefaultFullHttpResponse newHttpMessage;
        if (this.httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)this.httpMessage;
            newHttpMessage = new DefaultHttpRequest(this.httpMessage.protocolVersion(), ((HttpRequest)this.httpMessage).method(), httpRequest.uri());
            httpHeaders = new DefaultHttpHeaders();
            List headerList = this.httpMessage.headers().entries();
            for (Map.Entry entry : headerList) {
                httpHeaders.add((String)entry.getKey(), entry.getValue());
            }
        } else {
            HttpResponse httpResponse = (HttpResponse)this.httpMessage;
            newHttpMessage = new DefaultFullHttpResponse(this.httpMessage.protocolVersion(), httpResponse.status());
            httpHeaders = new DefaultHttpHeaders();
            List headerList = this.httpMessage.headers().entries();
            for (Map.Entry entry : headerList) {
                httpHeaders.add((String)entry.getKey(), entry.getValue());
            }
        }
        HttpCarbonMessage httpCarbonMessage = new HttpCarbonMessage((HttpMessage)newHttpMessage);
        httpCarbonMessage.getHeaders().set((HttpHeaders)httpHeaders);
        return httpCarbonMessage;
    }

    public void waitAndReleaseAllEntities() {
        this.blockingEntityCollector.waitAndReleaseAllEntities();
    }

    public EntityCollector getBlockingEntityCollector() {
        return this.blockingEntityCollector;
    }

    public HttpRequest getNettyHttpRequest() {
        return (HttpRequest)this.httpMessage;
    }

    public HttpResponse getNettyHttpResponse() {
        return (HttpResponse)this.httpMessage;
    }

    public synchronized IOException getIoException() {
        return this.ioException;
    }

    public synchronized void setIoException(IOException ioException) {
        this.ioException = ioException;
    }

    public Http2MessageStateContext getHttp2MessageStateContext() {
        return this.http2MessageStateContext;
    }

    public void setHttp2MessageStateContext(Http2MessageStateContext http2MessageStateContext) {
        this.http2MessageStateContext = http2MessageStateContext;
    }

    public long getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
    }

    public ChannelHandlerContext getSourceContext() {
        return this.sourceContext;
    }

    public void setSourceContext(ChannelHandlerContext sourceContext) {
        this.sourceContext = sourceContext;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isPipeliningEnabled() {
        return this.pipeliningEnabled;
    }

    public boolean is100ContinueExpected() {
        return HttpUtil.is100ContinueExpected((HttpMessage)this.httpMessage);
    }

    public void setPipeliningEnabled(boolean pipeliningEnabled) {
        this.pipeliningEnabled = pipeliningEnabled;
    }

    public HttpPipeliningFuture getPipeliningFuture() {
        return this.pipeliningFuture;
    }

    public void setPipeliningFuture(HttpPipeliningFuture pipeliningFuture) {
        this.pipeliningFuture = pipeliningFuture;
    }

    public void removeInboundContentListener() {
        this.contentObservable.notifyReadInterest();
        String httpVersion = this.getHttpVersion();
        if ("1.1".equalsIgnoreCase(httpVersion)) {
            this.contentObservable.removeListener();
        }
    }

    public boolean isPassthrough() {
        return this.passthrough;
    }

    public void setPassthrough(boolean passthrough) {
        this.passthrough = passthrough;
    }

    public void setTargetContext(ChannelHandlerContext targetContext) {
        this.targetContext = targetContext;
    }

    public ChannelHandlerContext getTargetContext() {
        return this.targetContext;
    }

    public synchronized FullHttpMessageFuture getFullHttpCarbonMessage() {
        this.removeInboundContentListener();
        this.fullHttpMessageFuture = new DefaultFullHttpMessageFuture(this);
        return this.fullHttpMessageFuture;
    }

    public synchronized void setLastHttpContentArrived() {
        this.lastHttpContentArrived = true;
        if (this.fullHttpMessageFuture != null) {
            this.fullHttpMessageFuture.notifySuccess();
        }
    }

    synchronized boolean isLastHttpContentArrived() {
        return this.lastHttpContentArrived;
    }

    public synchronized void notifyContentFailure(Exception exception) {
        if (this.fullHttpMessageFuture != null) {
            this.fullHttpMessageFuture.notifyFailure(exception);
        }
    }

    public Listener getListener() {
        return this.contentObservable.getListener();
    }
}

