/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.channel.pool;

import io.netty.channel.EventLoopGroup;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.PoolableTargetChannelFactory;

public class PoolableTargetChannelFactoryPerSrcHndlr
implements PoolableObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PoolableTargetChannelFactoryPerSrcHndlr.class);
    private final GenericObjectPool genericObjectPool;
    private final EventLoopGroup clientEventGroup;
    private final Class eventLoopClass;
    private final PoolableTargetChannelFactory channelFactory;

    PoolableTargetChannelFactoryPerSrcHndlr(GenericObjectPool genericObjectPool, PoolableTargetChannelFactory channelFactory, EventLoopGroup clientEventGroup, Class eventLoopClass) {
        this.genericObjectPool = genericObjectPool;
        this.channelFactory = channelFactory;
        this.clientEventGroup = clientEventGroup;
        this.eventLoopClass = eventLoopClass;
    }

    public Object makeObject() throws Exception {
        this.channelFactory.setEventLoopClass(this.eventLoopClass);
        this.channelFactory.setEventLoopGroup(this.clientEventGroup);
        TargetChannel targetChannel = (TargetChannel)this.genericObjectPool.borrowObject();
        LOG.debug("Created channel: {}", (Object)targetChannel);
        return targetChannel;
    }

    public void destroyObject(Object o) throws Exception {
        if (((TargetChannel)o).getChannel().isActive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Original Channel {} is returned to the pool. ", (Object)((TargetChannel)o).getChannel().id());
            }
            this.genericObjectPool.returnObject(o);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Original Channel is destroyed. ");
            }
            this.genericObjectPool.invalidateObject(o);
        }
    }

    public boolean validateObject(Object o) {
        if (((TargetChannel)o).getChannel() != null) {
            boolean answer = ((TargetChannel)o).getChannel().isActive();
            LOG.debug("Validating channel: {} -> {}", o, (Object)answer);
            return answer;
        }
        return true;
    }

    public void activateObject(Object o) {
    }

    public void passivateObject(Object o) {
    }
}

