/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.wso2.transport.http.netty.contract.config.KeepAliveConfig;
import org.wso2.transport.http.netty.contract.config.ProxyServerConfiguration;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contractimpl.common.BackPressureHandler;
import org.wso2.transport.http.netty.contractimpl.common.FrameLogger;
import org.wso2.transport.http.netty.contractimpl.common.HttpRoute;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.contractimpl.common.ssl.SSLHandlerFactory;
import org.wso2.transport.http.netty.contractimpl.listener.HttpTraceLoggingHandler;
import org.wso2.transport.http.netty.contractimpl.sender.CertificateValidationHandler;
import org.wso2.transport.http.netty.contractimpl.sender.ConnectionAvailabilityFuture;
import org.wso2.transport.http.netty.contractimpl.sender.OCSPStaplingHandler;
import org.wso2.transport.http.netty.contractimpl.sender.SslHandshakeCompletionHandlerForClient;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.contractimpl.sender.http2.ClientFrameListener;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ConnectionManager;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2TargetHandler;

public class HttpClientChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private TargetHandler targetHandler;
    private boolean httpTraceLogEnabled;
    private KeepAliveConfig keepAliveConfig;
    private ProxyServerConfiguration proxyServerConfiguration;
    private Http2ConnectionManager http2ConnectionManager;
    private boolean http2 = false;
    private Http2ConnectionHandler http2ConnectionHandler;
    private ClientFrameListener clientFrameListener;
    private Http2TargetHandler http2TargetHandler;
    private Http2Connection connection;
    private SSLConfig sslConfig;
    private HttpRoute httpRoute;
    private SenderConfiguration senderConfiguration;
    private ConnectionAvailabilityFuture connectionAvailabilityFuture;
    private SSLHandlerFactory sslHandlerFactory;

    public HttpClientChannelInitializer(SenderConfiguration senderConfiguration, HttpRoute httpRoute, ConnectionManager connectionManager, ConnectionAvailabilityFuture connectionAvailabilityFuture) {
        this.httpTraceLogEnabled = senderConfiguration.isHttpTraceLogEnabled();
        this.keepAliveConfig = senderConfiguration.getKeepAliveConfig();
        this.proxyServerConfiguration = senderConfiguration.getProxyServerConfiguration();
        this.http2ConnectionManager = connectionManager.getHttp2ConnectionManager();
        this.senderConfiguration = senderConfiguration;
        this.httpRoute = httpRoute;
        this.sslConfig = senderConfiguration.getClientSSLConfig();
        this.connectionAvailabilityFuture = connectionAvailabilityFuture;
        String httpVersion = senderConfiguration.getHttpVersion();
        if ("2.0".equals(httpVersion)) {
            this.http2 = true;
        }
        this.connection = new DefaultHttp2Connection(false);
        this.clientFrameListener = new ClientFrameListener();
        DelegatingDecompressorFrameListener frameListener = new DelegatingDecompressorFrameListener(this.connection, (Http2FrameListener)this.clientFrameListener);
        Http2ConnectionHandlerBuilder connectionHandlerBuilder = new Http2ConnectionHandlerBuilder();
        if (this.httpTraceLogEnabled) {
            connectionHandlerBuilder.frameLogger((Http2FrameLogger)new FrameLogger(LogLevel.TRACE, "http.tracelog.upstream"));
        }
        this.http2ConnectionHandler = connectionHandlerBuilder.connection(this.connection).frameListener((Http2FrameListener)frameListener).build();
        this.http2TargetHandler = new Http2TargetHandler(this.connection, this.http2ConnectionHandler.encoder());
        if (this.sslConfig != null) {
            this.sslHandlerFactory = new SSLHandlerFactory(this.sslConfig);
        }
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        ChannelPipeline clientPipeline = socketChannel.pipeline();
        this.configureProxyServer(clientPipeline);
        HttpClientCodec sourceCodec = new HttpClientCodec();
        this.targetHandler = new TargetHandler();
        this.targetHandler.setHttp2TargetHandler(this.http2TargetHandler);
        this.targetHandler.setKeepAliveConfig(this.getKeepAliveConfig());
        if (this.http2) {
            if (this.sslConfig != null) {
                this.configureSslForHttp2(socketChannel, clientPipeline, this.sslConfig);
            } else if (this.senderConfiguration.isForceHttp2()) {
                this.configureHttp2Pipeline(clientPipeline);
            } else {
                this.configureHttp2UpgradePipeline(clientPipeline, sourceCodec, this.targetHandler);
            }
        } else if (this.sslConfig != null) {
            this.connectionAvailabilityFuture.setSSLEnabled(true);
            SSLEngine sslEngine = Util.configureHttpPipelineForSSL(socketChannel, this.httpRoute.getHost(), this.httpRoute.getPort(), this.sslConfig);
            clientPipeline.addLast("sslHandshakeCompletionHandler", (ChannelHandler)new SslHandshakeCompletionHandlerForClient(this.connectionAvailabilityFuture, this, this.targetHandler, sslEngine));
        } else {
            this.configureHttpPipeline(clientPipeline, this.targetHandler);
        }
    }

    private void configureProxyServer(ChannelPipeline clientPipeline) {
        if (this.proxyServerConfiguration != null && this.sslConfig != null) {
            if (this.proxyServerConfiguration.getProxyUsername() != null && this.proxyServerConfiguration.getProxyPassword() != null) {
                clientPipeline.addLast("proxyServerHandler", (ChannelHandler)new HttpProxyHandler((SocketAddress)this.proxyServerConfiguration.getInetSocketAddress(), this.proxyServerConfiguration.getProxyUsername(), this.proxyServerConfiguration.getProxyPassword()));
            } else {
                clientPipeline.addLast("proxyServerHandler", (ChannelHandler)new HttpProxyHandler((SocketAddress)this.proxyServerConfiguration.getInetSocketAddress()));
            }
        }
    }

    private void configureSslForHttp2(SocketChannel ch, ChannelPipeline clientPipeline, SSLConfig sslConfig) throws SSLException {
        this.connectionAvailabilityFuture.setSSLEnabled(true);
        if (sslConfig.isOcspStaplingEnabled()) {
            ReferenceCountedOpenSslContext referenceCountedOpenSslContext = (ReferenceCountedOpenSslContext)this.sslHandlerFactory.createHttp2TLSContextForClient(sslConfig.isOcspStaplingEnabled());
            if (referenceCountedOpenSslContext != null) {
                SslHandler sslHandler = referenceCountedOpenSslContext.newHandler(ch.alloc());
                ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
                Util.setSslHandshakeTimeOut(sslConfig, sslHandler);
                ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                ch.pipeline().addLast(new ChannelHandler[]{new OCSPStaplingHandler(engine)});
            }
        } else {
            this.sslHandlerFactory.createSSLContextFromKeystores(false);
            SslContext sslCtx = this.sslHandlerFactory.createHttp2TLSContextForClient(false);
            SslHandler sslHandler = sslCtx.newHandler(ch.alloc(), this.httpRoute.getHost(), this.httpRoute.getPort());
            SSLEngine sslEngine = sslHandler.engine();
            this.sslHandlerFactory.setSNIServerNames(sslEngine, this.httpRoute.getHost());
            if (sslConfig.isHostNameVerificationEnabled()) {
                Util.setHostNameVerfication(sslEngine);
            }
            Util.setSslHandshakeTimeOut(sslConfig, sslHandler);
            clientPipeline.addLast(new ChannelHandler[]{sslHandler});
            if (sslConfig.isValidateCertEnabled()) {
                clientPipeline.addLast("certificateValidation", (ChannelHandler)new CertificateValidationHandler(sslEngine, sslConfig.getCacheValidityPeriod(), sslConfig.getCacheSize()));
            }
        }
        clientPipeline.addLast(new ChannelHandler[]{new Http2PipelineConfiguratorForClient(this.targetHandler, this.connectionAvailabilityFuture)});
    }

    public TargetHandler getTargetHandler() {
        return this.targetHandler;
    }

    public Http2ConnectionManager getHttp2ConnectionManager() {
        return this.http2ConnectionManager;
    }

    private void configureHttp2UpgradePipeline(ChannelPipeline pipeline, HttpClientCodec sourceCodec, TargetHandler targetHandler) {
        pipeline.addLast(new ChannelHandler[]{sourceCodec});
        this.addCommonHandlers(pipeline);
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec(this.http2ConnectionHandler);
        HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, Integer.MAX_VALUE);
        pipeline.addLast("Http2UpgradeHandler", (ChannelHandler)upgradeHandler);
        pipeline.addLast("targetHandler", (ChannelHandler)targetHandler);
    }

    private void configureHttp2Pipeline(ChannelPipeline pipeline) {
        pipeline.addLast("connectionHandler", (ChannelHandler)this.http2ConnectionHandler);
        pipeline.addLast("http2TargetHandler", (ChannelHandler)this.http2TargetHandler);
        pipeline.addLast("deCompressor", (ChannelHandler)new HttpContentDecompressor());
    }

    public void configureHttpPipeline(ChannelPipeline pipeline, TargetHandler targetHandler) {
        pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec());
        this.addCommonHandlers(pipeline);
        pipeline.addLast("BackPressureHandler", (ChannelHandler)new BackPressureHandler());
        pipeline.addLast("targetHandler", (ChannelHandler)targetHandler);
    }

    private void addCommonHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("deCompressor", (ChannelHandler)new HttpContentDecompressor());
        if (this.httpTraceLogEnabled) {
            pipeline.addLast("http-trace-logger", (ChannelHandler)new HttpTraceLoggingHandler("http.tracelog.upstream"));
        }
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public KeepAliveConfig getKeepAliveConfig() {
        return this.keepAliveConfig;
    }

    public void setHttp2ClientChannel(Http2ClientChannel http2ClientChannel) {
        this.http2TargetHandler.setHttp2ClientChannel(http2ClientChannel);
        this.clientFrameListener.setHttp2ClientChannel(http2ClientChannel);
    }

    class Http2PipelineConfiguratorForClient
    extends ApplicationProtocolNegotiationHandler {
        private TargetHandler targetHandler;
        private ConnectionAvailabilityFuture connectionAvailabilityFuture;

        public Http2PipelineConfiguratorForClient(TargetHandler targetHandler, ConnectionAvailabilityFuture connectionAvailabilityFuture) {
            super("http/1.1");
            this.targetHandler = targetHandler;
            this.connectionAvailabilityFuture = connectionAvailabilityFuture;
        }

        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            if ("h2".equals(protocol)) {
                HttpClientChannelInitializer.this.configureHttp2Pipeline(ctx.pipeline());
                this.connectionAvailabilityFuture.notifySuccess("h2");
            } else if ("http/1.1".equals(protocol)) {
                HttpClientChannelInitializer.this.configureHttpPipeline(ctx.pipeline(), this.targetHandler);
                this.connectionAvailabilityFuture.notifySuccess("http");
            } else {
                throw new IllegalStateException("Unknown protocol: " + protocol);
            }
        }

        protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) {
            this.connectionAvailabilityFuture.notifyFailure(cause);
            ctx.close();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (ctx != null && ctx.channel().isActive()) {
                ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }
}

