/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states.http2;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.exceptions.EndpointTimeOutException;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.Http2OutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.SendingEntityBody;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.SendingHeaders;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class EntityBodyReceived
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(EntityBodyReceived.class);
    private final Http2MessageStateContext http2MessageStateContext;

    public EntityBodyReceived(Http2MessageStateContext http2MessageStateContext) {
        this.http2MessageStateContext = http2MessageStateContext;
    }

    @Override
    public void readInboundRequestHeaders(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) {
        LOG.warn("readInboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Http2SourceHandler http2SourceHandler, Http2DataFrame dataFrame) {
        LOG.warn("readInboundRequestBody is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseHeaders(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) {
        LOG.warn("writeOutboundResponseHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        if (this.http2MessageStateContext.isHeadersSent()) {
            this.http2MessageStateContext.setListenerState(new SendingEntityBody(http2OutboundRespListener, this.http2MessageStateContext));
            this.http2MessageStateContext.getListenerState().writeOutboundResponseBody(http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
        } else {
            this.http2MessageStateContext.setListenerState(new SendingHeaders(http2OutboundRespListener, this.http2MessageStateContext));
            this.http2MessageStateContext.getListenerState().writeOutboundResponseHeaders(http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
        }
    }

    @Override
    public void writeOutboundPromise(Http2OutboundRespListener http2OutboundRespListener, Http2PushPromise pushPromise) throws Http2Exception {
        Http2StateUtil.writeHttp2Promise(pushPromise, http2OutboundRespListener.getChannelHandlerContext(), http2OutboundRespListener.getConnection(), http2OutboundRespListener.getEncoder(), http2OutboundRespListener.getInboundRequestMsg(), http2OutboundRespListener.getInboundRequestMsg().getHttpOutboundRespStatusFuture(), http2OutboundRespListener.getOriginalStreamId());
    }

    @Override
    public void handleStreamTimeout(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        try {
            serverConnectorFuture.notifyErrorListener(new EndpointTimeOutException("Idle timeout triggered before initiating outbound response", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
        }
        catch (ServerConnectorException e) {
            LOG.error("Idle timeout triggered before initiating outbound response:" + e.getMessage());
        }
        Http2StateUtil.sendRequestTimeoutResponse(ctx, http2OutboundRespListener, streamId, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer((CharSequence)"Stream timed out", (Charset)CharsetUtil.UTF_8), false, false);
    }
}

