/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.HttpOutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.Expect100ContinueHeaderReceived;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.ReceivingEntityBody;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.internal.HttpTransportContextHolder;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ReceivingHeaders
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingHeaders.class);
    private final SourceHandler sourceHandler;
    private final HandlerExecutor handlerExecutor;
    private final ListenerReqRespStateManager listenerReqRespStateManager;
    private HttpCarbonMessage inboundRequestMsg;
    private float httpVersion;

    public ReceivingHeaders(ListenerReqRespStateManager listenerReqRespStateManager, SourceHandler sourceHandler) {
        this.listenerReqRespStateManager = listenerReqRespStateManager;
        this.sourceHandler = sourceHandler;
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        this.inboundRequestMsg = inboundRequestMsg;
        this.httpVersion = Float.parseFloat(inboundRequestMsg.getHttpVersion());
        boolean continueRequest = Util.is100ContinueRequest(inboundRequestMsg);
        if (continueRequest) {
            this.listenerReqRespStateManager.state = new Expect100ContinueHeaderReceived(this.listenerReqRespStateManager, this.sourceHandler, inboundRequestMsg, this.httpVersion);
        }
        this.notifyRequestListener(inboundRequestMsg);
        if (inboundRequestHeaders.decoderResult().isFailure()) {
            LOG.warn(inboundRequestHeaders.decoderResult().cause().getMessage());
        }
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceRequestReceiving(inboundRequestMsg);
        }
    }

    private void notifyRequestListener(HttpCarbonMessage httpRequestMsg) {
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceRequestReceiving(httpRequestMsg);
        }
        if (this.sourceHandler.getServerConnectorFuture() != null) {
            try {
                ServerConnectorFuture outboundRespFuture = httpRequestMsg.getHttpResponseFuture();
                outboundRespFuture.setHttpConnectorListener(new HttpOutboundRespListener(httpRequestMsg, this.sourceHandler));
                httpRequestMsg.setSourceContext(this.sourceHandler.getInboundChannelContext());
                this.sourceHandler.getServerConnectorFuture().notifyHttpListener(httpRequestMsg);
            }
            catch (Exception e) {
                LOG.error("Error while notifying listeners", (Throwable)e);
            }
        } else {
            LOG.error("Cannot find registered listener to forward the message");
        }
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        this.listenerReqRespStateManager.state = new ReceivingEntityBody(this.listenerReqRespStateManager, this.inboundRequestMsg, this.sourceHandler, this.httpVersion);
        this.listenerReqRespStateManager.readInboundRequestBody(inboundRequestEntityBody);
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundResponseListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        StateUtil.respondToIncompleteRequest(this.sourceHandler.getInboundChannelContext().channel(), outboundResponseListener, this.listenerReqRespStateManager, outboundResponseMsg, httpContent, "Remote client closed the connection while reading inbound request headers");
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        StateUtil.handleIncompleteInboundMessage(this.inboundRequestMsg, "Remote client closed the connection while reading inbound request headers");
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        ChannelFuture outboundRespFuture = StateUtil.sendRequestTimeoutResponse(ctx, HttpResponseStatus.REQUEST_TIMEOUT, Unpooled.EMPTY_BUFFER, 0, this.httpVersion, this.sourceHandler.getServerName());
        outboundRespFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            Throwable cause = channelFuture.cause();
            if (cause != null) {
                LOG.warn("Failed to send: {}", (Object)cause.getMessage());
            }
            ctx.close();
            StateUtil.handleIncompleteInboundMessage(this.inboundRequestMsg, "Idle timeout triggered while reading inbound request headers");
        }));
        return outboundRespFuture;
    }
}

