/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorException;
import org.wso2.transport.http.netty.contractimpl.listener.WebSocketServerCompressionHandler;
import org.wso2.transport.http.netty.contractimpl.websocket.message.DefaultWebSocketHandshaker;
import org.wso2.transport.http.netty.message.DefaultListener;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;
import org.wso2.transport.http.netty.message.Listener;
import org.wso2.transport.http.netty.message.PooledDataStreamerFactory;

public class WebSocketServerHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketServerHandshakeHandler.class);
    private final ServerConnectorFuture serverConnectorFuture;
    private final String interfaceId;
    private boolean webSocketCompressionEnabled;

    public WebSocketServerHandshakeHandler(ServerConnectorFuture serverConnectorFuture, String interfaceId, boolean webSocketCompressionEnabled) {
        this.serverConnectorFuture = serverConnectorFuture;
        this.interfaceId = interfaceId;
        this.webSocketCompressionEnabled = webSocketCompressionEnabled;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            HttpMethod requestMethod = httpRequest.method();
            if (this.containsUpgradeHeaders(httpRequest)) {
                if (HttpMethod.GET == requestMethod) {
                    ChannelPipeline pipeline;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Upgrading the connection from Http to WebSocket for channel : {}", (Object)ctx.channel());
                    }
                    if ((pipeline = ctx.pipeline()).get("BackPressureHandler") != null) {
                        pipeline.remove("BackPressureHandler");
                    }
                    pipeline.remove("SourceHandler");
                    ChannelHandlerContext decoderCtx = pipeline.context(HttpRequestDecoder.class);
                    pipeline.addAfter(decoderCtx.name(), "HTTP_OBJECT_AGGREGATOR", (ChannelHandler)new HttpObjectAggregator(8192));
                    if (this.webSocketCompressionEnabled) {
                        pipeline.addAfter("HTTP_OBJECT_AGGREGATOR", "websocket-compression-handler", (ChannelHandler)new WebSocketServerCompressionHandler());
                        pipeline.addAfter("websocket-compression-handler", Utf8FrameValidator.class.getName(), (ChannelHandler)new Utf8FrameValidator());
                    } else {
                        pipeline.addAfter("HTTP_OBJECT_AGGREGATOR", Utf8FrameValidator.class.getName(), (ChannelHandler)new Utf8FrameValidator());
                    }
                    pipeline.addAfter(Utf8FrameValidator.class.getName(), "handshake", (ChannelHandler)new SimpleChannelInboundHandler<FullHttpRequest>(){

                        protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
                            ctx.pipeline().remove((ChannelHandler)this);
                            WebSocketServerHandshakeHandler.this.handleWebSocketHandshake(msg, ctx);
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.pipeline().remove((ChannelHandler)this);
                            ctx.fireExceptionCaught(cause);
                        }

                        public void channelInactive(ChannelHandlerContext ctx) {
                            ctx.fireChannelInactive();
                        }
                    });
                    decoderCtx.fireChannelRead(msg);
                } else {
                    DefaultHttpResponse badRequestResponse = new DefaultHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.BAD_REQUEST);
                    ctx.writeAndFlush((Object)badRequestResponse).addListener(future -> ctx.close());
                }
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        LOG.error("Error during WebSocket server handshake", cause);
    }

    private boolean containsUpgradeHeaders(HttpRequest httpRequest) {
        HttpHeaders headers = httpRequest.headers();
        return headers.containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true) && headers.containsValue((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
    }

    private void handleWebSocketHandshake(FullHttpRequest fullHttpRequest, ChannelHandlerContext ctx) throws WebSocketConnectorException {
        String extensionsHeader = fullHttpRequest.headers().getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
        DefaultWebSocketHandshaker webSocketHandshaker = new DefaultWebSocketHandshaker(ctx, this.serverConnectorFuture, fullHttpRequest, fullHttpRequest.uri(), extensionsHeader != null);
        webSocketHandshaker.setHttpCarbonRequest(this.setupHttpCarbonRequest((HttpRequest)fullHttpRequest, ctx));
        ctx.channel().config().setAutoRead(false);
        this.serverConnectorFuture.notifyWebSocketListener(webSocketHandshaker);
    }

    private HttpCarbonRequest setupHttpCarbonRequest(HttpRequest httpRequest, ChannelHandlerContext ctx) {
        HttpCarbonRequest sourceReqCmsg = new HttpCarbonRequest(httpRequest, (Listener)new DefaultListener(ctx));
        sourceReqCmsg.setProperty("POOLED_BYTE_BUFFER_FACTORY", new PooledDataStreamerFactory(ctx.alloc()));
        sourceReqCmsg.setProperty("CHNL_HNDLR_CTX", ctx);
        sourceReqCmsg.setProperty("SRC_HANDLER", (Object)this);
        HttpVersion protocolVersion = httpRequest.protocolVersion();
        sourceReqCmsg.setHttpVersion(protocolVersion.majorVersion() + "." + protocolVersion.minorVersion());
        sourceReqCmsg.setHttpMethod(httpRequest.method().name());
        InetSocketAddress localAddress = null;
        if (ctx.channel().localAddress() instanceof InetSocketAddress) {
            localAddress = (InetSocketAddress)ctx.channel().localAddress();
        }
        sourceReqCmsg.setProperty("LISTENER_PORT", localAddress != null ? Integer.valueOf(localAddress.getPort()) : null);
        sourceReqCmsg.setProperty("listener.interface.id", this.interfaceId);
        sourceReqCmsg.setProperty("PROTOCOL", "http");
        boolean isSecuredConnection = false;
        if (ctx.channel().pipeline().get("ssl") != null) {
            isSecuredConnection = true;
        }
        sourceReqCmsg.setProperty("IS_SECURED_CONNECTION", isSecuredConnection);
        sourceReqCmsg.setProperty("LOCAL_ADDRESS", ctx.channel().localAddress());
        sourceReqCmsg.setProperty("REMOTE_ADDRESS", ctx.channel().remoteAddress());
        sourceReqCmsg.setRequestUrl(httpRequest.uri());
        sourceReqCmsg.setProperty("TO", httpRequest.uri());
        return sourceReqCmsg;
    }
}

