/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.config.ChunkConfig;
import org.wso2.transport.http.netty.contract.config.KeepAliveConfig;
import org.wso2.transport.http.netty.contract.config.RequestSizeValidationConfig;
import org.wso2.transport.http.netty.contractimpl.common.BackPressureHandler;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.CertificateVerificationException;
import org.wso2.transport.http.netty.contractimpl.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.contractimpl.common.ssl.SSLHandlerFactory;
import org.wso2.transport.http.netty.contractimpl.listener.CustomHttpContentCompressor;
import org.wso2.transport.http.netty.contractimpl.listener.HttpAccessLoggingHandler;
import org.wso2.transport.http.netty.contractimpl.listener.HttpTraceLoggingHandler;
import org.wso2.transport.http.netty.contractimpl.listener.MaxEntityBodyValidator;
import org.wso2.transport.http.netty.contractimpl.listener.OCSPResponseBuilder;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.SslHandshakeCompletionHandlerForServer;
import org.wso2.transport.http.netty.contractimpl.listener.UriAndHeaderLengthValidator;
import org.wso2.transport.http.netty.contractimpl.listener.WebSocketServerHandshakeHandler;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceConnectionHandlerBuilder;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2ToHttpFallbackHandler;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2WithPriorKnowledgeHandler;
import org.wso2.transport.http.netty.contractimpl.sender.CertificateValidationHandler;

public class HttpServerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerChannelInitializer.class);
    private long socketIdleTimeout;
    private boolean httpTraceLogEnabled;
    private boolean httpAccessLogEnabled;
    private ChunkConfig chunkConfig;
    private KeepAliveConfig keepAliveConfig;
    private String interfaceId;
    private String serverName;
    private SSLConfig sslConfig;
    private SSLHandlerFactory sslHandlerFactory;
    private SSLContext keystoreSslContext;
    private SslContext keystoreHttp2SslContext;
    private SslContext certAndKeySslContext;
    private ServerConnectorFuture serverConnectorFuture;
    private RequestSizeValidationConfig reqSizeValidationConfig;
    private boolean http2Enabled = false;
    private boolean validateCertEnabled;
    private int cacheDelay;
    private int cacheSize;
    private ChannelGroup allChannels;
    private boolean ocspStaplingEnabled = false;
    private boolean pipeliningEnabled;
    private long pipeliningLimit;
    private EventExecutorGroup pipeliningGroup;
    private boolean webSocketCompressionEnabled;

    public void initChannel(SocketChannel ch) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing source channel pipeline");
        }
        ChannelPipeline serverPipeline = ch.pipeline();
        if (this.http2Enabled) {
            if (this.sslHandlerFactory != null) {
                if (this.ocspStaplingEnabled) {
                    OCSPResp response = this.getOcspResponse();
                    ReferenceCountedOpenSslContext context = (ReferenceCountedOpenSslContext)this.keystoreHttp2SslContext;
                    SslHandler sslHandler = context.newHandler(ch.alloc());
                    ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
                    engine.setOcspResponse(response.getEncoded());
                    Util.setSslHandshakeTimeOut(this.sslConfig, sslHandler);
                    ch.pipeline().addLast(new ChannelHandler[]{sslHandler, new Http2PipelineConfiguratorForServer(this)});
                } else {
                    SslHandler sslHandler = this.keystoreHttp2SslContext.newHandler(ch.alloc());
                    Util.setSslHandshakeTimeOut(this.sslConfig, sslHandler);
                    serverPipeline.addLast(new ChannelHandler[]{sslHandler, new Http2PipelineConfiguratorForServer(this)});
                }
            } else {
                this.configureH2cPipeline(serverPipeline);
            }
        } else if (this.sslHandlerFactory != null) {
            this.configureSslForHttp(serverPipeline, ch);
        } else {
            this.configureHttpPipeline(serverPipeline, "http");
        }
    }

    private OCSPResp getOcspResponse() throws IOException, KeyStoreException, CertificateVerificationException, CertificateException {
        OCSPResp response = OCSPResponseBuilder.generateOcspResponse(this.sslConfig, this.cacheSize, this.cacheDelay);
        if (!OpenSsl.isAvailable()) {
            throw new IllegalStateException("OpenSSL is not available!");
        }
        if (!OpenSsl.isOcspSupported()) {
            throw new IllegalStateException("OCSP is not supported!");
        }
        return response;
    }

    private void configureSslForHttp(ChannelPipeline serverPipeline, SocketChannel ch) throws CertificateVerificationException, KeyStoreException, IOException, CertificateException {
        SSLEngine sslEngine;
        if (this.ocspStaplingEnabled) {
            OCSPResp response = this.getOcspResponse();
            ReferenceCountedOpenSslContext context = this.sslHandlerFactory.getServerReferenceCountedOpenSslContext(this.ocspStaplingEnabled);
            SslHandler sslHandler = context.newHandler(ch.alloc());
            sslEngine = sslHandler.engine();
            ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslEngine;
            engine.setOcspResponse(response.getEncoded());
            Util.setSslHandshakeTimeOut(this.sslConfig, sslHandler);
            ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
        } else {
            SslHandler sslHandler;
            if (this.sslConfig.getServerKeyFile() != null) {
                sslHandler = this.certAndKeySslContext.newHandler(ch.alloc());
                sslEngine = sslHandler.engine();
                this.sslHandlerFactory.addCommonConfigs(sslEngine);
            } else {
                sslEngine = this.sslHandlerFactory.buildServerSSLEngine(this.keystoreSslContext);
            }
            sslHandler = new SslHandler(sslEngine);
            Util.setSslHandshakeTimeOut(this.sslConfig, sslHandler);
            serverPipeline.addLast("ssl", (ChannelHandler)sslHandler);
            if (this.validateCertEnabled) {
                serverPipeline.addLast("certificateValidation", (ChannelHandler)new CertificateValidationHandler(sslEngine, this.cacheDelay, this.cacheSize));
            }
        }
        serverPipeline.addLast("sslHandshakeCompletionHandler", (ChannelHandler)new SslHandshakeCompletionHandlerForServer(this, serverPipeline, sslEngine));
    }

    public void configureHttpPipeline(ChannelPipeline serverPipeline, String initialHttpScheme) {
        if (initialHttpScheme.equals("http")) {
            serverPipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            serverPipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(this.reqSizeValidationConfig.getMaxUriLength(), this.reqSizeValidationConfig.getMaxHeaderSize(), this.reqSizeValidationConfig.getMaxChunkSize()));
            serverPipeline.addLast("compressor", (ChannelHandler)new CustomHttpContentCompressor());
            serverPipeline.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
            if (this.httpTraceLogEnabled) {
                serverPipeline.addLast("http-trace-logger", (ChannelHandler)new HttpTraceLoggingHandler("http.tracelog.downstream"));
            }
            if (this.httpAccessLogEnabled) {
                serverPipeline.addLast("http-access-logger", (ChannelHandler)new HttpAccessLoggingHandler("http.accesslog"));
            }
        }
        serverPipeline.addLast("uriLengthValidator", (ChannelHandler)new UriAndHeaderLengthValidator(this.serverName));
        if (this.reqSizeValidationConfig.getMaxEntityBodySize() > -1L) {
            serverPipeline.addLast("maxEntityBodyValidator", (ChannelHandler)new MaxEntityBodyValidator(this.serverName, this.reqSizeValidationConfig.getMaxEntityBodySize()));
        }
        serverPipeline.addLast("websocket-server-handshake-handler", (ChannelHandler)new WebSocketServerHandshakeHandler(this.serverConnectorFuture, this.interfaceId, this.webSocketCompressionEnabled));
        serverPipeline.addLast("BackPressureHandler", (ChannelHandler)new BackPressureHandler());
        serverPipeline.addLast("SourceHandler", (ChannelHandler)new SourceHandler(this.serverConnectorFuture, this.interfaceId, this.chunkConfig, this.keepAliveConfig, this.serverName, this.allChannels, this.pipeliningEnabled, this.pipeliningLimit, this.pipeliningGroup));
        if (this.socketIdleTimeout >= 0L) {
            serverPipeline.addBefore("SourceHandler", "idleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, this.socketIdleTimeout, TimeUnit.MILLISECONDS));
        }
    }

    private void configureH2cPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new Http2WithPriorKnowledgeHandler(this.interfaceId, this.serverName, this.serverConnectorFuture, this)});
        HttpServerCodec sourceCodec = new HttpServerCodec(this.reqSizeValidationConfig.getMaxUriLength(), this.reqSizeValidationConfig.getMaxHeaderSize(), this.reqSizeValidationConfig.getMaxChunkSize());
        HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec("Http2SourceConnectionHandler", (Http2ConnectionHandler)new Http2SourceConnectionHandlerBuilder(this.interfaceId, this.serverConnectorFuture, this.serverName, this).build());
            }
            return null;
        };
        pipeline.addLast("ServerCodec", (ChannelHandler)sourceCodec);
        pipeline.addLast("compressor", (ChannelHandler)new CustomHttpContentCompressor());
        if (this.httpTraceLogEnabled) {
            pipeline.addLast("http-trace-logger", (ChannelHandler)new HttpTraceLoggingHandler("http.tracelog.downstream"));
        }
        if (this.httpAccessLogEnabled) {
            pipeline.addLast("http-access-logger", (ChannelHandler)new HttpAccessLoggingHandler("http.accesslog"));
        }
        pipeline.addLast("Http2UpgradeHandler", (ChannelHandler)new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, upgradeCodecFactory, Integer.MAX_VALUE));
        pipeline.addLast("Http2ToHttpFallbackHandler", (ChannelHandler)new Http2ToHttpFallbackHandler(this));
    }

    public void setServerConnectorFuture(ServerConnectorFuture serverConnectorFuture) {
        this.serverConnectorFuture = serverConnectorFuture;
    }

    void setIdleTimeout(long idleTimeout) {
        this.socketIdleTimeout = idleTimeout;
    }

    public long getSocketIdleTimeout() {
        return this.socketIdleTimeout;
    }

    void setHttpTraceLogEnabled(boolean httpTraceLogEnabled) {
        this.httpTraceLogEnabled = httpTraceLogEnabled;
    }

    void setHttpAccessLogEnabled(boolean httpAccessLogEnabled) {
        this.httpAccessLogEnabled = httpAccessLogEnabled;
    }

    public boolean isHttpTraceLogEnabled() {
        return this.httpTraceLogEnabled;
    }

    public boolean isHttpAccessLogEnabled() {
        return this.httpAccessLogEnabled;
    }

    void setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
    }

    void setSslConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    void setSslHandlerFactory(SSLHandlerFactory sslHandlerFactory) {
        this.sslHandlerFactory = sslHandlerFactory;
    }

    void setKeystoreSslContext(SSLContext sslContext) {
        this.keystoreSslContext = sslContext;
    }

    void setHttp2SslContext(SslContext sslContext) {
        this.keystoreHttp2SslContext = sslContext;
    }

    void setCertandKeySslContext(SslContext sslContext) {
        this.certAndKeySslContext = sslContext;
    }

    void setReqSizeValidationConfig(RequestSizeValidationConfig reqSizeValidationConfig) {
        this.reqSizeValidationConfig = reqSizeValidationConfig;
    }

    public void setChunkingConfig(ChunkConfig chunkConfig) {
        this.chunkConfig = chunkConfig;
    }

    void setKeepAliveConfig(KeepAliveConfig keepAliveConfig) {
        this.keepAliveConfig = keepAliveConfig;
    }

    void setValidateCertEnabled(boolean validateCertEnabled) {
        this.validateCertEnabled = validateCertEnabled;
    }

    void setCacheDelay(int cacheDelay) {
        this.cacheDelay = cacheDelay;
    }

    void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    void setServerName(String serverName) {
        this.serverName = serverName;
    }

    void setOcspStaplingEnabled(boolean ocspStaplingEnabled) {
        this.ocspStaplingEnabled = ocspStaplingEnabled;
    }

    void setHttp2Enabled(boolean http2Enabled) {
        this.http2Enabled = http2Enabled;
    }

    void setPipeliningEnabled(boolean pipeliningEnabled) {
        this.pipeliningEnabled = pipeliningEnabled;
    }

    public void setPipeliningLimit(long pipeliningLimit) {
        this.pipeliningLimit = pipeliningLimit;
    }

    public void setPipeliningThreadGroup(EventExecutorGroup pipeliningGroup) {
        this.pipeliningGroup = pipeliningGroup;
    }

    public void setWebSocketCompressionEnabled(boolean webSocketCompressionEnabled) {
        this.webSocketCompressionEnabled = webSocketCompressionEnabled;
    }

    void setAllChannels(ChannelGroup allChannels) {
        this.allChannels = allChannels;
    }

    class Http2PipelineConfiguratorForServer
    extends ApplicationProtocolNegotiationHandler {
        private HttpServerChannelInitializer channelInitializer;

        Http2PipelineConfiguratorForServer(HttpServerChannelInitializer channelInitializer) {
            super("http/1.1");
            this.channelInitializer = channelInitializer;
        }

        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            if ("h2".equals(protocol)) {
                ctx.pipeline().addLast("Http2SourceConnectionHandler", (ChannelHandler)new Http2SourceConnectionHandlerBuilder(HttpServerChannelInitializer.this.interfaceId, HttpServerChannelInitializer.this.serverConnectorFuture, HttpServerChannelInitializer.this.serverName, this.channelInitializer).build());
            } else if ("http/1.1".equals(protocol)) {
                HttpServerChannelInitializer.this.configureHttpPipeline(ctx.pipeline(), "http");
                ctx.pipeline().fireChannelActive();
            } else {
                throw new IllegalStateException("unknown protocol: " + protocol);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (ctx != null && ctx.channel().isActive()) {
                ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }
}

