/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.channel.pool;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.sender.channel.TargetChannel;

public class PoolableTargetChannelFactoryPerSrcHndlr
implements PoolableObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PoolableTargetChannelFactoryPerSrcHndlr.class);
    private final GenericObjectPool genericObjectPool;

    PoolableTargetChannelFactoryPerSrcHndlr(GenericObjectPool genericObjectPool) {
        this.genericObjectPool = genericObjectPool;
    }

    public Object makeObject() throws Exception {
        TargetChannel targetChannel = (TargetChannel)this.genericObjectPool.borrowObject();
        LOG.debug("Created channel: {}", (Object)targetChannel);
        return targetChannel;
    }

    public void destroyObject(Object o) throws Exception {
        if (((TargetChannel)o).getChannel().isActive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Original Channel {} is returned to the pool. ", (Object)((TargetChannel)o).getChannel().id());
            }
            this.genericObjectPool.returnObject(o);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Original Channel is destroyed. ");
            }
            this.genericObjectPool.invalidateObject(o);
        }
    }

    public boolean validateObject(Object o) {
        if (((TargetChannel)o).getChannel() != null) {
            boolean answer = ((TargetChannel)o).getChannel().isActive();
            LOG.debug("Validating channel: {} -> {}", o, (Object)answer);
            return answer;
        }
        return true;
    }

    public void activateObject(Object o) {
    }

    public void passivateObject(Object o) {
    }
}

