/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.config.KeepAliveConfig;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.http2.TimeoutHandler;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.internal.HttpTransportContextHolder;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class TargetHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TargetHandler.class);
    private HttpResponseFuture httpResponseFuture;
    private HttpCarbonMessage inboundResponseMsg;
    private ConnectionManager connectionManager;
    private TargetChannel targetChannel;
    private Http2TargetHandler http2TargetHandler;
    private HttpCarbonMessage outboundRequestMsg;
    private HandlerExecutor handlerExecutor;
    private KeepAliveConfig keepAliveConfig;
    private boolean idleTimeoutTriggered;
    private ChannelHandlerContext context;

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.context = ctx;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        MessageStateContext messageStateContext = this.outboundRequestMsg.getMessageStateContext();
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetResponseReceiving(this.inboundResponseMsg);
        }
        if (this.targetChannel.isRequestHeaderWritten()) {
            if (msg instanceof HttpResponse) {
                this.inboundResponseMsg = Util.createInboundRespCarbonMsg(ctx, (HttpResponse)msg, this.outboundRequestMsg);
                messageStateContext.getSenderState().readInboundResponseHeaders(this, (HttpResponse)msg);
            } else if (this.inboundResponseMsg != null) {
                messageStateContext.getSenderState().readInboundResponseEntityBody(ctx, (HttpContent)msg, this.getInboundResponseMsg());
            }
        } else {
            if (msg instanceof HttpResponse) {
                LOG.warn("Received a response for an obsolete request {}", msg);
            }
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.idleTimeoutTriggered) {
            this.outboundRequestMsg.getMessageStateContext().getSenderState().handleAbruptChannelClosure(this.httpResponseFuture);
        }
        this.connectionManager.invalidateTargetChannel(this.targetChannel);
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetConnectionTermination(Integer.toString(ctx.hashCode()));
            this.handlerExecutor = null;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.closeChannel(ctx);
        LOG.warn("Exception occurred in TargetHandler : {}", (Object)cause.getMessage());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.targetChannel.getChannel().pipeline().remove("idleStateHandler");
            this.idleTimeoutTriggered = true;
            ctx.close();
            this.outboundRequestMsg.getMessageStateContext().getSenderState().handleIdleTimeoutConnectionClosure(this.httpResponseFuture, ctx.channel().id().asLongText());
        } else if (evt instanceof HttpClientUpgradeHandler.UpgradeEvent) {
            HttpClientUpgradeHandler.UpgradeEvent upgradeEvent = (HttpClientUpgradeHandler.UpgradeEvent)evt;
            if (HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL.name().equals(upgradeEvent.name())) {
                this.executePostUpgradeActions(ctx);
            }
            ctx.fireUserEventTriggered(evt);
        } else if (evt instanceof Http2ConnectionPrefaceAndSettingsFrameWrittenEvent) {
            LOG.debug("Connection Preface and Settings frame written");
        } else if (evt instanceof SslCloseCompletionEvent) {
            LOG.debug("SSL close completion event received");
        } else if (evt instanceof ChannelInputShutdownReadComplete) {
            LOG.debug("Input side of the connection is already shutdown");
        } else {
            LOG.warn("Unexpected user event {} triggered", evt);
        }
    }

    private void executePostUpgradeActions(ChannelHandlerContext ctx) {
        ctx.pipeline().remove((ChannelHandler)this);
        ctx.pipeline().addLast("http2TargetHandler", (ChannelHandler)this.http2TargetHandler);
        Http2ClientChannel http2ClientChannel = this.http2TargetHandler.getHttp2ClientChannel();
        Util.safelyRemoveHandlers(this.targetChannel.getChannel().pipeline(), "idleStateHandler", "http-trace-logger");
        http2ClientChannel.addDataEventListener("idleStateHandler", new TimeoutHandler(http2ClientChannel.getSocketIdleTimeout(), http2ClientChannel));
        http2ClientChannel.getInFlightMessage(1).setRequestWritten(true);
        http2ClientChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamInit(ctx, 1));
        this.handoverChannelToHttp2ConnectionManager();
    }

    private void handoverChannelToHttp2ConnectionManager() {
        this.connectionManager.getHttp2ConnectionManager().addHttp2ClientChannel(this.targetChannel.getHttpRoute(), this.targetChannel.getHttp2ClientChannel());
    }

    public void closeChannel(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.close();
        }
    }

    public void setHttpResponseFuture(HttpResponseFuture httpResponseFuture) {
        this.httpResponseFuture = httpResponseFuture;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setOutboundRequestMsg(HttpCarbonMessage outboundRequestMsg) {
        this.outboundRequestMsg = outboundRequestMsg;
    }

    public void setTargetChannel(TargetChannel targetChannel) {
        this.targetChannel = targetChannel;
    }

    public void setKeepAliveConfig(KeepAliveConfig keepAliveConfig) {
        this.keepAliveConfig = keepAliveConfig;
    }

    public HttpResponseFuture getHttpResponseFuture() {
        return this.httpResponseFuture;
    }

    void setHttp2TargetHandler(Http2TargetHandler http2TargetHandler) {
        this.http2TargetHandler = http2TargetHandler;
    }

    public HttpCarbonMessage getInboundResponseMsg() {
        return this.inboundResponseMsg;
    }

    public Http2TargetHandler getHttp2TargetHandler() {
        return this.http2TargetHandler;
    }

    public void resetInboundMsg() {
        this.inboundResponseMsg = null;
    }

    public TargetChannel getTargetChannel() {
        return this.targetChannel;
    }

    public KeepAliveConfig getKeepAliveConfig() {
        return this.keepAliveConfig;
    }

    public HttpCarbonMessage getOutboundRequestMsg() {
        return this.outboundRequestMsg;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ChannelHandlerContext getContext() {
        return this.context;
    }
}

