/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.wso2.transport.http.netty.contract.ClientConnectorException;
import org.wso2.transport.http.netty.contractimpl.sender.ConnectionAvailabilityListener;

public class ConnectionAvailabilityFuture {
    private ChannelFuture socketAvailabilityFuture;
    private boolean isSSLEnabled = false;
    private ConnectionAvailabilityListener listener = null;
    private String protocol;
    private boolean socketAvailable = false;
    private boolean isFailure;
    private Throwable throwable;
    private boolean forceHttp2 = false;

    public void setSocketAvailabilityFuture(ChannelFuture socketAvailabilityFuture) {
        this.socketAvailabilityFuture = socketAvailabilityFuture;
        socketAvailabilityFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (this.isValidChannel(channelFuture)) {
                    ConnectionAvailabilityFuture.this.socketAvailable = true;
                    if (ConnectionAvailabilityFuture.this.listener != null && !ConnectionAvailabilityFuture.this.isSSLEnabled) {
                        if (ConnectionAvailabilityFuture.this.forceHttp2) {
                            ConnectionAvailabilityFuture.this.notifySuccess("h2c");
                        } else {
                            ConnectionAvailabilityFuture.this.notifySuccess("http");
                        }
                    }
                } else {
                    ConnectionAvailabilityFuture.this.notifyFailure(channelFuture.cause());
                }
            }

            private boolean isValidChannel(ChannelFuture channelFuture) {
                return channelFuture.isDone() && channelFuture.isSuccess();
            }
        });
    }

    void setSSLEnabled(boolean sslEnabled) {
        this.isSSLEnabled = sslEnabled;
    }

    public void setForceHttp2(boolean forceHttp2) {
        this.forceHttp2 = forceHttp2;
    }

    void notifySuccess(String protocol) {
        this.protocol = protocol;
        if (this.listener != null) {
            if (this.forceHttp2 && !protocol.equalsIgnoreCase("h2c") && !protocol.equalsIgnoreCase("h2")) {
                ClientConnectorException connectorException = new ClientConnectorException("Protocol must be HTTP/2", HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED.code());
                this.listener.onFailure(connectorException);
            } else {
                this.listener.onSuccess(protocol, this.socketAvailabilityFuture);
            }
        }
    }

    void notifyFailure(Throwable cause) {
        this.isFailure = true;
        this.throwable = cause;
        if (this.listener != null) {
            this.notifyErrorState(this.socketAvailabilityFuture, cause);
        }
    }

    public void setListener(ConnectionAvailabilityListener listener) {
        this.listener = listener;
        if (this.protocol != null) {
            this.notifySuccess(this.protocol);
        } else if (!this.isSSLEnabled && this.socketAvailable) {
            if (this.forceHttp2) {
                this.notifySuccess("h2c");
            } else {
                this.notifySuccess("http");
            }
        } else if (this.isFailure) {
            this.notifyFailure(this.throwable);
        }
    }

    private void notifyErrorState(ChannelFuture channelFuture, Throwable cause) {
        String socketAddress = null;
        if (channelFuture.channel().remoteAddress() != null) {
            socketAddress = channelFuture.channel().remoteAddress().toString();
        }
        ClientConnectorException connectorException = channelFuture.isDone() && channelFuture.isCancelled() ? new ClientConnectorException("Request cancelled: " + socketAddress, HttpResponseStatus.BAD_GATEWAY.code()) : (!channelFuture.isDone() && !channelFuture.isSuccess() && !channelFuture.isCancelled() && channelFuture.cause() == null ? new ClientConnectorException("Connection timeout: " + socketAddress, HttpResponseStatus.BAD_GATEWAY.code()) : (cause.toString().contains("javax.net.ssl") ? new ClientConnectorException(cause.getMessage() + socketAddress, HttpResponseStatus.BAD_GATEWAY.code()) : (cause.toString().contains("UnknownHostException") ? new ClientConnectorException("Could not resolve host:" + cause.getMessage(), HttpResponseStatus.BAD_GATEWAY.code()) : new ClientConnectorException(channelFuture.cause().getMessage(), HttpResponseStatus.BAD_GATEWAY.code()))));
        if (channelFuture.cause() != null) {
            connectorException.initCause(channelFuture.cause());
        }
        this.listener.onFailure(connectorException);
    }
}

