/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.HttpOutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.states.MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.SendingHeaders;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class EntityBodyReceived
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(EntityBodyReceived.class);
    private final MessageStateContext messageStateContext;
    private final SourceHandler sourceHandler;
    private final float httpVersion;

    EntityBodyReceived(MessageStateContext messageStateContext, SourceHandler sourceHandler, float httpVersion) {
        this.messageStateContext = messageStateContext;
        this.sourceHandler = sourceHandler;
        this.httpVersion = httpVersion;
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        LOG.warn("readInboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        LOG.warn("readInboundRequestBody is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundResponseListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        this.messageStateContext.setListenerState(new SendingHeaders(outboundResponseListener, this.messageStateContext));
        this.messageStateContext.getListenerState().writeOutboundResponseHeaders(outboundResponseMsg, httpContent);
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        try {
            serverConnectorFuture.notifyErrorListener(new ServerConnectorException("Remote client closed the connection before initiating outbound response"));
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener", (Throwable)e);
        }
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        try {
            serverConnectorFuture.notifyErrorListener(new ServerConnectorException("Idle timeout triggered before initiating outbound response"));
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener", (Throwable)e);
        }
        String responseValue = "Server time out";
        ChannelFuture outboundRespFuture = StateUtil.sendRequestTimeoutResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer((CharSequence)responseValue, (Charset)CharsetUtil.UTF_8), responseValue.length(), this.httpVersion, this.sourceHandler.getServerName());
        outboundRespFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            Throwable cause = channelFuture.cause();
            if (cause != null) {
                LOG.warn("Failed to send: {}", (Object)cause.getMessage());
            }
            ctx.close();
        }));
        return outboundRespFuture;
    }
}

