/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.listener.HttpServerChannelInitializer;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.internal.HttpTransportContextHolder;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;

public class Http2SourceConnectionHandler
extends Http2ConnectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Http2SourceConnectionHandler.class);
    private Http2FrameListener http2FrameListener;
    private Http2ConnectionEncoder encoder;
    private String interfaceId;
    private ServerConnectorFuture serverConnectorFuture;
    private String serverName;
    private HttpServerChannelInitializer serverChannelInitializer;

    Http2SourceConnectionHandler(HttpServerChannelInitializer serverChannelInitializer, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, String interfaceId, ServerConnectorFuture serverConnectorFuture, String serverName) {
        super(decoder, encoder, initialSettings);
        this.serverChannelInitializer = serverChannelInitializer;
        this.encoder = encoder;
        this.interfaceId = interfaceId;
        this.serverConnectorFuture = serverConnectorFuture;
        this.serverName = serverName;
        this.http2FrameListener = new ServerFrameListener();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        Util.safelyRemoveHandlers(ctx.pipeline(), "Http2ToHttpFallbackHandler", "compressor", "http-trace-logger", "http-access-logger");
        Http2SourceHandler http2SourceHandler = new Http2SourceHandler(this.serverChannelInitializer, this.encoder, this.interfaceId, this.connection(), this.serverConnectorFuture, this.serverName);
        ctx.pipeline().addLast("Http2SourceHandler", (ChannelHandler)http2SourceHandler);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void onError(ChannelHandlerContext ctx, Throwable cause) {
        Http2Exception embedded = Http2CodecUtil.getEmbeddedHttp2Exception((Throwable)cause);
        if (embedded instanceof Http2Exception.ClosedStreamCreationException) {
            LOG.warn("Stream creation failed, {}, {}", (Object)"Promised stream is already rejected or stream is no longer valid", (Object)embedded.getMessage());
        } else {
            super.onError(ctx, cause);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.close();
        if (HttpTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HttpTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionTermination(Integer.toString(ctx.hashCode()));
        }
        ctx.fireChannelInactive();
    }

    Http2FrameListener getHttp2FrameListener() {
        return this.http2FrameListener;
    }

    private static class ServerFrameListener
    extends Http2EventAdapter {
        private ServerFrameListener() {
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
            Http2HeadersFrame http2HeadersFrame = new Http2HeadersFrame(streamId, headers, endOfStream);
            ctx.fireChannelRead((Object)http2HeadersFrame);
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
            this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
        }

        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
            int readableBytes = data.readableBytes();
            ByteBuf forwardedData = data.copy();
            data.skipBytes(readableBytes);
            Http2DataFrame dataFrame = new Http2DataFrame(streamId, forwardedData, endOfStream);
            ctx.fireChannelRead((Object)dataFrame);
            return readableBytes + padding;
        }
    }
}

