/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.LinkedList;
import java.util.Queue;

public class MessageQueueHandler
extends ChannelInboundHandlerAdapter {
    private final Queue<Object> messageQueue = new LinkedList<Object>();
    private ChannelHandlerContext ctx;
    private boolean readNext;

    public synchronized void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public synchronized void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.readNext) {
            this.readNext = false;
            ctx.fireChannelRead(msg);
            return;
        }
        this.messageQueue.add(msg);
    }

    public synchronized void readNextFrame() {
        if (this.ctx == null) {
            throw new IllegalStateException("Cannot call readNextFrame() without an initialized ChannelHandlerContext");
        }
        if (this.messageQueue.isEmpty()) {
            this.readNext = true;
            this.ctx.channel().read();
            return;
        }
        this.ctx.fireChannelRead(this.messageQueue.poll());
    }
}

