/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.message.DefaultListener;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;
import org.wso2.transport.http.netty.message.Listener;
import org.wso2.transport.http.netty.message.PooledDataStreamerFactory;
import org.wso2.transport.http.netty.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.sender.http2.Http2DataEventListener;
import org.wso2.transport.http.netty.sender.http2.OutboundMsgHolder;

public class ClientInboundHandler
extends Http2EventAdapter {
    private static final Logger log = LoggerFactory.getLogger(ClientInboundHandler.class);
    private Http2ClientChannel http2ClientChannel;

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        if (log.isDebugEnabled()) {
            log.debug("Reading data on channel: {} with stream id: {}, isEndOfStream: {}", new Object[]{this.http2ClientChannel.toString(), streamId, endOfStream});
        }
        for (Http2DataEventListener listener : this.http2ClientChannel.getDataEventListeners()) {
            if (listener.onDataRead(ctx, streamId, data, endOfStream)) continue;
            return data.readableBytes() + padding;
        }
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        boolean isServerPush = false;
        if (outboundMsgHolder == null) {
            outboundMsgHolder = this.http2ClientChannel.getPromisedMessage(streamId);
            if (outboundMsgHolder != null) {
                isServerPush = true;
            } else {
                log.warn("Data Frame received on channel: {} with invalid stream id: {}", (Object)this.http2ClientChannel.toString(), (Object)streamId);
                return 0;
            }
        }
        if (isServerPush) {
            HttpCarbonResponse responseMessage = outboundMsgHolder.getPushResponse(streamId);
            if (endOfStream) {
                responseMessage.addHttpContent((HttpContent)new DefaultLastHttpContent(data.retain()));
                this.http2ClientChannel.removePromisedMessage(streamId);
            } else {
                responseMessage.addHttpContent((HttpContent)new DefaultHttpContent(data.retain()));
            }
        } else {
            HttpCarbonResponse responseMessage = outboundMsgHolder.getResponse();
            if (endOfStream) {
                responseMessage.addHttpContent((HttpContent)new DefaultLastHttpContent(data.retain()));
                this.http2ClientChannel.removeInFlightMessage(streamId);
            } else {
                responseMessage.addHttpContent((HttpContent)new DefaultHttpContent(data.retain()));
            }
        }
        return data.readableBytes() + padding;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endStream);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) throws Http2Exception {
        if (log.isDebugEnabled()) {
            log.debug("Reading Http2 headers on channel: {} with stream id: {}, isEndOfStream: {}", new Object[]{this.http2ClientChannel.toString(), streamId, endStream});
        }
        for (Http2DataEventListener listener : this.http2ClientChannel.getDataEventListeners()) {
            if (listener.onHeadersRead(ctx, streamId, headers, endStream)) continue;
            return;
        }
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        boolean isServerPush = false;
        if (outboundMsgHolder == null) {
            outboundMsgHolder = this.http2ClientChannel.getPromisedMessage(streamId);
            if (outboundMsgHolder != null) {
                isServerPush = true;
            } else {
                log.warn("Header Frame received on channel: {} with invalid stream id: {} ", (Object)this.http2ClientChannel.toString(), (Object)streamId);
                return;
            }
        }
        HttpCarbonResponse responseMessage = this.setupResponseCarbonMessage(ctx, streamId, headers, outboundMsgHolder);
        if (isServerPush) {
            outboundMsgHolder.addPushResponse(streamId, responseMessage);
            if (endStream) {
                responseMessage.addHttpContent((HttpContent)new DefaultLastHttpContent());
                this.http2ClientChannel.removePromisedMessage(streamId);
            }
        } else {
            if (endStream) {
                responseMessage.addHttpContent((HttpContent)new DefaultLastHttpContent());
                this.http2ClientChannel.removeInFlightMessage(streamId);
            }
            outboundMsgHolder.setResponse(responseMessage);
        }
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
        log.debug("Http2FrameListenAdapter.onSettingRead()");
        ctx.fireChannelRead((Object)settings);
        super.onSettingsRead(ctx, settings);
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        log.warn("RST received on channel: {} for streamId: {} errorCode: {}", new Object[]{this.http2ClientChannel.toString(), streamId, errorCode});
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        if (outboundMsgHolder != null) {
            outboundMsgHolder.getResponseFuture().notifyHttpListener(new Exception("HTTP/2 stream " + streamId + " reset by the remote peer"));
        }
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        if (log.isDebugEnabled()) {
            log.debug("Received a push promise on channel: {} over stream id: {}, promisedStreamId: {}", new Object[]{this.http2ClientChannel.toString(), streamId, promisedStreamId});
        }
        for (Http2DataEventListener listener : this.http2ClientChannel.getDataEventListeners()) {
            if (listener.onPushPromiseRead(ctx, streamId, headers, false)) continue;
            return;
        }
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        if (outboundMsgHolder == null) {
            log.warn("Push promise received in channel: {} over invalid stream id : {}", (Object)this.http2ClientChannel.toString(), (Object)streamId);
            return;
        }
        this.http2ClientChannel.putPromisedMessage(promisedStreamId, outboundMsgHolder);
        this.http2ClientChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamInit(ctx, promisedStreamId));
        Http2PushPromise pushPromise = new Http2PushPromise(Util.createHttpRequestFromHttp2Headers(headers, streamId), outboundMsgHolder);
        pushPromise.setPromisedStreamId(promisedStreamId);
        pushPromise.setStreamId(streamId);
        outboundMsgHolder.addPromise(pushPromise);
    }

    public void setHttp2ClientChannel(Http2ClientChannel http2ClientChannel) {
        this.http2ClientChannel = http2ClientChannel;
    }

    private HttpCarbonResponse setupResponseCarbonMessage(ChannelHandlerContext ctx, int streamId, Http2Headers http2Headers, OutboundMsgHolder outboundMsgHolder) {
        HttpResponseStatus responseStatus;
        CharSequence status = http2Headers.status();
        try {
            responseStatus = HttpConversionUtil.parseStatus((CharSequence)status);
        }
        catch (Http2Exception e) {
            responseStatus = HttpResponseStatus.BAD_GATEWAY;
        }
        HttpVersion version = new HttpVersion("HTTP/2.0", true);
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(version, responseStatus);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders((int)streamId, (Http2Headers)http2Headers, (HttpHeaders)httpResponse.headers(), (HttpVersion)version, (boolean)false, (boolean)false);
        }
        catch (Http2Exception e) {
            outboundMsgHolder.getResponseFuture().notifyHttpListener(new Exception("Error while setting http headers", e));
        }
        HttpCarbonResponse responseCarbonMsg = new HttpCarbonResponse((HttpResponse)httpResponse, (Listener)new DefaultListener(ctx));
        responseCarbonMsg.setProperty("POOLED_BYTE_BUFFER_FACTORY", new PooledDataStreamerFactory(ctx.alloc()));
        responseCarbonMsg.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        responseCarbonMsg.setProperty("HTTP_STATUS_CODE", httpResponse.status().code());
        responseCarbonMsg.setProperty("executor.workerpool", outboundMsgHolder.getRequest().getProperty("executor.workerpool"));
        return responseCarbonMsg;
    }
}

