/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.HttpWsServerConnectorFuture;
import org.wso2.transport.http.netty.message.BlockingEntityCollector;
import org.wso2.transport.http.netty.message.DefaultObservable;
import org.wso2.transport.http.netty.message.EntityCollector;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.Listener;
import org.wso2.transport.http.netty.message.MessageFuture;
import org.wso2.transport.http.netty.message.Observable;

public class HTTPCarbonMessage {
    protected HttpMessage httpMessage;
    private EntityCollector blockingEntityCollector;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private MessageFuture messageFuture;
    private final ServerConnectorFuture httpOutboundRespFuture = new HttpWsServerConnectorFuture();
    private final DefaultHttpResponseFuture httpOutboundRespStatusFuture = new DefaultHttpResponseFuture();
    private final Observable contentObservable = new DefaultObservable();

    public HTTPCarbonMessage(HttpMessage httpMessage, Listener contentListener) {
        this.httpMessage = httpMessage;
        this.setBlockingEntityCollector(new BlockingEntityCollector(300000));
        this.contentObservable.setListener(contentListener);
    }

    public HTTPCarbonMessage(HttpMessage httpMessage, int maxWaitTime, Listener contentListener) {
        this.httpMessage = httpMessage;
        this.setBlockingEntityCollector(new BlockingEntityCollector(maxWaitTime));
        this.contentObservable.setListener(contentListener);
    }

    public HTTPCarbonMessage(HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
        this.setBlockingEntityCollector(new BlockingEntityCollector(300000));
    }

    public synchronized void addHttpContent(HttpContent httpContent) {
        if (this.messageFuture != null) {
            this.messageFuture.notifyMessageListener(httpContent);
            this.contentObservable.notifyAddListener(httpContent);
            this.contentObservable.notifyGetListener(httpContent);
        } else {
            this.blockingEntityCollector.addHttpContent(httpContent);
            this.contentObservable.notifyAddListener(httpContent);
        }
    }

    public HttpContent getHttpContent() {
        HttpContent httpContent = this.blockingEntityCollector.getHttpContent();
        this.contentObservable.notifyGetListener(httpContent);
        return httpContent;
    }

    public synchronized MessageFuture getHttpContentAsync() {
        this.messageFuture = new MessageFuture(this);
        return this.messageFuture;
    }

    @Deprecated
    public ByteBuf getMessageBody() {
        return this.blockingEntityCollector.getMessageBody();
    }

    public boolean isEmpty() {
        return this.blockingEntityCollector.isEmpty();
    }

    public long countMessageLengthTill(long maxLength) {
        return this.blockingEntityCollector.countMessageLengthTill(maxLength);
    }

    public long getFullMessageLength() {
        return this.blockingEntityCollector.getFullMessageLength();
    }

    @Deprecated
    public void addMessageBody(ByteBuffer msgBody) {
        this.blockingEntityCollector.addMessageBody(msgBody);
    }

    public void completeMessage() {
        this.blockingEntityCollector.completeMessage();
    }

    public HttpHeaders getHeaders() {
        return this.httpMessage.headers();
    }

    public String getHeader(String key) {
        return this.httpMessage.headers().get(key);
    }

    public void setHeader(String key, String value) {
        this.httpMessage.headers().set(key, (Object)value);
    }

    public void setHeaders(HttpHeaders httpHeaders) {
        this.httpMessage.headers().setAll(httpHeaders);
    }

    public void removeHeader(String key) {
        this.httpMessage.headers().remove(key);
    }

    public Object getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    private void setBlockingEntityCollector(BlockingEntityCollector blockingEntityCollector) {
        this.blockingEntityCollector = blockingEntityCollector;
    }

    public ServerConnectorFuture getHttpResponseFuture() {
        return this.httpOutboundRespFuture;
    }

    public HttpResponseFuture getHttpOutboundRespStatusFuture() {
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseFuture respond(HTTPCarbonMessage httpCarbonMessage) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(httpCarbonMessage);
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseFuture pushResponse(HTTPCarbonMessage httpCarbonMessage, Http2PushPromise pushPromise) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(httpCarbonMessage, pushPromise);
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseFuture pushPromise(Http2PushPromise pushPromise) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(pushPromise);
        return this.httpOutboundRespStatusFuture;
    }

    public HTTPCarbonMessage cloneCarbonMessageWithOutData() {
        HTTPCarbonMessage newCarbonMessage = this.getNewHttpCarbonMessage();
        Map<String, Object> propertiesMap = this.getProperties();
        propertiesMap.forEach(newCarbonMessage::setProperty);
        return newCarbonMessage;
    }

    private HTTPCarbonMessage getNewHttpCarbonMessage() {
        DefaultHttpHeaders httpHeaders;
        DefaultFullHttpResponse newHttpMessage;
        if (this.httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)this.httpMessage;
            newHttpMessage = new DefaultHttpRequest(this.httpMessage.protocolVersion(), ((HttpRequest)this.httpMessage).method(), httpRequest.uri());
            httpHeaders = new DefaultHttpHeaders();
            List headerList = this.httpMessage.headers().entries();
            for (Map.Entry entry : headerList) {
                httpHeaders.add((String)entry.getKey(), entry.getValue());
            }
        } else {
            HttpResponse httpResponse = (HttpResponse)this.httpMessage;
            newHttpMessage = new DefaultFullHttpResponse(this.httpMessage.protocolVersion(), httpResponse.status());
            httpHeaders = new DefaultHttpHeaders();
            List headerList = this.httpMessage.headers().entries();
            for (Map.Entry entry : headerList) {
                httpHeaders.add((String)entry.getKey(), entry.getValue());
            }
        }
        HTTPCarbonMessage httpCarbonMessage = new HTTPCarbonMessage((HttpMessage)newHttpMessage);
        httpCarbonMessage.getHeaders().set((HttpHeaders)httpHeaders);
        return httpCarbonMessage;
    }

    public void waitAndReleaseAllEntities() {
        this.blockingEntityCollector.waitAndReleaseAllEntities();
    }

    public EntityCollector getBlockingEntityCollector() {
        return this.blockingEntityCollector;
    }

    public synchronized void removeHttpContentAsyncFuture() {
        this.messageFuture = null;
    }

    public HttpRequest getNettyHttpRequest() {
        return (HttpRequest)this.httpMessage;
    }

    public HttpResponse getNettyHttpResponse() {
        return (HttpResponse)this.httpMessage;
    }
}

