/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCounted;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;

public class MaxEntityBodyValidator
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(MaxEntityBodyValidator.class);
    private String serverName;
    private long maxEntityBodySize;
    private long currentSize;
    private HttpRequest inboundRequest;
    private LinkedList<HttpContent> fullContent;

    MaxEntityBodyValidator(String serverName, long maxEntityBodySize) {
        this.serverName = serverName;
        this.maxEntityBodySize = maxEntityBodySize;
        this.fullContent = new LinkedList();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (ctx.channel().isActive()) {
            if (msg instanceof HttpRequest) {
                this.inboundRequest = (HttpRequest)msg;
                if (this.isContentLengthInvalid((HttpMessage)this.inboundRequest, this.maxEntityBodySize)) {
                    this.sendEntityTooLargeResponse(ctx);
                }
                ctx.channel().read();
            } else {
                HttpContent inboundContent = (HttpContent)msg;
                this.currentSize += (long)inboundContent.content().readableBytes();
                this.fullContent.add(inboundContent);
                if (this.currentSize > this.maxEntityBodySize) {
                    this.sendEntityTooLargeResponse(ctx);
                } else if (msg instanceof LastHttpContent) {
                    super.channelRead(ctx, (Object)this.inboundRequest);
                    while (!this.fullContent.isEmpty()) {
                        super.channelRead(ctx, (Object)this.fullContent.pop());
                    }
                } else {
                    ctx.channel().read();
                }
            }
        }
    }

    private void sendEntityTooLargeResponse(ChannelHandlerContext ctx) {
        Util.sendAndCloseNoEntityBodyResp(ctx, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, this.inboundRequest.protocolVersion(), this.serverName);
        this.fullContent.forEach(ReferenceCounted::release);
        this.fullContent.forEach(httpContent -> this.fullContent.remove(httpContent));
        log.warn("Inbound request URI length exceeds the max uri length allowed for a request");
    }

    private boolean isContentLengthInvalid(HttpMessage start, long maxContentLength) {
        try {
            return HttpUtil.getContentLength((HttpMessage)start, (long)-1L) > maxContentLength;
        }
        catch (NumberFormatException var4) {
            return false;
        }
    }
}

