/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Calendar;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.listener.HttpServerChannelInitializer;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.Http2PushPromise;

public class Http2OutboundRespListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(Http2OutboundRespListener.class);
    private static final InternalLogger accessLogger = InternalLoggerFactory.getInstance((String)"http.accesslog");
    private HTTPCarbonMessage inboundRequestMsg;
    private ChannelHandlerContext ctx;
    private Http2ConnectionEncoder encoder;
    private int originalStreamId;
    private Http2Connection conn;
    private String serverName;
    private HttpResponseFuture outboundRespStatusFuture;
    private HttpServerChannelInitializer serverChannelInitializer;
    private Calendar inboundRequestArrivalTime;
    private String remoteAddress = "-";

    public Http2OutboundRespListener(HttpServerChannelInitializer serverChannelInitializer, HTTPCarbonMessage inboundRequestMsg, ChannelHandlerContext ctx, Http2Connection conn, Http2ConnectionEncoder encoder, int streamId, String serverName, String remoteAddress) {
        this.serverChannelInitializer = serverChannelInitializer;
        this.inboundRequestMsg = inboundRequestMsg;
        this.ctx = ctx;
        this.conn = conn;
        this.encoder = encoder;
        this.originalStreamId = streamId;
        this.serverName = serverName;
        if (remoteAddress != null) {
            this.remoteAddress = remoteAddress;
        }
        this.outboundRespStatusFuture = inboundRequestMsg.getHttpOutboundRespStatusFuture();
        this.inboundRequestArrivalTime = Calendar.getInstance();
    }

    @Override
    public void onMessage(HTTPCarbonMessage outboundResponseMsg) {
        this.writeMessage(outboundResponseMsg, this.originalStreamId);
    }

    @Override
    public void onError(Throwable throwable) {
        log.error("Couldn't send the outbound response", throwable);
    }

    @Override
    public void onPushPromise(Http2PushPromise pushPromise) {
        this.ctx.channel().eventLoop().execute(() -> {
            try {
                int promisedStreamId = this.getNextStreamId();
                pushPromise.setPromisedStreamId(promisedStreamId);
                pushPromise.setStreamId(this.originalStreamId);
                HttpRequest httpRequest = pushPromise.getHttpRequest();
                httpRequest.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
                Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers((HttpMessage)httpRequest, (boolean)true);
                ChannelFuture channelFuture = this.encoder.writePushPromise(this.ctx, this.originalStreamId, promisedStreamId, http2Headers, 0, this.ctx.newPromise());
                this.encoder.flowController().writePendingBytes();
                this.ctx.flush();
                Util.checkForResponseWriteStatus(this.inboundRequestMsg, this.outboundRespStatusFuture, channelFuture);
            }
            catch (Exception ex) {
                String errorMsg = "Failed to send push promise : " + ex.getMessage().toLowerCase(Locale.ENGLISH);
                log.error(errorMsg, (Throwable)ex);
                this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(ex);
            }
        });
    }

    @Override
    public void onPushResponse(int promiseId, HTTPCarbonMessage outboundResponseMsg) {
        if (this.isValidStreamId(promiseId)) {
            this.writeMessage(outboundResponseMsg, promiseId);
        } else {
            this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(new ServerConnectorException("Promised stream is already rejected or stream is no longer valid"));
        }
    }

    private void writeMessage(HTTPCarbonMessage outboundResponseMsg, int streamId) {
        ResponseWriter writer = new ResponseWriter(streamId);
        this.ctx.channel().eventLoop().execute(() -> outboundResponseMsg.getHttpContentAsync().setMessageListener(httpContent -> this.ctx.channel().eventLoop().execute(() -> {
            try {
                writer.writeOutboundResponse(outboundResponseMsg, httpContent);
            }
            catch (Http2Exception ex) {
                String errorMsg = "Failed to send the outbound response : " + ex.getMessage().toLowerCase(Locale.ENGLISH);
                log.error(errorMsg, (Throwable)ex);
                this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(ex);
            }
        })));
    }

    private synchronized int getNextStreamId() {
        return this.conn.local().incrementAndGetNextStreamId();
    }

    private boolean isValidStreamId(int streamId) {
        return this.conn.stream(streamId) != null;
    }

    private class ResponseWriter {
        private boolean isHeaderWritten = false;
        private int streamId;
        private Long contentLength = 0L;

        public ResponseWriter(int streamId) {
            this.streamId = streamId;
        }

        private void writeOutboundResponse(HTTPCarbonMessage outboundResponseMsg, HttpContent httpContent) throws Http2Exception {
            if (!this.isHeaderWritten) {
                this.writeHeaders(outboundResponseMsg);
            }
            if (Util.isLastHttpContent(httpContent)) {
                this.writeData(httpContent, true);
                if (Http2OutboundRespListener.this.serverChannelInitializer.isHttpAccessLogEnabled()) {
                    this.logAccessInfo(outboundResponseMsg);
                }
            } else {
                this.writeData(httpContent, false);
            }
        }

        private void writeHeaders(HTTPCarbonMessage outboundResponseMsg) throws Http2Exception {
            outboundResponseMsg.getHeaders().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
            HttpResponse httpMessage = Util.createHttpResponse(outboundResponseMsg, "2.0", Http2OutboundRespListener.this.serverName, true);
            Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers((HttpMessage)httpMessage, (boolean)true);
            this.validatePromisedStreamState();
            this.isHeaderWritten = true;
            ChannelFuture channelFuture = Http2OutboundRespListener.this.encoder.writeHeaders(Http2OutboundRespListener.this.ctx, this.streamId, http2Headers, 0, false, Http2OutboundRespListener.this.ctx.newPromise());
            Http2OutboundRespListener.this.encoder.flowController().writePendingBytes();
            Http2OutboundRespListener.this.ctx.flush();
            Util.addResponseWriteFailureListener(Http2OutboundRespListener.this.outboundRespStatusFuture, channelFuture);
        }

        private void writeData(HttpContent httpContent, boolean endStream) throws Http2Exception {
            this.contentLength = this.contentLength + (long)httpContent.content().readableBytes();
            this.validatePromisedStreamState();
            ChannelFuture channelFuture = Http2OutboundRespListener.this.encoder.writeData(Http2OutboundRespListener.this.ctx, this.streamId, httpContent.content().retain(), 0, endStream, Http2OutboundRespListener.this.ctx.newPromise());
            Http2OutboundRespListener.this.encoder.flowController().writePendingBytes();
            Http2OutboundRespListener.this.ctx.flush();
            if (endStream) {
                Util.checkForResponseWriteStatus(Http2OutboundRespListener.this.inboundRequestMsg, Http2OutboundRespListener.this.outboundRespStatusFuture, channelFuture);
            } else {
                Util.addResponseWriteFailureListener(Http2OutboundRespListener.this.outboundRespStatusFuture, channelFuture);
            }
        }

        private void logAccessInfo(HTTPCarbonMessage outboundResponseMsg) {
            if (!accessLogger.isEnabled(InternalLogLevel.INFO)) {
                return;
            }
            if (Http2OutboundRespListener.this.originalStreamId != this.streamId) {
                log.debug("Access logging skipped for server push response");
                return;
            }
            HttpHeaders headers = Http2OutboundRespListener.this.inboundRequestMsg.getHeaders();
            if (headers.contains("x-forwarded-for")) {
                String forwardedHops = headers.get("x-forwarded-for");
                int firstCommaIndex = forwardedHops.indexOf(44);
                Http2OutboundRespListener.this.remoteAddress = firstCommaIndex != -1 ? forwardedHops.substring(0, firstCommaIndex) : forwardedHops;
            }
            String userAgent = "-";
            if (headers.contains((CharSequence)HttpHeaderNames.USER_AGENT)) {
                userAgent = headers.get((CharSequence)HttpHeaderNames.USER_AGENT);
            }
            String referrer = "-";
            if (headers.contains((CharSequence)HttpHeaderNames.REFERER)) {
                referrer = headers.get((CharSequence)HttpHeaderNames.REFERER);
            }
            String method = (String)Http2OutboundRespListener.this.inboundRequestMsg.getProperty("HTTP_METHOD");
            String uri = (String)Http2OutboundRespListener.this.inboundRequestMsg.getProperty("TO");
            HttpRequest request = Http2OutboundRespListener.this.inboundRequestMsg.getNettyHttpRequest();
            String protocol = request != null ? request.protocolVersion().toString() : (String)Http2OutboundRespListener.this.inboundRequestMsg.getProperty("HTTP_VERSION");
            int statusCode = Util.getHttpResponseStatus(outboundResponseMsg).code();
            accessLogger.log(InternalLogLevel.INFO, String.format("%1$s - - [%2$td/%2$tb/%2$tY:%2$tT %2$tz] \"%3$s %4$s %5$s\" %6$d %7$d \"%8$s\" \"%9$s\"", Http2OutboundRespListener.this.remoteAddress, Http2OutboundRespListener.this.inboundRequestArrivalTime, method, uri, protocol, statusCode, this.contentLength, referrer, userAgent));
        }

        private void validatePromisedStreamState() throws Http2Exception {
            if (this.streamId == Http2OutboundRespListener.this.originalStreamId) {
                return;
            }
            if (!Http2OutboundRespListener.this.isValidStreamId(this.streamId)) {
                Http2OutboundRespListener.this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(new ServerConnectorException("Promised stream is already rejected or stream is no longer valid"));
                throw new Http2Exception(Http2Error.REFUSED_STREAM, "Promised stream is already rejected or stream is no longer valid");
            }
        }
    }
}

