/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.config;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.config.ChunkConfig;
import org.wso2.transport.http.netty.config.KeepAliveConfig;
import org.wso2.transport.http.netty.config.Parameter;
import org.wso2.transport.http.netty.config.RequestSizeValidationConfig;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ListenerConfiguration {
    public static final String DEFAULT_KEY = "default";
    @XmlAttribute(required=true)
    private String id = "default";
    @XmlAttribute
    private String host = "0.0.0.0";
    @XmlAttribute(required=true)
    private int port = 9090;
    private ChunkConfig chunkingConfig = ChunkConfig.AUTO;
    private KeepAliveConfig keepAliveConfig = KeepAliveConfig.AUTO;
    @XmlAttribute
    private boolean bindOnStartup = false;
    @XmlAttribute
    private String scheme = "http";
    @XmlAttribute
    private String version = "1.1";
    @XmlAttribute
    private String keyStoreFile;
    @XmlAttribute
    private String keyStorePassword;
    @XmlAttribute
    private String trustStoreFile;
    @XmlAttribute
    private String trustStorePass;
    @XmlAttribute
    private String certPass;
    @XmlAttribute
    private int socketIdleTimeout;
    @XmlAttribute
    private String messageProcessorId;
    @XmlAttribute
    private boolean httpTraceLogEnabled;
    @XmlAttribute
    private boolean httpAccessLogEnabled;
    @XmlAttribute
    private String verifyClient;
    @XmlAttribute
    private String sslProtocol;
    @XmlAttribute
    private String tlsStoreType;
    @XmlAttribute
    private String serverHeader = "wso2-http-transport";
    @XmlAttribute
    private boolean validateCertEnabled;
    @XmlAttribute
    private int cacheSize = 50;
    @XmlAttribute
    private int cacheValidityPeriod = 15;
    @XmlAttribute
    private boolean ocspStaplingEnabled = false;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    private List<Parameter> parameters = this.getDefaultParameters();
    private RequestSizeValidationConfig requestSizeValidationConfig = new RequestSizeValidationConfig();

    @Deprecated
    public static ListenerConfiguration getDefault() {
        ListenerConfiguration defaultConfig = new ListenerConfiguration(DEFAULT_KEY, "0.0.0.0", 8080);
        return defaultConfig;
    }

    public ListenerConfiguration() {
    }

    public ListenerConfiguration(String id, String host, int port) {
        this.id = id;
        this.host = host;
        this.port = port;
    }

    public String getTLSStoreType() {
        return this.tlsStoreType;
    }

    public void setTLSStoreType(String tlsStoreType) {
        this.tlsStoreType = tlsStoreType;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public void setCertPass(String certPass) {
        this.certPass = certPass;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePass() {
        return this.keyStorePassword;
    }

    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    public void setKeyStorePass(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setVerifyClient(String verifyClient) {
        this.verifyClient = verifyClient;
    }

    public String getVerifyClient() {
        return this.verifyClient;
    }

    public void setSSLProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getSSLProtocol() {
        return this.sslProtocol;
    }

    public boolean validateCertEnabled() {
        return this.validateCertEnabled;
    }

    public void setValidateCertEnabled(boolean validateCertEnabled) {
        this.validateCertEnabled = validateCertEnabled;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheValidityPeriod() {
        return this.cacheValidityPeriod;
    }

    public void setCacheValidityPeriod(int cacheValidityPeriod) {
        this.cacheValidityPeriod = cacheValidityPeriod;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isBindOnStartup() {
        return this.bindOnStartup;
    }

    public void setBindOnStartup(boolean bindOnStartup) {
        this.bindOnStartup = bindOnStartup;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public SSLConfig getSSLConfig() {
        if (this.scheme == null || !this.scheme.equalsIgnoreCase("https")) {
            return null;
        }
        return Util.getSSLConfigForListener(this.certPass, this.keyStorePassword, this.keyStoreFile, this.trustStoreFile, this.trustStorePass, this.parameters, this.verifyClient, this.sslProtocol, this.tlsStoreType);
    }

    private List<Parameter> getDefaultParameters() {
        ArrayList<Parameter> defaultParams = new ArrayList<Parameter>();
        return defaultParams;
    }

    public int getSocketIdleTimeout(int defaultVal) {
        if (this.socketIdleTimeout == 0) {
            return defaultVal;
        }
        return this.socketIdleTimeout;
    }

    public String getMessageProcessorId() {
        return this.messageProcessorId;
    }

    public void setMessageProcessorId(String messageProcessorId) {
        this.messageProcessorId = messageProcessorId;
    }

    public void setSocketIdleTimeout(int socketIdleTimeout) {
        this.socketIdleTimeout = socketIdleTimeout;
    }

    public boolean isHttpTraceLogEnabled() {
        return this.httpTraceLogEnabled;
    }

    public void setHttpTraceLogEnabled(boolean httpTraceLogEnabled) {
        this.httpTraceLogEnabled = httpTraceLogEnabled;
    }

    public boolean isHttpAccessLogEnabled() {
        return this.httpAccessLogEnabled;
    }

    public void setHttpAccessLogEnabled(boolean httpAccessLogEnabled) {
        this.httpAccessLogEnabled = httpAccessLogEnabled;
    }

    public RequestSizeValidationConfig getRequestSizeValidationConfig() {
        return this.requestSizeValidationConfig;
    }

    public void setRequestSizeValidationConfig(RequestSizeValidationConfig requestSizeValidationConfig) {
        this.requestSizeValidationConfig = requestSizeValidationConfig;
    }

    public ChunkConfig getChunkConfig() {
        return this.chunkingConfig;
    }

    public void setChunkConfig(ChunkConfig chunkConfig) {
        this.chunkingConfig = chunkConfig;
    }

    public KeepAliveConfig getKeepAliveConfig() {
        return this.keepAliveConfig;
    }

    public void setKeepAliveConfig(KeepAliveConfig keepAliveConfig) {
        this.keepAliveConfig = keepAliveConfig;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public void setServerHeader(String serverHeader) {
        this.serverHeader = serverHeader;
    }

    public void setOcspStaplingEnabled(boolean ocspStaplingEnabled) {
        this.ocspStaplingEnabled = ocspStaplingEnabled;
    }

    public boolean isOcspStaplingEnabled() {
        return this.ocspStaplingEnabled;
    }
}

