/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.websocket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.HandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contractimpl.websocket.DefaultWebSocketConnection;
import org.wso2.transport.http.netty.contractimpl.websocket.HandshakeFutureImpl;
import org.wso2.transport.http.netty.sender.websocket.WebSocketTargetHandler;

public class WebSocketClient {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClient.class);
    private WebSocketTargetHandler webSocketTargetHandler;
    private final String url;
    private final String subProtocols;
    private final int idleTimeout;
    private final Map<String, String> headers;
    private final WebSocketConnectorListener connectorListener;
    private final EventLoopGroup wsClientEventLoopGroup;
    private final boolean autoRead;
    private Channel channel = null;

    public WebSocketClient(String url, String subProtocols, int idleTimeout, EventLoopGroup wsClientEventLoopGroup, Map<String, String> headers, WebSocketConnectorListener connectorListener, boolean autoRead) {
        this.url = url;
        this.subProtocols = subProtocols;
        this.idleTimeout = idleTimeout;
        this.headers = headers;
        this.connectorListener = connectorListener;
        this.wsClientEventLoopGroup = wsClientEventLoopGroup;
        this.autoRead = autoRead;
    }

    public HandshakeFuture handshake() {
        HandshakeFutureImpl handshakeFuture = new HandshakeFutureImpl();
        try {
            URI uri = new URI(this.url);
            String scheme = uri.getScheme() == null ? "ws" : uri.getScheme();
            final String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
            final int port = this.getPort(uri);
            if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
                log.error("Only WS(S) is supported.");
                throw new SSLException("");
            }
            boolean ssl = "wss".equalsIgnoreCase(scheme);
            final SslContext sslCtx = this.getSslContext(ssl);
            DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
            if (this.headers != null) {
                this.headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
            }
            WebSocketClientHandshaker websocketHandshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, (String)this.subProtocols, (boolean)true, (HttpHeaders)httpHeaders);
            this.webSocketTargetHandler = new WebSocketTargetHandler(websocketHandshaker, ssl, this.url, this.connectorListener);
            Bootstrap clientBootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)clientBootstrap.group(this.wsClientEventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    if (sslCtx != null) {
                        pipeline.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                    }
                    pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
                    pipeline.addLast(new ChannelHandler[]{WebSocketClientCompressionHandler.INSTANCE});
                    if (WebSocketClient.this.idleTimeout > 0) {
                        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler((long)WebSocketClient.this.idleTimeout, (long)WebSocketClient.this.idleTimeout, (long)WebSocketClient.this.idleTimeout, TimeUnit.MILLISECONDS)});
                    }
                    pipeline.addLast(new ChannelHandler[]{WebSocketClient.this.webSocketTargetHandler});
                }
            });
            this.channel = clientBootstrap.connect(uri.getHost(), port).sync().channel();
            this.webSocketTargetHandler.handshakeFuture().addListener((GenericFutureListener)((ChannelFutureListener)clientHandshakeFuture -> {
                Throwable cause = clientHandshakeFuture.cause();
                if (clientHandshakeFuture.isSuccess() && cause == null) {
                    this.channel.config().setAutoRead(this.autoRead);
                    DefaultWebSocketConnection webSocketConnection = this.webSocketTargetHandler.getWebSocketConnection();
                    String actualSubProtocol = websocketHandshaker.actualSubprotocol();
                    this.webSocketTargetHandler.setActualSubProtocol(actualSubProtocol);
                    webSocketConnection.getDefaultWebSocketSession().setNegotiatedSubProtocol(actualSubProtocol);
                    handshakeFuture.notifySuccess(webSocketConnection);
                } else {
                    handshakeFuture.notifyError(cause);
                }
            }));
        }
        catch (Throwable t) {
            handshakeFuture.notifyError(t);
        }
        return handshakeFuture;
    }

    private int getPort(URI uri) {
        String scheme = uri.getScheme();
        if (uri.getPort() == -1) {
            switch (scheme) {
                case "ws": {
                    return 80;
                }
                case "wss": {
                    return 443;
                }
            }
            return -1;
        }
        return uri.getPort();
    }

    private SslContext getSslContext(boolean ssl) throws SSLException {
        if (ssl) {
            return SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        }
        return null;
    }
}

