/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Constants;
import org.wso2.transport.http.netty.common.HttpRoute;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.config.ChunkConfig;
import org.wso2.transport.http.netty.config.ForwardedExtensionConfig;
import org.wso2.transport.http.netty.config.KeepAliveConfig;
import org.wso2.transport.http.netty.config.SenderConfiguration;
import org.wso2.transport.http.netty.contract.ClientConnectorException;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpResponseFuture;
import org.wso2.transport.http.netty.listener.SourceHandler;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.Http2Reset;
import org.wso2.transport.http.netty.message.ResponseHandle;
import org.wso2.transport.http.netty.sender.ConnectionAvailabilityListener;
import org.wso2.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.sender.http2.Http2ConnectionManager;
import org.wso2.transport.http.netty.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.sender.http2.TimeoutHandler;

public class DefaultHttpClientConnector
implements HttpClientConnector {
    private static final Logger log = LoggerFactory.getLogger(HttpClientConnector.class);
    private ConnectionManager connectionManager;
    private Http2ConnectionManager http2ConnectionManager;
    private SenderConfiguration senderConfiguration;
    private SSLConfig sslConfig;
    private int socketIdleTimeout;
    private boolean followRedirect;
    private String httpVersion;
    private ChunkConfig chunkConfig;
    private KeepAliveConfig keepAliveConfig;
    private boolean isHttp2;
    private ForwardedExtensionConfig forwardedExtensionConfig;

    public DefaultHttpClientConnector(ConnectionManager connectionManager, SenderConfiguration senderConfiguration) {
        this.connectionManager = connectionManager;
        this.http2ConnectionManager = connectionManager.getHttp2ConnectionManager();
        this.senderConfiguration = senderConfiguration;
        this.initTargetChannelProperties(senderConfiguration);
        String httpVersion = senderConfiguration.getHttpVersion();
        if (Float.valueOf(httpVersion).floatValue() == 2.0f) {
            this.isHttp2 = true;
        }
    }

    @Override
    public HttpResponseFuture connect() {
        return null;
    }

    @Override
    public HttpResponseFuture getResponse(ResponseHandle responseHandle) {
        return responseHandle.getOutboundMsgHolder().getResponseFuture();
    }

    @Override
    public HttpResponseFuture getNextPushPromise(ResponseHandle responseHandle) {
        return responseHandle.getOutboundMsgHolder().getResponseFuture();
    }

    @Override
    public HttpResponseFuture hasPushPromise(ResponseHandle responseHandle) {
        return responseHandle.getOutboundMsgHolder().getResponseFuture();
    }

    @Override
    public void rejectPushResponse(Http2PushPromise pushPromise) {
        Http2Reset http2Reset = new Http2Reset(pushPromise.getPromisedStreamId());
        OutboundMsgHolder outboundMsgHolder = pushPromise.getOutboundMsgHolder();
        pushPromise.reject();
        outboundMsgHolder.getHttp2ClientChannel().getChannel().write((Object)http2Reset);
    }

    @Override
    public HttpResponseFuture getPushResponse(Http2PushPromise pushPromise) {
        OutboundMsgHolder outboundMsgHolder = pushPromise.getOutboundMsgHolder();
        if (pushPromise.isRejected()) {
            outboundMsgHolder.getResponseFuture().notifyPushResponse(pushPromise.getPromisedStreamId(), new ClientConnectorException("Cannot fetch a response for an rejected promise", HttpResponseStatus.BAD_REQUEST.code()));
        }
        return outboundMsgHolder.getResponseFuture();
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public HttpResponseFuture send(HTTPCarbonMessage httpOutboundRequest) {
        OutboundMsgHolder outboundMsgHolder = new OutboundMsgHolder(httpOutboundRequest);
        return this.send(outboundMsgHolder, httpOutboundRequest);
    }

    public HttpResponseFuture send(final OutboundMsgHolder outboundMsgHolder, final HTTPCarbonMessage httpOutboundRequest) {
        HttpResponseFuture httpResponseFuture;
        final SourceHandler srcHandler = (SourceHandler)((Object)httpOutboundRequest.getProperty("SRC_HANDLER"));
        if (srcHandler == null && log.isDebugEnabled()) {
            log.debug("SRC_HANDLER property not found in the message. Message is not originated from the HTTP Server connector");
        }
        try {
            Http2ClientChannel activeHttp2ClientChannel;
            final HttpRoute route = this.getTargetRoute(httpOutboundRequest);
            if (this.isHttp2 && (activeHttp2ClientChannel = this.http2ConnectionManager.borrowChannel(route)) != null) {
                outboundMsgHolder.setHttp2ClientChannel(activeHttp2ClientChannel);
                activeHttp2ClientChannel.getChannel().eventLoop().execute(() -> activeHttp2ClientChannel.getChannel().write((Object)outboundMsgHolder));
                HttpResponseFuture httpResponseFuture2 = outboundMsgHolder.getResponseFuture();
                httpResponseFuture2.notifyResponseHandle(new ResponseHandle(outboundMsgHolder));
                return httpResponseFuture2;
            }
            final TargetChannel targetChannel = this.connectionManager.borrowTargetChannel(route, srcHandler, this.senderConfiguration);
            final Http2ClientChannel freshHttp2ClientChannel = targetChannel.getHttp2ClientChannel();
            outboundMsgHolder.setHttp2ClientChannel(freshHttp2ClientChannel);
            httpResponseFuture = outboundMsgHolder.getResponseFuture();
            targetChannel.getConnenctionReadyFuture().setListener(new ConnectionAvailabilityListener(){

                @Override
                public void onSuccess(String protocol, ChannelFuture channelFuture) {
                    if (log.isDebugEnabled()) {
                        log.debug("Created the connection to address: {}", (Object)(route.toString() + " " + "Original Channel ID is : " + channelFuture.channel().id()));
                    }
                    if (srcHandler != null) {
                        channelFuture.channel().deregister().addListener(future -> srcHandler.getEventLoop().register(channelFuture.channel()).addListener(future1 -> this.startExecutingOutboundRequest(protocol, channelFuture)));
                    } else {
                        this.startExecutingOutboundRequest(protocol, channelFuture);
                    }
                }

                private void startExecutingOutboundRequest(String protocol, ChannelFuture channelFuture) {
                    if (protocol.equalsIgnoreCase("h2c") || protocol.equalsIgnoreCase("h2")) {
                        this.prepareTargetChannelForHttp2(channelFuture);
                    } else {
                        this.prepareTargetChannelForHttp(channelFuture);
                        targetChannel.writeContent(httpOutboundRequest);
                    }
                }

                private void prepareTargetChannelForHttp2(ChannelFuture channelFuture) {
                    freshHttp2ClientChannel.setSocketIdleTimeout(DefaultHttpClientConnector.this.socketIdleTimeout);
                    DefaultHttpClientConnector.this.connectionManager.getHttp2ConnectionManager().addHttp2ClientChannel(route, freshHttp2ClientChannel);
                    freshHttp2ClientChannel.addDataEventListener("idleStateHandler", new TimeoutHandler(DefaultHttpClientConnector.this.socketIdleTimeout, freshHttp2ClientChannel));
                    if (DefaultHttpClientConnector.this.followRedirect) {
                        DefaultHttpClientConnector.this.setChannelAttributes(channelFuture.channel(), httpOutboundRequest, httpResponseFuture, targetChannel);
                    }
                    freshHttp2ClientChannel.getChannel().eventLoop().execute(() -> freshHttp2ClientChannel.getChannel().write((Object)outboundMsgHolder));
                    httpResponseFuture.notifyResponseHandle(new ResponseHandle(outboundMsgHolder));
                }

                private void prepareTargetChannelForHttp(ChannelFuture channelFuture) {
                    freshHttp2ClientChannel.putInFlightMessage(1, outboundMsgHolder);
                    httpResponseFuture.notifyResponseHandle(new ResponseHandle(outboundMsgHolder));
                    targetChannel.setChannel(channelFuture.channel());
                    targetChannel.configTargetHandler(httpOutboundRequest, httpResponseFuture);
                    targetChannel.setEndPointTimeout(DefaultHttpClientConnector.this.socketIdleTimeout, DefaultHttpClientConnector.this.followRedirect);
                    targetChannel.setCorrelationIdForLogging();
                    targetChannel.setHttpVersion(DefaultHttpClientConnector.this.httpVersion);
                    targetChannel.setChunkConfig(DefaultHttpClientConnector.this.chunkConfig);
                    if (DefaultHttpClientConnector.this.followRedirect) {
                        DefaultHttpClientConnector.this.setChannelAttributes(channelFuture.channel(), httpOutboundRequest, httpResponseFuture, targetChannel);
                    }
                    DefaultHttpClientConnector.this.handleOutboundConnectionHeader(DefaultHttpClientConnector.this.keepAliveConfig, httpOutboundRequest);
                    targetChannel.setForwardedExtension(DefaultHttpClientConnector.this.forwardedExtensionConfig, httpOutboundRequest);
                }

                @Override
                public void onFailure(ClientConnectorException cause) {
                    httpResponseFuture.notifyHttpListener(cause);
                }
            });
        }
        catch (Exception failedCause2) {
            NoSuchElementException failedCause2;
            if (failedCause2 instanceof NoSuchElementException && "Timeout waiting for idle object".equals(failedCause2.getMessage())) {
                failedCause2 = new NoSuchElementException("Could not obtain a connection within maximum wait time");
            }
            DefaultHttpResponseFuture errorResponseFuture = new DefaultHttpResponseFuture();
            errorResponseFuture.notifyHttpListener(failedCause2);
            return errorResponseFuture;
        }
        return httpResponseFuture;
    }

    private HttpRoute getTargetRoute(HTTPCarbonMessage httpCarbonMessage) {
        String host = this.fetchHost(httpCarbonMessage);
        int port = this.fetchPort(httpCarbonMessage);
        return new HttpRoute(host, port);
    }

    private int fetchPort(HTTPCarbonMessage httpCarbonMessage) {
        int port;
        Object intProperty = httpCarbonMessage.getProperty("port");
        if (intProperty != null && intProperty instanceof Integer) {
            port = (Integer)intProperty;
        } else {
            port = this.sslConfig != null ? 443 : 80;
            httpCarbonMessage.setProperty("port", port);
            log.debug("Cannot find property PORT of type integer, hence using " + port);
        }
        return port;
    }

    private String fetchHost(HTTPCarbonMessage httpCarbonMessage) {
        String host;
        Object hostProperty = httpCarbonMessage.getProperty("host");
        if (hostProperty != null && hostProperty instanceof String) {
            host = (String)hostProperty;
        } else {
            host = "localhost";
            httpCarbonMessage.setProperty("host", "localhost");
            log.debug("Cannot find property HOST of type string, hence using localhost as the host");
        }
        return host;
    }

    private void setChannelAttributes(Channel channel, HTTPCarbonMessage httpCarbonRequest, HttpResponseFuture httpResponseFuture, TargetChannel targetChannel) {
        channel.attr(Constants.ORIGINAL_REQUEST).set((Object)httpCarbonRequest);
        channel.attr(Constants.RESPONSE_FUTURE_OF_ORIGINAL_CHANNEL).set((Object)httpResponseFuture);
        channel.attr(Constants.TARGET_CHANNEL_REFERENCE).set((Object)targetChannel);
        channel.attr(Constants.ORIGINAL_CHANNEL_START_TIME).set((Object)System.currentTimeMillis());
        channel.attr(Constants.ORIGINAL_CHANNEL_TIMEOUT).set((Object)this.socketIdleTimeout);
        channel.attr(Constants.CLIENT_CONNECTOR).set((Object)this);
    }

    private void initTargetChannelProperties(SenderConfiguration senderConfiguration) {
        this.httpVersion = senderConfiguration.getHttpVersion();
        this.chunkConfig = senderConfiguration.getChunkingConfig();
        this.followRedirect = senderConfiguration.isFollowRedirect();
        this.socketIdleTimeout = senderConfiguration.getSocketIdleTimeout(300000);
        this.sslConfig = senderConfiguration.getSSLConfig();
        this.keepAliveConfig = senderConfiguration.getKeepAliveConfig();
        this.forwardedExtensionConfig = senderConfiguration.getForwardedExtensionConfig();
    }

    private void handleOutboundConnectionHeader(KeepAliveConfig keepAliveConfig, HTTPCarbonMessage httpOutboundRequest) {
        switch (keepAliveConfig) {
            case AUTO: {
                if (Float.valueOf(this.httpVersion).floatValue() >= 1.1f) {
                    httpOutboundRequest.setHeader(HttpHeaderNames.CONNECTION.toString(), "keep-alive");
                    break;
                }
                httpOutboundRequest.setHeader(HttpHeaderNames.CONNECTION.toString(), "close");
                break;
            }
            case ALWAYS: {
                httpOutboundRequest.setHeader(HttpHeaderNames.CONNECTION.toString(), "keep-alive");
                break;
            }
            case NEVER: {
                httpOutboundRequest.setHeader(HttpHeaderNames.CONNECTION.toString(), "close");
            }
        }
    }
}

