/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Stream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.HttpRoute;
import org.wso2.transport.http.netty.sender.http2.Http2ConnectionManager;
import org.wso2.transport.http.netty.sender.http2.Http2DataEventListener;
import org.wso2.transport.http.netty.sender.http2.OutboundMsgHolder;

public class Http2ClientChannel {
    private ConcurrentHashMap<Integer, OutboundMsgHolder> inFlightMessages;
    private ConcurrentHashMap<Integer, OutboundMsgHolder> promisedMessages;
    private Channel channel;
    private Http2Connection connection;
    private ChannelFuture channelFuture;
    private HttpRoute httpRoute;
    private Http2ConnectionManager http2ConnectionManager;
    private AtomicBoolean isExhausted = new AtomicBoolean(false);
    private AtomicInteger activeStreams = new AtomicInteger(1);
    private boolean upgradedToHttp2 = false;
    private int socketIdleTimeout = 300000;
    private Map<String, Http2DataEventListener> dataEventListeners;
    private static final Logger log = LoggerFactory.getLogger(Http2ClientChannel.class);

    public Http2ClientChannel(Http2ConnectionManager http2ConnectionManager, Http2Connection connection, HttpRoute httpRoute, Channel channel) {
        this.http2ConnectionManager = http2ConnectionManager;
        this.channel = channel;
        this.connection = connection;
        this.httpRoute = httpRoute;
        this.connection.addListener((Http2Connection.Listener)new StreamCloseListener(this));
        this.dataEventListeners = new HashMap<String, Http2DataEventListener>();
        this.inFlightMessages = new ConcurrentHashMap();
        this.promisedMessages = new ConcurrentHashMap();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public void setChannelFuture(ChannelFuture channelFuture) {
        this.channelFuture = channelFuture;
    }

    public void putInFlightMessage(int streamId, OutboundMsgHolder inFlightMessage) {
        if (log.isDebugEnabled()) {
            log.debug("In flight message added to channel: {} with stream id: {}  ", (Object)this.toString(), (Object)streamId);
        }
        this.inFlightMessages.put(streamId, inFlightMessage);
    }

    public OutboundMsgHolder getInFlightMessage(int streamId) {
        if (log.isDebugEnabled()) {
            log.debug("Getting in flight message for stream id: {} from channel: {}", (Object)streamId, (Object)this.toString());
        }
        return this.inFlightMessages.get(streamId);
    }

    void removeInFlightMessage(int streamId) {
        if (log.isDebugEnabled()) {
            log.debug("In flight message for stream id: {} removed from channel: {}", (Object)streamId, (Object)this.toString());
        }
        this.inFlightMessages.remove(streamId);
    }

    void putPromisedMessage(int streamId, OutboundMsgHolder promisedMessage) {
        this.promisedMessages.put(streamId, promisedMessage);
    }

    OutboundMsgHolder getPromisedMessage(int streamId) {
        return this.promisedMessages.get(streamId);
    }

    public boolean isUpgradedToHttp2() {
        return this.upgradedToHttp2;
    }

    public void setUpgradedToHttp2(boolean upgradedToHttp2) {
        this.upgradedToHttp2 = upgradedToHttp2;
    }

    void removePromisedMessage(int streamId) {
        this.promisedMessages.remove(streamId);
    }

    int incrementActiveStreamCount() {
        return this.activeStreams.incrementAndGet();
    }

    void markAsExhausted() {
        this.isExhausted.set(true);
    }

    public void addDataEventListener(String name, Http2DataEventListener dataEventListener) {
        this.dataEventListeners.put(name, dataEventListener);
    }

    public List<Http2DataEventListener> getDataEventListeners() {
        return new ArrayList<Http2DataEventListener>(this.dataEventListeners.values());
    }

    public int getSocketIdleTimeout() {
        return this.socketIdleTimeout;
    }

    public void setSocketIdleTimeout(int socketIdleTimeout) {
        this.socketIdleTimeout = socketIdleTimeout;
    }

    private class StreamCloseListener
    extends Http2EventAdapter {
        private Http2ClientChannel http2ClientChannel;

        public StreamCloseListener(Http2ClientChannel http2ClientChannel2) {
            this.http2ClientChannel = http2ClientChannel2;
        }

        public void onStreamClosed(Http2Stream stream) {
            this.http2ClientChannel.removeInFlightMessage(stream.id());
            Http2ClientChannel.this.activeStreams.decrementAndGet();
            this.http2ClientChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamClose(stream.id()));
            if (Http2ClientChannel.this.isExhausted.getAndSet(false)) {
                Http2ClientChannel.this.http2ConnectionManager.returnClientChannel(Http2ClientChannel.this.httpRoute, this.http2ClientChannel);
            }
        }
    }
}

