/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.ReferenceCountUtil;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.Http2Reset;
import org.wso2.transport.http.netty.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.sender.http2.Http2DataEventListener;
import org.wso2.transport.http.netty.sender.http2.OutboundMsgHolder;

public class ClientOutboundHandler
extends ChannelOutboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ClientOutboundHandler.class);
    private Http2Connection connection;
    private Http2ConnectionEncoder encoder;
    private Http2ClientChannel http2ClientChannel;

    public ClientOutboundHandler(Http2Connection connection, Http2ConnectionEncoder encoder) {
        this.connection = connection;
        this.encoder = encoder;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof OutboundMsgHolder) {
            OutboundMsgHolder outboundMsgHolder = (OutboundMsgHolder)msg;
            new Http2RequestWriter(outboundMsgHolder).writeContent(ctx);
        } else if (msg instanceof Http2Reset) {
            Http2Reset resetMsg = (Http2Reset)msg;
            this.resetStream(ctx, resetMsg.getStreamId(), resetMsg.getError());
        } else {
            ctx.write(msg, promise);
        }
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public void setHttp2ClientChannel(Http2ClientChannel http2ClientChannel) {
        this.http2ClientChannel = http2ClientChannel;
    }

    public Http2ClientChannel getHttp2ClientChannel() {
        return this.http2ClientChannel;
    }

    private synchronized int getNextStreamId() throws Http2Exception {
        int nextStreamId = this.connection.local().incrementAndGetNextStreamId();
        this.connection.local().createStream(nextStreamId, false);
        log.debug("Stream created streamId: {}", (Object)nextStreamId);
        return nextStreamId;
    }

    void resetStream(ChannelHandlerContext ctx, int streamId, Http2Error http2Error) {
        this.encoder.writeRstStream(ctx, streamId, http2Error.code(), ctx.newPromise());
        this.http2ClientChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamReset(streamId));
        ctx.flush();
    }

    private class Http2RequestWriter {
        boolean isHeadersWritten = false;
        HTTPCarbonMessage httpOutboundRequest;
        OutboundMsgHolder outboundMsgHolder;
        int streamId;

        Http2RequestWriter(OutboundMsgHolder outboundMsgHolder) {
            this.outboundMsgHolder = outboundMsgHolder;
            this.httpOutboundRequest = outboundMsgHolder.getRequest();
        }

        void writeContent(ChannelHandlerContext ctx) throws Http2Exception {
            this.httpOutboundRequest.getHttpContentAsync().setMessageListener(httpContent -> ClientOutboundHandler.this.http2ClientChannel.getChannel().eventLoop().execute(() -> {
                try {
                    this.writeOutboundRequest(ctx, httpContent);
                }
                catch (Exception ex) {
                    String errorMsg = "Failed to send the request : " + ex.getMessage().toLowerCase(Locale.ENGLISH);
                    log.error(errorMsg, (Throwable)ex);
                    this.outboundMsgHolder.getResponseFuture().notifyHttpListener(ex);
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeOutboundRequest(ChannelHandlerContext ctx, HttpContent msg) throws Http2Exception {
            boolean endStream = false;
            if (!this.isHeadersWritten) {
                this.streamId = this.initiateStream(ctx);
                HttpRequest httpRequest = Util.createHttpRequest(this.httpOutboundRequest);
                if (msg instanceof LastHttpContent && msg.content().capacity() == 0) {
                    endStream = true;
                }
                this.writeOutboundRequestHeaders(ctx, (HttpMessage)httpRequest, this.streamId, endStream);
                this.isHeadersWritten = true;
                if (endStream) {
                    this.markWriteCompletion();
                    return;
                }
            }
            boolean release = true;
            try {
                boolean isLastContent = false;
                EmptyHttpHeaders trailers = EmptyHttpHeaders.INSTANCE;
                EmptyHttp2Headers http2Trailers = EmptyHttp2Headers.INSTANCE;
                if (msg instanceof LastHttpContent) {
                    isLastContent = true;
                    LastHttpContent lastContent = (LastHttpContent)msg;
                    trailers = lastContent.trailingHeaders();
                    http2Trailers = HttpConversionUtil.toHttp2Headers((HttpHeaders)trailers, (boolean)true);
                }
                ByteBuf content = msg.content();
                endStream = isLastContent && trailers.isEmpty();
                release = false;
                for (Http2DataEventListener dataEventListener : ClientOutboundHandler.this.http2ClientChannel.getDataEventListeners()) {
                    if (dataEventListener.onDataWrite(ctx, this.streamId, content, endStream)) continue;
                    this.markWriteCompletion();
                    return;
                }
                ClientOutboundHandler.this.encoder.writeData(ctx, this.streamId, content, 0, endStream, ctx.newPromise());
                ClientOutboundHandler.this.encoder.flowController().writePendingBytes();
                ctx.flush();
                if (!trailers.isEmpty()) {
                    this.writeHttp2Headers(ctx, this.streamId, (HttpHeaders)trailers, (Http2Headers)http2Trailers, true);
                }
                if (endStream) {
                    this.markWriteCompletion();
                    this.outboundMsgHolder.setRequestWritten(true);
                }
            }
            finally {
                if (release) {
                    ReferenceCountUtil.release((Object)msg);
                }
            }
        }

        private int initiateStream(ChannelHandlerContext ctx) throws Http2Exception {
            int streamId = ClientOutboundHandler.this.getNextStreamId();
            ClientOutboundHandler.this.http2ClientChannel.putInFlightMessage(streamId, this.outboundMsgHolder);
            ClientOutboundHandler.this.http2ClientChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamInit(ctx, streamId));
            return streamId;
        }

        private void writeOutboundRequestHeaders(ChannelHandlerContext ctx, HttpMessage httpMsg, int streamId, boolean endStream) throws Http2Exception {
            httpMsg.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
            Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers((HttpMessage)httpMsg, (boolean)true);
            this.writeHttp2Headers(ctx, streamId, httpMsg.headers(), http2Headers, endStream);
        }

        private void writeHttp2Headers(ChannelHandlerContext ctx, int streamId, HttpHeaders headers, Http2Headers http2Headers, boolean endStream) throws Http2Exception {
            int dependencyId = headers.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), 0);
            short weight = headers.getShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            for (Http2DataEventListener dataEventListener : ClientOutboundHandler.this.http2ClientChannel.getDataEventListeners()) {
                if (dataEventListener.onHeadersWrite(ctx, streamId, http2Headers, endStream)) continue;
                return;
            }
            ClientOutboundHandler.this.encoder.writeHeaders(ctx, streamId, http2Headers, dependencyId, weight, false, 0, endStream, ctx.newPromise());
            ClientOutboundHandler.this.encoder.flowController().writePendingBytes();
            ctx.flush();
            if (endStream) {
                this.markWriteCompletion();
                this.outboundMsgHolder.setRequestWritten(true);
            }
        }

        private void markWriteCompletion() {
            this.httpOutboundRequest.removeHttpContentAsyncFuture();
        }
    }
}

