/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.config.KeepAliveConfig;
import org.wso2.transport.http.netty.contract.ClientConnectorException;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.exception.EndpointTimeOutException;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.message.DefaultListener;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;
import org.wso2.transport.http.netty.message.Listener;
import org.wso2.transport.http.netty.message.PooledDataStreamerFactory;
import org.wso2.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.sender.http2.ClientOutboundHandler;
import org.wso2.transport.http.netty.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.sender.http2.TimeoutHandler;

public class TargetHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(TargetHandler.class);
    private HttpResponseFuture httpResponseFuture;
    private HTTPCarbonMessage targetRespMsg;
    private ConnectionManager connectionManager;
    private TargetChannel targetChannel;
    private ClientOutboundHandler http2ClientOutboundHandler;
    private HTTPCarbonMessage incomingMsg;
    private HandlerExecutor handlerExecutor;
    private KeepAliveConfig keepAliveConfig;
    private boolean idleTimeoutTriggered;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.handlerExecutor = HTTPTransportContextHolder.getInstance().getHandlerExecutor();
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.targetChannel.isRequestHeaderWritten()) {
            if (msg instanceof HttpResponse) {
                OutboundMsgHolder msgHolder;
                HttpResponse httpInboundResponse = (HttpResponse)msg;
                this.targetRespMsg = this.setUpCarbonMessage(ctx, msg);
                if (this.handlerExecutor != null) {
                    this.handlerExecutor.executeAtTargetResponseReceiving(this.targetRespMsg);
                }
                if ((msgHolder = this.http2ClientOutboundHandler.getHttp2ClientChannel().getInFlightMessage(1)) != null) {
                    msgHolder.markNoPromisesReceived();
                }
                if (this.httpResponseFuture != null) {
                    this.httpResponseFuture.notifyHttpListener(this.targetRespMsg);
                } else {
                    log.error("Cannot notify the response to client as there is no associated responseFuture");
                }
                if (httpInboundResponse.decoderResult().isFailure()) {
                    log.warn(httpInboundResponse.decoderResult().cause().getMessage());
                }
            } else if (this.targetRespMsg != null) {
                HttpContent httpContent = (HttpContent)msg;
                this.targetRespMsg.addHttpContent(httpContent);
                if (Util.isLastHttpContent(httpContent)) {
                    if (this.handlerExecutor != null) {
                        this.handlerExecutor.executeAtTargetResponseSending(this.targetRespMsg);
                    }
                    this.targetRespMsg = null;
                    this.targetChannel.getChannel().pipeline().remove("idleStateHandler");
                    if (!this.isKeepAlive(this.keepAliveConfig)) {
                        this.closeChannel(ctx);
                    }
                    this.connectionManager.returnChannel(this.targetChannel);
                }
            }
        } else {
            if (msg instanceof HttpResponse) {
                log.warn("Received a response for an obsolete request", (Object)msg.toString());
            }
            ReferenceCountUtil.release((Object)msg);
        }
    }

    private HTTPCarbonMessage setUpCarbonMessage(ChannelHandlerContext ctx, Object msg) {
        this.targetRespMsg = new HttpCarbonResponse((HttpResponse)msg, (Listener)new DefaultListener(ctx));
        this.targetRespMsg.setProperty("POOLED_BYTE_BUFFER_FACTORY", new PooledDataStreamerFactory(ctx.alloc()));
        this.targetRespMsg.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        HttpResponse httpResponse = (HttpResponse)msg;
        this.targetRespMsg.setProperty("HTTP_STATUS_CODE", httpResponse.status().code());
        this.targetRespMsg.setProperty("executor.workerpool", this.incomingMsg.getProperty("executor.workerpool"));
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetResponseReceiving(this.targetRespMsg);
        }
        return this.targetRespMsg;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Channel " + ctx.channel().id() + " got inactive so closing it from TargetHandler");
        }
        this.closeChannel(ctx);
        this.handleErrorCloseScenarios(ctx.channel().id().asLongText());
        this.connectionManager.invalidateTargetChannel(this.targetChannel);
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetConnectionTermination(Integer.toString(ctx.hashCode()));
            this.handlerExecutor = null;
        }
    }

    private void handleErrorCloseScenarios(String channelID) {
        if (!this.idleTimeoutTriggered) {
            if (this.targetChannel.isRequestHeaderWritten()) {
                this.httpResponseFuture.notifyHttpListener(new ClientConnectorException(channelID, "Remote host closed the connection without sending inbound response"));
            } else if (this.targetRespMsg != null) {
                this.handleIncompleteInboundResponse("Remote host closed the connection without completing inbound response");
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("Exception occurred in TargetHandler for channel " + ctx.channel().id().asLongText(), cause);
        this.httpResponseFuture.notifyHttpListener(cause);
        if (this.targetRespMsg != null) {
            this.handleIncompleteInboundResponse("Exception caught while reading inbound response");
        }
        this.closeChannel(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state() == IdleState.READER_IDLE || event.state() == IdleState.WRITER_IDLE) {
                this.targetChannel.getChannel().pipeline().remove("idleStateHandler");
                this.idleTimeoutTriggered = true;
                this.channelInactive(ctx);
                this.handleErrorIdleScenarios(ctx.channel().id().asLongText());
                log.warn("Idle timeout has reached hence closing the connection {}", (Object)ctx.channel().id());
            }
        } else if (evt instanceof HttpClientUpgradeHandler.UpgradeEvent) {
            HttpClientUpgradeHandler.UpgradeEvent upgradeEvent = (HttpClientUpgradeHandler.UpgradeEvent)evt;
            if (HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL.name().equals(upgradeEvent.name())) {
                this.executePostUpgradeActions(ctx);
            }
            ctx.fireUserEventTriggered(evt);
        } else if (evt instanceof Http2ConnectionPrefaceAndSettingsFrameWrittenEvent) {
            log.debug("Connection Preface and Settings frame written");
        } else if (evt instanceof SslCloseCompletionEvent) {
            log.debug("SSL close completion event received");
        } else if (evt instanceof ChannelInputShutdownReadComplete) {
            log.debug("Input side of the connection is already shutdown");
        } else {
            log.warn("Unexpected user event {} triggered", (Object)evt.toString());
        }
    }

    private void executePostUpgradeActions(ChannelHandlerContext ctx) {
        ctx.pipeline().remove((ChannelHandler)this);
        ctx.pipeline().addLast("outboundHandler", (ChannelHandler)this.http2ClientOutboundHandler);
        Http2ClientChannel http2ClientChannel = this.http2ClientOutboundHandler.getHttp2ClientChannel();
        http2ClientChannel.setUpgradedToHttp2(true);
        Util.safelyRemoveHandlers(this.targetChannel.getChannel().pipeline(), "redirectHandler", "idleStateHandler", "http-trace-logger");
        http2ClientChannel.addDataEventListener("idleStateHandler", new TimeoutHandler(http2ClientChannel.getSocketIdleTimeout(), http2ClientChannel));
        http2ClientChannel.getInFlightMessage(1).setRequestWritten(true);
        http2ClientChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamInit(ctx, 1));
        this.handoverChannelToHttp2ConnectionManager();
    }

    private void handoverChannelToHttp2ConnectionManager() {
        this.connectionManager.getHttp2ConnectionManager().addHttp2ClientChannel(this.targetChannel.getHttpRoute(), this.targetChannel.getHttp2ClientChannel());
    }

    private void handleErrorIdleScenarios(String channelID) {
        if (this.targetRespMsg == null) {
            this.httpResponseFuture.notifyHttpListener(new EndpointTimeOutException(channelID, "Idle timeout triggered before reading inbound response", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
        } else {
            this.handleIncompleteInboundResponse("Idle timeout triggered while reading inbound response");
        }
    }

    private void closeChannel(ChannelHandlerContext ctx) throws Exception {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.close();
        }
    }

    private void handleIncompleteInboundResponse(String errorMessage) {
        DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent();
        lastHttpContent.setDecoderResult(DecoderResult.failure((Throwable)new DecoderException(errorMessage)));
        this.targetRespMsg.addHttpContent((HttpContent)lastHttpContent);
        log.warn(errorMessage);
    }

    public void setHttpResponseFuture(HttpResponseFuture httpResponseFuture) {
        this.httpResponseFuture = httpResponseFuture;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public HTTPCarbonMessage getIncomingMsg() {
        return this.incomingMsg;
    }

    public void setIncomingMsg(HTTPCarbonMessage incomingMsg) {
        this.incomingMsg = incomingMsg;
    }

    public void setTargetChannel(TargetChannel targetChannel) {
        this.targetChannel = targetChannel;
    }

    public KeepAliveConfig getKeepAliveConfig() {
        return this.keepAliveConfig;
    }

    public void setKeepAliveConfig(KeepAliveConfig keepAliveConfig) {
        this.keepAliveConfig = keepAliveConfig;
    }

    public HttpResponseFuture getHttpResponseFuture() {
        return this.httpResponseFuture;
    }

    void setHttp2ClientOutboundHandler(ClientOutboundHandler http2ClientOutboundHandler) {
        this.http2ClientOutboundHandler = http2ClientOutboundHandler;
    }

    private boolean isKeepAlive(KeepAliveConfig keepAliveConfig) {
        switch (keepAliveConfig) {
            case AUTO: {
                return Float.valueOf((String)this.getIncomingMsg().getProperty("HTTP_VERSION")).floatValue() > 1.0f;
            }
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
        }
        return true;
    }
}

