/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Calendar;

public class HttpAccessLoggingHandler
extends LoggingHandler {
    private static final LogLevel LOG_LEVEL = LogLevel.INFO;
    private static final String EVENT_WRITE = "WRITE";
    private String inetAddress;
    private String method;
    private String uri;
    private String protocol;
    private String userAgent = "-";
    private String referrer = "-";
    private int status;
    private Long contentLength = 0L;
    private Calendar calendar;

    public HttpAccessLoggingHandler(String name) {
        super(name, LOG_LEVEL);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        SocketAddress address = ctx.channel().remoteAddress();
        if (address instanceof InetSocketAddress) {
            this.inetAddress = ((InetSocketAddress)address).getAddress().toString();
        }
        if (this.inetAddress.startsWith("/")) {
            this.inetAddress = this.inetAddress.substring(1);
        }
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelInactive();
        this.inetAddress = "-";
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            this.calendar = Calendar.getInstance();
            if (httpRequest.headers().contains("x-forwarded-for")) {
                String proxyChain = httpRequest.headers().get("x-forwarded-for");
                int firstComma = proxyChain.indexOf(44);
                this.inetAddress = firstComma != -1 ? proxyChain.substring(0, proxyChain.indexOf(44)) : proxyChain;
            }
            if (httpRequest.headers().contains((CharSequence)HttpHeaderNames.USER_AGENT)) {
                this.userAgent = httpRequest.headers().get((CharSequence)HttpHeaderNames.USER_AGENT);
            }
            if (httpRequest.headers().contains((CharSequence)HttpHeaderNames.REFERER)) {
                this.referrer = httpRequest.headers().get((CharSequence)HttpHeaderNames.REFERER);
            }
            this.method = httpRequest.method().name();
            this.uri = httpRequest.uri();
            this.protocol = httpRequest.protocolVersion().toString();
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise);
        if (msg instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)msg;
            this.status = httpResponse.status().code();
            if (httpResponse.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                this.contentLength = Long.valueOf(httpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
                if (this.logger.isEnabled(this.internalLevel)) {
                    this.logger.log(this.internalLevel, this.format(ctx, EVENT_WRITE, msg));
                }
                this.clearState();
            }
        } else if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            this.contentLength = this.contentLength + (long)httpContent.content().readableBytes();
            if (msg instanceof LastHttpContent) {
                if (this.logger.isEnabled(this.internalLevel)) {
                    this.logger.log(this.internalLevel, this.format(ctx, EVENT_WRITE, msg));
                }
                this.clearState();
            }
        }
    }

    protected String format(ChannelHandlerContext ctx, String eventName, Object arg) {
        if (EVENT_WRITE.equals(eventName)) {
            return String.format("%1$s - - [%2$td/%2$tb/%2$tY:%2$tT %2$tz] \"%3$s %4$s %5$s\" %6$d %7$d \"%8$s\" \"%9$s\"", this.inetAddress, this.calendar, this.method, this.uri, this.protocol, this.status, this.contentLength, this.referrer, this.userAgent);
        }
        return "";
    }

    private void clearState() {
        this.method = null;
        this.uri = null;
        this.protocol = null;
        this.status = -1;
        this.contentLength = 0L;
        this.calendar = null;
        this.userAgent = "-";
        this.referrer = "-";
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelUnregistered();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireExceptionCaught(cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        ctx.fireUserEventTriggered(evt);
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelReadComplete();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelWritabilityChanged();
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}

