/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.internal.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;

public class WebSocketAsyncRemoteEndpoint
implements RemoteEndpoint.Async {
    private final ChannelHandlerContext ctx;

    public WebSocketAsyncRemoteEndpoint(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public long getSendTimeout() {
        return 0L;
    }

    public void setSendTimeout(long timeoutmillis) {
    }

    public void sendText(String text, SendHandler handler) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public ChannelFuture sendText(String text) {
        return this.ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(text));
    }

    public ChannelFuture sendBinary(ByteBuffer data) {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuffer)data);
        return this.ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf));
    }

    public void sendBinary(ByteBuffer data, SendHandler handler) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public ChannelFuture sendObject(Object data) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public void sendObject(Object data, SendHandler handler) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public void setBatchingAllowed(boolean allowed) throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public boolean getBatchingAllowed() {
        return false;
    }

    public void flushBatch() throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        ByteBuf applicationDataBuf = Unpooled.wrappedBuffer((ByteBuffer)applicationData);
        this.ctx.channel().writeAndFlush((Object)new PingWebSocketFrame(applicationDataBuf));
    }

    public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        ByteBuf applicationDataBuf = Unpooled.wrappedBuffer((ByteBuffer)applicationData);
        this.ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(applicationDataBuf));
    }
}

