/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.common.certificatevalidation.ocsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.certificatevalidation.CertificateVerificationException;
import org.wso2.transport.http.netty.common.certificatevalidation.RevocationStatus;
import org.wso2.transport.http.netty.common.certificatevalidation.RevocationVerifier;
import org.wso2.transport.http.netty.common.certificatevalidation.ocsp.OCSPCache;

public class OCSPVerifier
implements RevocationVerifier {
    private OCSPCache cache;
    private static final Logger log = LoggerFactory.getLogger(OCSPVerifier.class);

    public OCSPVerifier(OCSPCache cache) {
        this.cache = cache;
    }

    @Override
    public RevocationStatus checkRevocationStatus(X509Certificate peerCert, X509Certificate issuerCert) throws CertificateVerificationException {
        SingleResp resp;
        if (this.cache != null && (resp = this.cache.getCacheValue(peerCert.getSerialNumber())) != null) {
            RevocationStatus status = this.getRevocationStatus(resp);
            if (log.isInfoEnabled()) {
                log.info("OCSP response taken from cache.");
            }
            return status;
        }
        OCSPReq request = OCSPVerifier.generateOCSPRequest(issuerCert, peerCert.getSerialNumber());
        List<String> locations = OCSPVerifier.getAIALocations(peerCert);
        OCSPResp ocspResponse = null;
        for (String serviceUrl : locations) {
            SingleResp[] responses;
            try {
                ocspResponse = OCSPVerifier.getOCSPResponce(serviceUrl, request);
                if (0 != ocspResponse.getStatus()) continue;
                BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResponse.getResponseObject();
                responses = basicResponse == null ? null : basicResponse.getResponses();
            }
            catch (Exception e) {
                continue;
            }
            if (responses == null || responses.length != 1) continue;
            SingleResp resp2 = responses[0];
            RevocationStatus status = this.getRevocationStatus(resp2);
            if (this.cache != null) {
                this.cache.setCacheValue(ocspResponse, peerCert.getSerialNumber(), resp2, request, serviceUrl);
            }
            return status;
        }
        throw new CertificateVerificationException("Could not get revocation status from OCSP. Response Status :" + ocspResponse.getStatus());
    }

    private RevocationStatus getRevocationStatus(SingleResp resp) throws CertificateVerificationException {
        CertificateStatus status = resp.getCertStatus();
        if (status == CertificateStatus.GOOD) {
            return RevocationStatus.GOOD;
        }
        if (status instanceof RevokedStatus) {
            return RevocationStatus.REVOKED;
        }
        if (status instanceof UnknownStatus) {
            return RevocationStatus.UNKNOWN;
        }
        throw new CertificateVerificationException("Could not recognize OCSP certificate status for :" + status);
    }

    /*
     * Exception decompiling
     */
    public static OCSPResp getOCSPResponce(String serviceUrl, OCSPReq request) throws CertificateVerificationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws CertificateVerificationException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            byte[] issuerCertEnc = issuerCert.getEncoded();
            X509CertificateHolder certificateHolder = new X509CertificateHolder(issuerCertEnc);
            DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
            CertificateID id = new CertificateID(digCalcProv.get(CertificateID.HASH_SHA1), certificateHolder, serialNumber);
            OCSPReqBuilder builder = new OCSPReqBuilder();
            builder.addRequest(id);
            BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
            builder.setRequestExtensions(new Extensions(new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(nonce.toByteArray()))));
            return builder.build();
        }
        catch (IOException | CertificateEncodingException | OCSPException | OperatorCreationException e) {
            throw new CertificateVerificationException("Cannot generate OCSP Request with the given certificate", e);
        }
    }

    public static List<String> getAIALocations(X509Certificate cert) throws CertificateVerificationException {
        AccessDescription[] accessDescriptions;
        AuthorityInformationAccess authorityInformationAccess;
        byte[] aiaExtensionValue = cert.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (aiaExtensionValue == null) {
            throw new CertificateVerificationException("Certificate doesn't have Authority Information Access points");
        }
        ASN1InputStream asn1InputStream = null;
        try {
            DEROctetString oct = (DEROctetString)new ASN1InputStream((InputStream)new ByteArrayInputStream(aiaExtensionValue)).readObject();
            asn1InputStream = new ASN1InputStream(oct.getOctets());
            authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)asn1InputStream.readObject());
        }
        catch (IOException e) {
            throw new CertificateVerificationException("Cannot read certificate to get OSCP urls", e);
        }
        finally {
            try {
                if (asn1InputStream != null) {
                    asn1InputStream.close();
                }
            }
            catch (IOException e) {
                log.error("Cannot close ASN1InputStream", (Throwable)e);
            }
        }
        ArrayList<String> ocspUrlList = new ArrayList<String>();
        for (AccessDescription accessDescription : accessDescriptions = authorityInformationAccess.getAccessDescriptions()) {
            GeneralName gn = accessDescription.getAccessLocation();
            if (gn.getTagNo() != 6) continue;
            DERIA5String str = DERIA5String.getInstance((Object)gn.getName());
            String accessLocation = str.getString();
            ocspUrlList.add(accessLocation);
        }
        if (ocspUrlList.isEmpty()) {
            throw new CertificateVerificationException("Cannot get OCSP urls from certificate");
        }
        return ocspUrlList;
    }
}

