/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.metrics;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.MetricManagementService;
import org.wso2.carbon.metrics.core.MetricService;
import org.wso2.msf4j.analytics.metrics.Metrics;

@Component(name="org.wso2.msf4j.analytics.metrics.MetricsComponent")
public class MetricsComponent {
    private static final Logger logger = LoggerFactory.getLogger(MetricsComponent.class);

    @Activate
    protected void activate() {
        if (logger.isInfoEnabled()) {
            logger.info("Metrics Component is activated");
        }
    }

    @Deactivate
    protected void deactivate() {
        if (logger.isInfoEnabled()) {
            logger.info("Metrics Component is deactivated");
        }
    }

    @Reference(name="carbon.metrics.service", service=MetricService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetMetricService")
    protected void setMetricService(MetricService metricService) {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting MetricService reference");
        }
        Metrics.getInstance().setMetricService(metricService);
    }

    protected void unsetMetricService(MetricService metricService) {
        Metrics.getInstance().setMetricService(null);
    }

    @Reference(name="carbon.metrics.management.service", service=MetricManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetMetricManagementService")
    protected void setMetricManagementService(MetricManagementService metricManagementService) {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting MetricManagementService reference");
        }
        Metrics.getInstance().setMetricManagementService(metricManagementService);
    }

    protected void unsetMetricManagementService(MetricManagementService metricManagementService) {
        Metrics.getInstance().setMetricManagementService(null);
    }
}

