/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Constants;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpClientConnector;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.sender.RedirectUtil;
import org.wso2.transport.http.netty.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.sender.http2.Http2DataEventListener;
import org.wso2.transport.http.netty.sender.http2.OutboundMsgHolder;

public class RedirectHandler
implements Http2DataEventListener {
    private static final Logger log = LoggerFactory.getLogger(RedirectHandler.class);
    private Http2ClientChannel http2ClientChannel;
    private int maxRedirectCount;

    public RedirectHandler(Http2ClientChannel http2ClientChannel, int maxRedirectCount) {
        this.http2ClientChannel = http2ClientChannel;
        this.maxRedirectCount = maxRedirectCount;
    }

    @Override
    public boolean onStreamInit(ChannelHandlerContext ctx, int streamId) {
        return true;
    }

    @Override
    public boolean onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        int statusCode = this.fetchStatusCode(headers);
        if (!this.isRedirectionResponse(statusCode)) {
            return true;
        }
        String location = this.fetchLocationHeaderVal(headers);
        if (location == null) {
            return true;
        }
        if (outboundMsgHolder.incrementRedirectCount() > this.maxRedirectCount) {
            return true;
        }
        if (endOfStream) {
            this.doRedirection(ctx, streamId, statusCode, outboundMsgHolder, location, this.fetchUserAgentHeaderVal(headers));
        } else {
            outboundMsgHolder.markForRedirection();
            outboundMsgHolder.setRedirectResponseHeaders(headers);
        }
        return false;
    }

    @Override
    public boolean onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, boolean endOfStream) {
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        if (outboundMsgHolder.isMarkedForRedirection()) {
            if (endOfStream) {
                Http2Headers headers = outboundMsgHolder.getRedirectResponseHeaders();
                this.doRedirection(ctx, streamId, this.fetchStatusCode(headers), outboundMsgHolder, this.fetchLocationHeaderVal(headers), this.fetchUserAgentHeaderVal(headers));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean onPushPromiseRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        return true;
    }

    @Override
    public boolean onHeadersWrite(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        return true;
    }

    @Override
    public boolean onDataWrite(ChannelHandlerContext ctx, int streamId, ByteBuf data, boolean endOfStream) {
        return true;
    }

    @Override
    public boolean onStreamReset(int streamId) {
        return true;
    }

    @Override
    public boolean onStreamClose(int streamId) {
        return true;
    }

    @Override
    public void destroy() {
    }

    private void doRedirection(ChannelHandlerContext ctx, int streamId, int statusCode, OutboundMsgHolder outboundMsgHolder, String location, String userAgent) {
        try {
            HTTPCarbonMessage originalRequest = outboundMsgHolder.getRequest();
            String redirectionMethod = this.getRedirectionRequestMethod(statusCode, originalRequest);
            String redirectionURL = RedirectUtil.getResolvedRedirectURI(location, originalRequest);
            List headers = originalRequest.getHeaders().entries();
            HTTPCarbonMessage request = RedirectUtil.createRedirectCarbonRequest(redirectionURL, redirectionMethod, statusCode, ctx, headers);
            outboundMsgHolder.clearRedirectionState();
            this.http2ClientChannel.removeInFlightMessage(streamId);
            outboundMsgHolder.updateRequest(request);
            DefaultHttpClientConnector connector = (DefaultHttpClientConnector)ctx.channel().attr(Constants.CLIENT_CONNECTOR).get();
            connector.send(outboundMsgHolder, request);
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnsupportedEncodingException occurred when constructing direction request", (Throwable)e);
        }
        catch (MalformedURLException e) {
            log.error("MalformedURLException occurred when constructing direction request", (Throwable)e);
        }
        catch (URISyntaxException e) {
            log.error("URISyntaxException occurred when constructing direction request", (Throwable)e);
        }
    }

    private int fetchStatusCode(Http2Headers headers) {
        HttpResponseStatus responseStatus;
        try {
            responseStatus = HttpConversionUtil.parseStatus((CharSequence)headers.status());
        }
        catch (Http2Exception e) {
            responseStatus = HttpResponseStatus.BAD_GATEWAY;
        }
        return responseStatus.code();
    }

    private String fetchLocationHeaderVal(Http2Headers headers) {
        return headers.get((Object)HttpHeaderNames.LOCATION) != null ? ((CharSequence)headers.get((Object)HttpHeaderNames.LOCATION)).toString() : null;
    }

    private String fetchUserAgentHeaderVal(Http2Headers headers) {
        return headers.get((Object)HttpHeaderNames.USER_AGENT) != null ? ((CharSequence)headers.get((Object)HttpHeaderNames.USER_AGENT)).toString() : null;
    }

    private boolean isRedirectionResponse(int statusCode) {
        return statusCode >= 300 && statusCode < 400;
    }

    private String getRedirectionRequestMethod(int statusCode, HTTPCarbonMessage originalRequest) {
        String originalRequestMethod = originalRequest != null ? (String)originalRequest.getProperty("HTTP_METHOD") : null;
        switch (statusCode) {
            case 300: 
            case 305: 
            case 307: 
            case 308: {
                if (!"GET".equals(originalRequestMethod) && !"HEAD".equals(originalRequestMethod)) break;
                return originalRequestMethod;
            }
            case 301: 
            case 302: {
                if (!"GET".equals(originalRequestMethod) && !"HEAD".equals(originalRequestMethod)) break;
                return "GET";
            }
            case 303: {
                return "GET";
            }
        }
        return null;
    }
}

