/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.channel.pool;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.sender.channel.TargetChannel;

public class PoolableTargetChannelFactoryPerSrcHndlr
implements PoolableObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(PoolableTargetChannelFactoryPerSrcHndlr.class);
    private final GenericObjectPool genericObjectPool;

    PoolableTargetChannelFactoryPerSrcHndlr(GenericObjectPool genericObjectPool) {
        this.genericObjectPool = genericObjectPool;
    }

    public Object makeObject() throws Exception {
        TargetChannel targetChannel = (TargetChannel)this.genericObjectPool.borrowObject();
        log.debug("Created channel: {}", (Object)targetChannel);
        return targetChannel;
    }

    public void destroyObject(Object o) throws Exception {
        if (((TargetChannel)o).getChannel().isActive()) {
            if (log.isDebugEnabled()) {
                log.debug("Original Channel " + ((TargetChannel)o).getChannel().id() + " is returned to the pool. ");
            }
            this.genericObjectPool.returnObject(o);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Original Channel is destroyed. ");
            }
            this.genericObjectPool.invalidateObject(o);
        }
    }

    public boolean validateObject(Object o) {
        if (((TargetChannel)o).getChannel() != null) {
            boolean answer = ((TargetChannel)o).getChannel().isActive();
            log.debug("Validating channel: {} -> {}", o, (Object)answer);
            return answer;
        }
        return true;
    }

    public void activateObject(Object o) throws Exception {
    }

    public void passivateObject(Object o) throws Exception {
    }
}

