/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.HttpRoute;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.config.ChunkConfig;
import org.wso2.transport.http.netty.config.ForwardedExtensionConfig;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.listener.HTTPTraceLoggingHandler;
import org.wso2.transport.http.netty.listener.SourceHandler;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.sender.ConnectionAvailabilityFuture;
import org.wso2.transport.http.netty.sender.ForwardedHeaderUpdater;
import org.wso2.transport.http.netty.sender.HttpClientChannelInitializer;
import org.wso2.transport.http.netty.sender.TargetHandler;
import org.wso2.transport.http.netty.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.sender.http2.RedirectHandler;

public class TargetChannel {
    private static final Logger log = LoggerFactory.getLogger(TargetChannel.class);
    private Channel channel;
    private TargetHandler targetHandler;
    private HttpClientChannelInitializer httpClientChannelInitializer;
    private HttpRoute httpRoute;
    private SourceHandler correlatedSource;
    private ChannelFuture channelFuture;
    private ConnectionManager connectionManager;
    private boolean requestHeaderWritten = false;
    private String httpVersion;
    private ChunkConfig chunkConfig;
    private HttpResponseFuture httpInboundResponseFuture;
    private HandlerExecutor handlerExecutor;
    private Http2ClientChannel http2ClientChannel;
    private List<HttpContent> contentList = new ArrayList<HttpContent>();
    private long contentLength = 0L;
    private final ConnectionAvailabilityFuture connectionAvailabilityFuture;

    public TargetChannel(HttpClientChannelInitializer httpClientChannelInitializer, ChannelFuture channelFuture, HttpRoute httpRoute, ConnectionAvailabilityFuture connectionAvailabilityFuture) {
        this.httpClientChannelInitializer = httpClientChannelInitializer;
        this.channelFuture = channelFuture;
        this.handlerExecutor = HTTPTransportContextHolder.getInstance().getHandlerExecutor();
        this.httpRoute = httpRoute;
        if (httpClientChannelInitializer != null) {
            this.http2ClientChannel = new Http2ClientChannel(httpClientChannelInitializer.getHttp2ConnectionManager(), httpClientChannelInitializer.getConnection(), httpRoute, channelFuture.channel());
            if (httpClientChannelInitializer.isFollowRedirect()) {
                this.http2ClientChannel.addDataEventListener("redirectHandler", new RedirectHandler(this.http2ClientChannel, httpClientChannelInitializer.getMaxRedirectCount()));
            }
        }
        this.connectionAvailabilityFuture = connectionAvailabilityFuture;
    }

    public ConnectionAvailabilityFuture getConnenctionReadyFuture() {
        return this.connectionAvailabilityFuture;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public TargetChannel setChannel(Channel channel) {
        this.channel = channel;
        return this;
    }

    private TargetHandler getTargetHandler() {
        return this.targetHandler;
    }

    private void setTargetHandler(TargetHandler targetHandler) {
        this.targetHandler = targetHandler;
    }

    private HttpClientChannelInitializer getHttpClientChannelInitializer() {
        return this.httpClientChannelInitializer;
    }

    public HttpRoute getHttpRoute() {
        return this.httpRoute;
    }

    public void setHttpRoute(HttpRoute httpRoute) {
        this.httpRoute = httpRoute;
    }

    public SourceHandler getCorrelatedSource() {
        return this.correlatedSource;
    }

    public void setCorrelatedSource(SourceHandler correlatedSource) {
        this.correlatedSource = correlatedSource;
    }

    public boolean isRequestHeaderWritten() {
        return this.requestHeaderWritten;
    }

    public void setRequestHeaderWritten(boolean isRequestWritten) {
        this.requestHeaderWritten = isRequestWritten;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void setChunkConfig(ChunkConfig chunkConfig) {
        this.chunkConfig = chunkConfig;
    }

    public void configTargetHandler(HTTPCarbonMessage httpCarbonMessage, HttpResponseFuture httpInboundResponseFuture) {
        this.setTargetHandler(this.getHttpClientChannelInitializer().getTargetHandler());
        TargetHandler targetHandler = this.getTargetHandler();
        targetHandler.setHttpResponseFuture(httpInboundResponseFuture);
        targetHandler.setIncomingMsg(httpCarbonMessage);
        targetHandler.setConnectionManager(this.connectionManager);
        targetHandler.setTargetChannel(this);
        this.httpInboundResponseFuture = httpInboundResponseFuture;
    }

    public void setEndPointTimeout(int socketIdleTimeout, boolean followRedirect) {
        this.getChannel().pipeline().addBefore(followRedirect ? "redirectHandler" : "targetHandler", "idleStateHandler", (ChannelHandler)new IdleStateHandler((long)socketIdleTimeout, (long)socketIdleTimeout, 0L, TimeUnit.MILLISECONDS));
        this.http2ClientChannel.setSocketIdleTimeout(socketIdleTimeout);
    }

    public void setCorrelationIdForLogging() {
        ChannelPipeline pipeline = this.getChannel().pipeline();
        SourceHandler srcHandler = this.getCorrelatedSource();
        if (srcHandler != null && pipeline.get("http-trace-logger") != null) {
            HTTPTraceLoggingHandler loggingHandler = (HTTPTraceLoggingHandler)pipeline.get("http-trace-logger");
            loggingHandler.setCorrelatedSourceId(srcHandler.getInboundChannelContext().channel().id().asShortText());
        }
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public Http2ClientChannel getHttp2ClientChannel() {
        return this.http2ClientChannel;
    }

    public void writeContent(HTTPCarbonMessage httpOutboundRequest) {
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetRequestReceiving(httpOutboundRequest);
        }
        httpOutboundRequest.getHttpContentAsync().setMessageListener(httpContent -> this.channel.eventLoop().execute(() -> {
            try {
                this.writeOutboundRequest(httpOutboundRequest, httpContent);
            }
            catch (Exception exception) {
                String errorMsg = "Failed to send the request : " + exception.getMessage().toLowerCase(Locale.ENGLISH);
                log.error(errorMsg, (Throwable)exception);
                this.targetHandler.getHttpResponseFuture().notifyHttpListener(exception);
            }
        }));
    }

    private void writeOutboundRequest(HTTPCarbonMessage httpOutboundRequest, HttpContent httpContent) throws Exception {
        if (Util.isLastHttpContent(httpContent)) {
            if (!this.requestHeaderWritten) {
                if (Util.isEntityBodyAllowed(this.getHttpMethod(httpOutboundRequest))) {
                    if (this.chunkConfig == ChunkConfig.ALWAYS && Util.isVersionCompatibleForChunking(this.httpVersion) || Util.shouldEnforceChunkingforHttpOneZero(this.chunkConfig, this.httpVersion)) {
                        Util.setupChunkedRequest(httpOutboundRequest);
                    } else {
                        this.contentLength += (long)httpContent.content().readableBytes();
                        Util.setupContentLengthRequest(httpOutboundRequest, this.contentLength);
                    }
                }
                this.writeOutboundRequestHeaders(httpOutboundRequest);
            }
            this.writeOutboundRequestBody(httpContent);
            this.resetState(httpOutboundRequest);
            if (this.handlerExecutor != null) {
                this.handlerExecutor.executeAtTargetRequestSending(httpOutboundRequest);
            }
        } else if ((this.chunkConfig == ChunkConfig.ALWAYS || this.chunkConfig == ChunkConfig.AUTO) && Util.isVersionCompatibleForChunking(this.httpVersion) || Util.shouldEnforceChunkingforHttpOneZero(this.chunkConfig, this.httpVersion)) {
            if (!this.requestHeaderWritten) {
                Util.setupChunkedRequest(httpOutboundRequest);
                this.writeOutboundRequestHeaders(httpOutboundRequest);
            }
            ChannelFuture outboundRequestChannelFuture = this.getChannel().writeAndFlush((Object)httpContent);
            this.notifyIfFailure(outboundRequestChannelFuture);
        } else {
            this.contentList.add(httpContent);
            this.contentLength += (long)httpContent.content().readableBytes();
        }
    }

    private void writeOutboundRequestBody(HttpContent lastHttpContent) {
        if (this.chunkConfig == ChunkConfig.NEVER || !Util.isVersionCompatibleForChunking(this.httpVersion)) {
            for (HttpContent cachedHttpContent : this.contentList) {
                ChannelFuture outboundRequestChannelFuture = this.getChannel().writeAndFlush((Object)cachedHttpContent);
                this.notifyIfFailure(outboundRequestChannelFuture);
            }
        }
        ChannelFuture outboundRequestChannelFuture = this.getChannel().writeAndFlush((Object)lastHttpContent);
        this.notifyIfFailure(outboundRequestChannelFuture);
    }

    private void notifyIfFailure(ChannelFuture outboundRequestChannelFuture) {
        outboundRequestChannelFuture.addListener(writeOperationPromise -> {
            if (writeOperationPromise.cause() != null) {
                Throwable throwable = writeOperationPromise.cause();
                if (throwable instanceof ClosedChannelException) {
                    throwable = new IOException("Remote host closed the connection before completing outbound request");
                }
                log.error("Remote host closed the connection before completing outbound request", throwable);
                this.httpInboundResponseFuture.notifyHttpListener(throwable);
            }
        });
    }

    private void resetState(HTTPCarbonMessage httpOutboundRequest) {
        httpOutboundRequest.removeHttpContentAsyncFuture();
        this.contentList.clear();
        this.contentLength = 0L;
    }

    private String getHttpMethod(HTTPCarbonMessage httpOutboundRequest) throws Exception {
        String httpMethod = (String)httpOutboundRequest.getProperty("HTTP_METHOD");
        if (httpMethod == null) {
            throw new Exception("Couldn't get the HTTP method from the outbound request");
        }
        return httpMethod;
    }

    private void writeOutboundRequestHeaders(HTTPCarbonMessage httpOutboundRequest) {
        this.setHttpVersionProperty(httpOutboundRequest);
        HttpRequest httpRequest = Util.createHttpRequest(httpOutboundRequest);
        this.setRequestHeaderWritten(true);
        this.getChannel().write((Object)httpRequest);
    }

    private void setHttpVersionProperty(HTTPCarbonMessage httpOutboundRequest) {
        if (Float.valueOf(this.httpVersion).floatValue() == 2.0f) {
            httpOutboundRequest.setProperty("HTTP_VERSION", Float.valueOf(1.1f));
        } else {
            httpOutboundRequest.setProperty("HTTP_VERSION", this.httpVersion);
        }
    }

    public void setForwardedExtension(ForwardedExtensionConfig forwardedConfig, HTTPCarbonMessage httpOutboundRequest) {
        if (forwardedConfig == ForwardedExtensionConfig.DISABLE) {
            return;
        }
        String localAddress = ((InetSocketAddress)this.getChannel().localAddress()).getAddress().getHostAddress();
        ForwardedHeaderUpdater headerUpdater = new ForwardedHeaderUpdater(httpOutboundRequest, localAddress);
        if (headerUpdater.isForwardedHeaderRequired()) {
            headerUpdater.setForwardedHeader();
            return;
        }
        if (headerUpdater.isXForwardedHeaderRequired()) {
            if (forwardedConfig == ForwardedExtensionConfig.ENABLE) {
                headerUpdater.setDefactoForwardedHeaders();
                return;
            }
            headerUpdater.transformAndSetForwardedHeader();
            return;
        }
        log.warn("Both Forwarded and X-Forwarded-- headers are present. Hence updating only the forwarded header");
        headerUpdater.setForwardedHeader();
    }
}

