/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.Http2CodecUtil;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.listener.Http2SourceHandlerBuilder;
import org.wso2.transport.http.netty.listener.HttpServerChannelInitializer;

public class Http2WithPriorKnowledgeHandler
extends ChannelInboundHandlerAdapter {
    private String interfaceId;
    private String serverName;
    private ServerConnectorFuture serverConnectorFuture;
    private HttpServerChannelInitializer serverChannelInitializer;

    public Http2WithPriorKnowledgeHandler(String interfaceId, String serverName, ServerConnectorFuture serverConnectorFuture, HttpServerChannelInitializer serverChannelInitializer) {
        this.interfaceId = interfaceId;
        this.serverName = serverName;
        this.serverConnectorFuture = serverConnectorFuture;
        this.serverChannelInitializer = serverChannelInitializer;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf inputData = (ByteBuf)msg;
            ByteBuf clientPrefaceString = Http2CodecUtil.connectionPrefaceBuf();
            int bytesRead = Math.min(inputData.readableBytes(), clientPrefaceString.readableBytes());
            ChannelPipeline pipeline = ctx.pipeline();
            if (ByteBufUtil.equals((ByteBuf)inputData, (int)inputData.readerIndex(), (ByteBuf)clientPrefaceString, (int)clientPrefaceString.readerIndex(), (int)bytesRead)) {
                Util.safelyRemoveHandlers(pipeline, "ServerCodec");
                pipeline.addBefore("Http2UpgradeHandler", "Http2SourceHandler", (ChannelHandler)new Http2SourceHandlerBuilder(this.interfaceId, this.serverConnectorFuture, this.serverName, this.serverChannelInitializer).build());
                Util.safelyRemoveHandlers(pipeline, "Http2UpgradeHandler", "compressor", "http-trace-logger");
            }
            pipeline.remove((ChannelHandler)this);
            ctx.fireChannelRead(msg);
        }
    }
}

