/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.internal;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.internal.MessagingHandler;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class HandlerExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerExecutor.class);
    private Map<String, MessagingHandler> handlers = new HashMap<String, MessagingHandler>();

    public void executeAtSourceConnectionInitiation(String metadata) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtSourceConnectionInitiation(metadata));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source connection initiation ", (Throwable)e);
        }
    }

    public void executeAtSourceConnectionTermination(String metadata) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtSourceConnectionTermination(metadata));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source connection termination ", (Throwable)e);
        }
    }

    public void executeAtSourceRequestReceiving(HTTPCarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtSourceRequestReceiving(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source request receiving ", (Throwable)e);
        }
    }

    public void executeAtSourceRequestSending(HTTPCarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtSourceRequestSending(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source request sending ", (Throwable)e);
        }
    }

    public void executeAtTargetRequestReceiving(HTTPCarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtTargetRequestReceiving(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Target request receiving ", (Throwable)e);
        }
    }

    public void executeAtTargetRequestSending(HTTPCarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtTargetRequestSending(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Target request sending ", (Throwable)e);
        }
    }

    public void executeAtTargetResponseReceiving(HTTPCarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtTargetResponseReceiving(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Target response receiving ", (Throwable)e);
        }
    }

    public void executeAtTargetResponseSending(HTTPCarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtTargetResponseSending(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Target response sending ", (Throwable)e);
        }
    }

    public void executeAtSourceResponseReceiving(HTTPCarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtSourceResponseReceiving(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source response receiving ", (Throwable)e);
        }
    }

    public void executeAtSourceResponseSending(HTTPCarbonMessage carbonMessage) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtSourceResponseSending(carbonMessage));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Source response sending ", (Throwable)e);
        }
    }

    public void executeAtTargetConnectionInitiation(String metadata) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtTargetConnectionInitiation(metadata));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Target connection initiation ", (Throwable)e);
        }
    }

    public void executeAtTargetConnectionTermination(String metadata) {
        try {
            this.handlers.forEach((k, v) -> v.invokeAtTargetConnectionTermination(metadata));
        }
        catch (Exception e) {
            LOG.error("Error while executing handler at Target connection termination ", (Throwable)e);
        }
    }

    public void addHandler(MessagingHandler messagingHandler) {
        this.handlers.put(messagingHandler.handlerName(), messagingHandler);
        LOG.info("A new handler named " + messagingHandler.handlerName() + " is added to the Handler Executor");
    }

    public void removeHandler(MessagingHandler messagingHandler) {
        this.handlers.remove(messagingHandler.handlerName());
        LOG.info("Handler named " + messagingHandler.handlerName() + " is removed from the Handler Executor");
    }
}

