/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.nio.ByteBuffer;
import javax.websocket.Session;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketFrameType;
import org.wso2.transport.http.netty.internal.websocket.DefaultWebSocketSession;

public class DefaultWebSocketConnection
implements WebSocketConnection {
    private final ChannelHandlerContext ctx;
    private final DefaultWebSocketSession session;
    private WebSocketFrameType continuationFrameType = null;
    private boolean closeFrameSent = false;
    private boolean closeFrameReceived = false;

    public DefaultWebSocketConnection(ChannelHandlerContext ctx, DefaultWebSocketSession session) {
        this.ctx = ctx;
        this.session = session;
    }

    @Override
    public String getId() {
        return this.session.getId();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void readNextFrame() {
        this.ctx.channel().read();
    }

    @Override
    public void startReadingFrames() {
        this.ctx.channel().config().setAutoRead(true);
    }

    @Override
    public void stopReadingFrames() {
        this.ctx.channel().config().setAutoRead(false);
    }

    @Override
    public ChannelFuture pushText(String text) {
        return this.pushText(text, true);
    }

    @Override
    public ChannelFuture pushText(String text, boolean finalFrame) {
        if (this.continuationFrameType == WebSocketFrameType.BINARY) {
            throw new IllegalStateException("Cannot interrupt WebSocket binary frame continuation");
        }
        if (this.closeFrameSent) {
            throw new IllegalStateException("Already sent close frame. Cannot push text data!");
        }
        if (this.continuationFrameType != null) {
            if (finalFrame) {
                this.continuationFrameType = null;
            }
            return this.ctx.writeAndFlush((Object)new ContinuationWebSocketFrame(finalFrame, 0, text));
        }
        if (!finalFrame) {
            this.continuationFrameType = WebSocketFrameType.TEXT;
        }
        return this.ctx.writeAndFlush((Object)new TextWebSocketFrame(finalFrame, 0, text));
    }

    @Override
    public ChannelFuture pushBinary(ByteBuffer data) {
        return this.pushBinary(data, true);
    }

    @Override
    public ChannelFuture pushBinary(ByteBuffer data, boolean finalFrame) {
        if (this.continuationFrameType == WebSocketFrameType.TEXT) {
            throw new IllegalStateException("Cannot interrupt WebSocket text frame continuation");
        }
        if (this.closeFrameSent) {
            throw new IllegalStateException("Already sent close frame. Cannot push binary data!");
        }
        if (this.continuationFrameType != null) {
            if (finalFrame) {
                this.continuationFrameType = null;
            }
            return this.ctx.writeAndFlush((Object)new ContinuationWebSocketFrame(finalFrame, 0, this.getNettyBuf(data)));
        }
        if (!finalFrame) {
            this.continuationFrameType = WebSocketFrameType.BINARY;
        }
        return this.ctx.writeAndFlush((Object)new BinaryWebSocketFrame(finalFrame, 0, this.getNettyBuf(data)));
    }

    @Override
    public ChannelFuture ping(ByteBuffer data) {
        return this.ctx.writeAndFlush((Object)new PingWebSocketFrame(this.getNettyBuf(data)));
    }

    @Override
    public ChannelFuture pong(ByteBuffer data) {
        return this.ctx.writeAndFlush((Object)new PongWebSocketFrame(this.getNettyBuf(data)));
    }

    @Override
    public ChannelFuture close(int statusCode, String reason) {
        this.closeFrameSent = true;
        return this.ctx.writeAndFlush((Object)new CloseWebSocketFrame(statusCode, reason));
    }

    @Override
    public ChannelFuture close() {
        return this.ctx.close();
    }

    @Override
    public boolean closeFrameSent() {
        return this.closeFrameSent;
    }

    @Override
    public boolean closeFrameReceived() {
        return this.closeFrameReceived;
    }

    public void setCloseFrameReceived(boolean closeFrameReceived) {
        this.closeFrameReceived = closeFrameReceived;
    }

    @Deprecated
    public DefaultWebSocketSession getDefaultWebSocketSession() {
        return this.session;
    }

    public ByteBuf getNettyBuf(ByteBuffer buffer) {
        return Unpooled.wrappedBuffer((ByteBuffer)buffer);
    }
}

