/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.HttpRoute;
import org.wso2.transport.http.netty.common.ProxyServerConfiguration;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.common.ssl.SSLHandlerFactory;
import org.wso2.transport.http.netty.config.SenderConfiguration;
import org.wso2.transport.http.netty.listener.HTTPTraceLoggingHandler;
import org.wso2.transport.http.netty.sender.CertificateValidationHandler;
import org.wso2.transport.http.netty.sender.ConnectionAvailabilityFuture;
import org.wso2.transport.http.netty.sender.OCSPStaplingHandler;
import org.wso2.transport.http.netty.sender.RedirectHandler;
import org.wso2.transport.http.netty.sender.SslHandshakeCompletionHandlerForClient;
import org.wso2.transport.http.netty.sender.TargetHandler;
import org.wso2.transport.http.netty.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.sender.http2.ClientInboundHandler;
import org.wso2.transport.http.netty.sender.http2.ClientOutboundHandler;
import org.wso2.transport.http.netty.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.sender.http2.Http2ConnectionManager;

public class HttpClientChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(HttpClientChannelInitializer.class);
    private TargetHandler targetHandler;
    private boolean httpTraceLogEnabled;
    private boolean followRedirect;
    private boolean validateCertEnabled;
    private int maxRedirectCount;
    private int cacheSize;
    private int cacheDelay;
    private boolean isKeepAlive;
    private ProxyServerConfiguration proxyServerConfiguration;
    private ConnectionManager connectionManager;
    private Http2ConnectionManager http2ConnectionManager;
    private boolean http2 = false;
    private Http2ConnectionHandler http2ConnectionHandler;
    private ClientInboundHandler clientInboundHandler;
    private ClientOutboundHandler clientOutboundHandler;
    private Http2Connection connection;
    private SSLConfig sslConfig;
    private HttpRoute httpRoute;
    private SenderConfiguration senderConfiguration;
    private ConnectionAvailabilityFuture connectionAvailabilityFuture;
    private static final Http2FrameLogger logger = new Http2FrameLogger(LogLevel.DEBUG, HttpClientChannelInitializer.class);

    public HttpClientChannelInitializer(SenderConfiguration senderConfiguration, HttpRoute httpRoute, ConnectionManager connectionManager, ConnectionAvailabilityFuture connectionAvailabilityFuture) {
        this.httpTraceLogEnabled = senderConfiguration.isHttpTraceLogEnabled();
        this.followRedirect = senderConfiguration.isFollowRedirect();
        this.maxRedirectCount = senderConfiguration.getMaxRedirectCount(5);
        this.isKeepAlive = senderConfiguration.isKeepAlive();
        this.proxyServerConfiguration = senderConfiguration.getProxyServerConfiguration();
        this.connectionManager = connectionManager;
        this.http2ConnectionManager = connectionManager.getHttp2ConnectionManager();
        this.validateCertEnabled = senderConfiguration.validateCertEnabled();
        this.cacheDelay = senderConfiguration.getCacheValidityPeriod();
        this.cacheSize = senderConfiguration.getCacheSize();
        this.senderConfiguration = senderConfiguration;
        this.httpRoute = httpRoute;
        this.sslConfig = senderConfiguration.getSSLConfig();
        this.connectionAvailabilityFuture = connectionAvailabilityFuture;
        String httpVersion = senderConfiguration.getHttpVersion();
        if (Float.valueOf(httpVersion).floatValue() == 2.0f) {
            this.http2 = true;
        }
        this.connection = new DefaultHttp2Connection(false);
        this.clientInboundHandler = new ClientInboundHandler();
        DelegatingDecompressorFrameListener frameListener = new DelegatingDecompressorFrameListener(this.connection, (Http2FrameListener)this.clientInboundHandler);
        this.http2ConnectionHandler = new Http2ConnectionHandlerBuilder().connection(this.connection).frameLogger(logger).frameListener((Http2FrameListener)frameListener).build();
        this.clientOutboundHandler = new ClientOutboundHandler(this.connection, this.http2ConnectionHandler.encoder());
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        ChannelPipeline clientPipeline = socketChannel.pipeline();
        this.configureProxyServer(clientPipeline);
        HttpClientCodec sourceCodec = new HttpClientCodec();
        this.targetHandler = new TargetHandler();
        this.targetHandler.setHttp2ClientOutboundHandler(this.clientOutboundHandler);
        this.targetHandler.setKeepAlive(this.isKeepAlive);
        if (this.http2) {
            SSLConfig sslConfig = this.senderConfiguration.getSSLConfig();
            if (sslConfig != null) {
                this.configureSslForHttp2(socketChannel, clientPipeline, sslConfig);
            } else if (this.senderConfiguration.isForceHttp2()) {
                this.configureHttp2Pipeline(clientPipeline);
            } else {
                this.configureHttp2UpgradePipeline(clientPipeline, sourceCodec, this.targetHandler);
            }
        } else if (this.sslConfig != null) {
            this.configureSslForHttp(clientPipeline, this.targetHandler, socketChannel);
        } else {
            this.configureHttpPipeline(clientPipeline, this.targetHandler);
        }
    }

    private void configureProxyServer(ChannelPipeline clientPipeline) {
        if (this.proxyServerConfiguration != null) {
            if (this.proxyServerConfiguration.getProxyUsername() != null && this.proxyServerConfiguration.getProxyPassword() != null) {
                clientPipeline.addLast("proxyServerHandler", (ChannelHandler)new HttpProxyHandler((SocketAddress)this.proxyServerConfiguration.getInetSocketAddress(), this.proxyServerConfiguration.getProxyUsername(), this.proxyServerConfiguration.getProxyPassword()));
            } else {
                clientPipeline.addLast("proxyServerHandler", (ChannelHandler)new HttpProxyHandler((SocketAddress)this.proxyServerConfiguration.getInetSocketAddress()));
            }
        }
    }

    private void configureSslForHttp(ChannelPipeline clientPipeline, TargetHandler targetHandler, SocketChannel socketChannel) throws SSLException {
        log.debug("adding ssl handler");
        this.connectionAvailabilityFuture.setSSLEnabled(true);
        if (this.senderConfiguration.isOcspStaplingEnabled()) {
            SSLHandlerFactory sslHandlerFactory = new SSLHandlerFactory(this.sslConfig);
            ReferenceCountedOpenSslContext referenceCountedOpenSslContext = sslHandlerFactory.buildClientReferenceCountedOpenSslContext();
            if (referenceCountedOpenSslContext != null) {
                SslHandler sslHandler = referenceCountedOpenSslContext.newHandler(socketChannel.alloc());
                ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
                socketChannel.pipeline().addLast(new ChannelHandler[]{sslHandler});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new OCSPStaplingHandler(engine)});
            }
        } else {
            SSLEngine sslEngine = this.instantiateAndConfigSSL(this.sslConfig);
            clientPipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
            if (this.validateCertEnabled) {
                clientPipeline.addLast("certificateValidation", (ChannelHandler)new CertificateValidationHandler(sslEngine, this.cacheDelay, this.cacheSize));
            }
        }
        clientPipeline.addLast("sslHandshakeCompletionHandler", (ChannelHandler)new SslHandshakeCompletionHandlerForClient(this.connectionAvailabilityFuture, this, targetHandler));
    }

    private void configureSslForHttp2(SocketChannel ch, ChannelPipeline clientPipeline, SSLConfig sslConfig) throws SSLException {
        this.connectionAvailabilityFuture.setSSLEnabled(true);
        if (this.senderConfiguration.isOcspStaplingEnabled()) {
            ReferenceCountedOpenSslContext referenceCountedOpenSslContext = (ReferenceCountedOpenSslContext)new SSLHandlerFactory(sslConfig).createHttp2TLSContextForClient(this.senderConfiguration.isOcspStaplingEnabled());
            if (referenceCountedOpenSslContext != null) {
                SslHandler sslHandler = referenceCountedOpenSslContext.newHandler(ch.alloc());
                ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
                ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                ch.pipeline().addLast(new ChannelHandler[]{new OCSPStaplingHandler(engine)});
            }
        } else {
            SslContext sslCtx = new SSLHandlerFactory(sslConfig).createHttp2TLSContextForClient(false);
            SslHandler sslHandler = sslCtx.newHandler(ch.alloc());
            clientPipeline.addLast(new ChannelHandler[]{sslHandler});
            if (this.validateCertEnabled) {
                clientPipeline.addLast("certificateValidation", (ChannelHandler)new CertificateValidationHandler(sslHandler.engine(), this.cacheDelay, this.cacheSize));
            }
        }
        clientPipeline.addLast(new ChannelHandler[]{new Http2PipelineConfiguratorForClient(this.targetHandler, this.connectionAvailabilityFuture)});
    }

    public TargetHandler getTargetHandler() {
        return this.targetHandler;
    }

    public Http2ConnectionManager getHttp2ConnectionManager() {
        return this.http2ConnectionManager;
    }

    private void configureHttp2UpgradePipeline(ChannelPipeline pipeline, HttpClientCodec sourceCodec, TargetHandler targetHandler) {
        pipeline.addLast(new ChannelHandler[]{sourceCodec});
        this.addCommonHandlers(pipeline);
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec(this.http2ConnectionHandler);
        HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, Integer.MAX_VALUE);
        pipeline.addLast("Http2UpgradeHandler", (ChannelHandler)upgradeHandler);
        pipeline.addLast("targetHandler", (ChannelHandler)targetHandler);
    }

    private void configureHttp2Pipeline(ChannelPipeline pipeline) {
        pipeline.addLast("connectionHandler", (ChannelHandler)this.http2ConnectionHandler);
        pipeline.addLast("outboundHandler", (ChannelHandler)this.clientOutboundHandler);
        this.addCommonHandlers(pipeline);
    }

    public void configureHttpPipeline(ChannelPipeline pipeline, TargetHandler targetHandler) {
        pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec());
        this.addCommonHandlers(pipeline);
        pipeline.addLast("targetHandler", (ChannelHandler)targetHandler);
    }

    private void addCommonHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("deCompressor", (ChannelHandler)new HttpContentDecompressor());
        if (this.httpTraceLogEnabled) {
            pipeline.addLast("http-trace-logger", (ChannelHandler)new HTTPTraceLoggingHandler("tracelog.http.upstream"));
        }
        if (this.followRedirect) {
            if (log.isDebugEnabled()) {
                log.debug("Follow Redirect is enabled, so adding the redirect handler to the pipeline.");
            }
            RedirectHandler redirectHandler = new RedirectHandler(this.instantiateAndConfigSSL(this.sslConfig), this.httpTraceLogEnabled, this.maxRedirectCount, this.connectionManager);
            pipeline.addLast("redirectHandler", (ChannelHandler)redirectHandler);
        }
    }

    private SSLEngine instantiateAndConfigSSL(SSLConfig sslConfig) {
        SSLEngine sslEngine = null;
        if (sslConfig != null) {
            SSLHandlerFactory sslHandlerFactory = new SSLHandlerFactory(sslConfig);
            sslEngine = sslHandlerFactory.buildClientSSLEngine(this.httpRoute.getHost(), this.httpRoute.getPort());
            sslEngine.setUseClientMode(true);
            sslHandlerFactory.setSNIServerNames(sslEngine, this.httpRoute.getHost());
            if (this.senderConfiguration.hostNameVerificationEnabled()) {
                sslHandlerFactory.setHostNameVerfication(sslEngine);
            }
        }
        return sslEngine;
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public void setHttp2ClientChannel(Http2ClientChannel http2ClientChannel) {
        this.clientOutboundHandler.setHttp2ClientChannel(http2ClientChannel);
        this.clientInboundHandler.setHttp2ClientChannel(http2ClientChannel);
    }

    class Http2PipelineConfiguratorForClient
    extends ApplicationProtocolNegotiationHandler {
        private TargetHandler targetHandler;
        private ConnectionAvailabilityFuture connectionAvailabilityFuture;

        public Http2PipelineConfiguratorForClient(TargetHandler targetHandler, ConnectionAvailabilityFuture connectionAvailabilityFuture) {
            super("http/1.1");
            this.targetHandler = targetHandler;
            this.connectionAvailabilityFuture = connectionAvailabilityFuture;
        }

        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            if ("h2".equals(protocol)) {
                HttpClientChannelInitializer.this.configureHttp2Pipeline(ctx.pipeline());
                this.connectionAvailabilityFuture.notifySuccess("h2");
            } else if ("http/1.1".equals(protocol)) {
                HttpClientChannelInitializer.this.configureHttpPipeline(ctx.pipeline(), this.targetHandler);
                this.connectionAvailabilityFuture.notifySuccess("http");
            } else {
                throw new IllegalStateException("Unknown protocol: " + protocol);
            }
        }

        protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) {
            this.connectionAvailabilityFuture.notifyFailure(cause);
            ctx.close();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (ctx != null && ctx.channel().isActive()) {
                ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }
}

