/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.internal.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlSignal;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketMessageImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketBinaryMessageImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketControlMessageImpl;
import org.wso2.transport.http.netty.contractimpl.websocket.message.WebSocketTextMessageImpl;
import org.wso2.transport.http.netty.internal.websocket.WebSocketSessionImpl;

public class WebSocketUtil {
    public static String getSessionID(ChannelHandlerContext ctx) {
        return ctx.channel().id().asLongText();
    }

    public static WebSocketSessionImpl getSession(ChannelHandlerContext ctx, boolean isSecured, String uri) throws URISyntaxException {
        return new WebSocketSessionImpl(ctx, isSecured, uri, WebSocketUtil.getSessionID(ctx));
    }

    public static WebSocketControlMessage getWebsocketControlMessage(WebSocketFrame webSocketFrame, WebSocketControlSignal controlSignal) {
        ByteBuf content = webSocketFrame.content();
        ByteBuffer clonedContent = WebSocketUtil.getClonedByteBuf(content);
        WebSocketControlMessageImpl webSocketControlMessage = new WebSocketControlMessageImpl(controlSignal, clonedContent);
        webSocketFrame.release();
        return webSocketControlMessage;
    }

    public static WebSocketMessageImpl getWebSocketMessage(TextWebSocketFrame textWebSocketFrame) {
        String text = textWebSocketFrame.text();
        boolean isFinalFragment = textWebSocketFrame.isFinalFragment();
        WebSocketTextMessageImpl webSocketTextMessage = new WebSocketTextMessageImpl(text, isFinalFragment);
        textWebSocketFrame.release();
        return webSocketTextMessage;
    }

    public static WebSocketMessageImpl getWebSocketMessage(BinaryWebSocketFrame binaryWebSocketFrame) {
        ByteBuf content = binaryWebSocketFrame.content();
        ByteBuffer clonedContent = WebSocketUtil.getClonedByteBuf(content);
        boolean finalFragment = binaryWebSocketFrame.isFinalFragment();
        WebSocketBinaryMessageImpl webSocketBinaryMessage = new WebSocketBinaryMessageImpl(clonedContent, finalFragment);
        binaryWebSocketFrame.release();
        return webSocketBinaryMessage;
    }

    private static ByteBuffer getClonedByteBuf(ByteBuf buf) {
        ByteBuffer originalContent = buf.nioBuffer();
        ByteBuffer clonedContent = ByteBuffer.allocate(originalContent.capacity());
        originalContent.rewind();
        clonedContent.put(originalContent);
        originalContent.rewind();
        clonedContent.flip();
        return clonedContent;
    }
}

