/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.config.ChunkConfig;
import org.wso2.transport.http.netty.config.KeepAliveConfig;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.listener.RequestDataHolder;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.Http2PushPromise;

public class HttpOutboundRespListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(HttpOutboundRespListener.class);
    private ChannelHandlerContext sourceContext;
    private RequestDataHolder requestDataHolder;
    private HandlerExecutor handlerExecutor;
    private HTTPCarbonMessage inboundRequestMsg;
    private ChunkConfig chunkConfig;
    private KeepAliveConfig keepAliveConfig;
    private boolean headerWritten = false;
    private int contentLength = 0;
    private String serverName;
    private List<HttpContent> contentList = new ArrayList<HttpContent>();

    public HttpOutboundRespListener(ChannelHandlerContext channelHandlerContext, HTTPCarbonMessage requestMsg, ChunkConfig chunkConfig, KeepAliveConfig keepAliveConfig, String serverName) {
        this.sourceContext = channelHandlerContext;
        this.requestDataHolder = new RequestDataHolder(requestMsg);
        this.inboundRequestMsg = requestMsg;
        this.keepAliveConfig = keepAliveConfig;
        this.handlerExecutor = HTTPTransportContextHolder.getInstance().getHandlerExecutor();
        this.chunkConfig = chunkConfig;
        this.serverName = serverName;
    }

    @Override
    public void onMessage(HTTPCarbonMessage outboundResponseMsg) {
        this.sourceContext.channel().eventLoop().execute(() -> {
            if (this.handlerExecutor != null) {
                this.handlerExecutor.executeAtSourceResponseReceiving(outboundResponseMsg);
            }
            boolean keepAlive = this.isKeepAlive();
            outboundResponseMsg.getHttpContentAsync().setMessageListener(httpContent -> this.sourceContext.channel().eventLoop().execute(() -> {
                try {
                    this.writeOutboundResponse(outboundResponseMsg, keepAlive, httpContent);
                }
                catch (Exception exception) {
                    String errorMsg = "Failed to send the outbound response : " + exception.getMessage().toLowerCase(Locale.ENGLISH);
                    log.error(errorMsg, (Throwable)exception);
                    this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(exception);
                }
            }));
        });
    }

    @Override
    public void onPushPromise(Http2PushPromise pushPromise) {
        this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(new UnsupportedOperationException("Sending a PUSH_PROMISE is not supported for HTTP/1.x connections"));
    }

    @Override
    public void onPushResponse(int promiseId, HTTPCarbonMessage httpMessage) {
        this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(new UnsupportedOperationException("Sending Server Push messages is not supported for HTTP/1.x connections"));
    }

    private void writeOutboundResponse(HTTPCarbonMessage outboundResponseMsg, boolean keepAlive, HttpContent httpContent) {
        ChunkConfig responseChunkConfig;
        ChunkConfig chunkConfig = responseChunkConfig = outboundResponseMsg.getProperty("chunking_config") != null ? (ChunkConfig)((Object)outboundResponseMsg.getProperty("chunking_config")) : null;
        if (responseChunkConfig != null) {
            this.setChunkConfig(responseChunkConfig);
        }
        if (Util.isLastHttpContent(httpContent)) {
            ChannelFuture outboundChannelFuture;
            if (!this.headerWritten) {
                if (this.chunkConfig == ChunkConfig.ALWAYS && (Util.isVersionCompatibleForChunking(this.requestDataHolder.getHttpVersion()) || Util.shouldEnforceChunkingforHttpOneZero(this.chunkConfig, this.requestDataHolder.getHttpVersion()))) {
                    Util.setupChunkedRequest(outboundResponseMsg);
                    this.writeOutboundResponseHeaders(outboundResponseMsg, keepAlive);
                    outboundChannelFuture = this.writeOutboundResponseBody(httpContent);
                } else {
                    this.contentLength += httpContent.content().readableBytes();
                    Util.setupContentLengthRequest(outboundResponseMsg, this.contentLength);
                    outboundChannelFuture = this.writeOutboundResponseHeaderAndBody(outboundResponseMsg, (LastHttpContent)httpContent, keepAlive);
                }
            } else {
                outboundChannelFuture = this.writeOutboundResponseBody(httpContent);
            }
            if (!keepAlive) {
                outboundChannelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            if (this.handlerExecutor != null) {
                this.handlerExecutor.executeAtSourceResponseSending(outboundResponseMsg);
            }
            this.resetState(outboundResponseMsg);
        } else if ((this.chunkConfig == ChunkConfig.ALWAYS || this.chunkConfig == ChunkConfig.AUTO) && (Util.isVersionCompatibleForChunking(this.requestDataHolder.getHttpVersion()) || Util.shouldEnforceChunkingforHttpOneZero(this.chunkConfig, this.requestDataHolder.getHttpVersion()))) {
            if (!this.headerWritten) {
                Util.setupChunkedRequest(outboundResponseMsg);
                this.writeOutboundResponseHeaders(outboundResponseMsg, keepAlive);
            }
            HttpResponseFuture outboundRespStatusFuture = this.inboundRequestMsg.getHttpOutboundRespStatusFuture();
            ChannelFuture outboundResponseChannelFuture = this.sourceContext.writeAndFlush((Object)httpContent);
            Util.addResponseWriteFailureListener(outboundRespStatusFuture, outboundResponseChannelFuture);
        } else {
            this.contentList.add(httpContent);
            this.contentLength += httpContent.content().readableBytes();
        }
    }

    private ChannelFuture writeOutboundResponseHeaderAndBody(HTTPCarbonMessage outboundResponseMsg, LastHttpContent lastHttpContent, boolean keepAlive) {
        HttpResponseFuture outboundRespStatusFuture = this.inboundRequestMsg.getHttpOutboundRespStatusFuture();
        CompositeByteBuf allContent = Unpooled.compositeBuffer();
        for (HttpContent cachedHttpContent : this.contentList) {
            allContent.addComponent(true, cachedHttpContent.content());
        }
        allContent.addComponent(true, lastHttpContent.content());
        HttpResponse fullOutboundResponse = Util.createFullHttpResponse(outboundResponseMsg, this.requestDataHolder.getHttpVersion(), this.serverName, keepAlive, (ByteBuf)allContent);
        this.headerWritten = true;
        ChannelFuture outboundChannelFuture = this.sourceContext.writeAndFlush((Object)fullOutboundResponse);
        Util.checkForResponseWriteStatus(this.inboundRequestMsg, outboundRespStatusFuture, outboundChannelFuture);
        return outboundChannelFuture;
    }

    private ChannelFuture writeOutboundResponseBody(HttpContent lastHttpContent) {
        HttpResponseFuture outboundRespStatusFuture = this.inboundRequestMsg.getHttpOutboundRespStatusFuture();
        ChannelFuture outboundChannelFuture = this.sourceContext.writeAndFlush((Object)lastHttpContent);
        Util.checkForResponseWriteStatus(this.inboundRequestMsg, outboundRespStatusFuture, outboundChannelFuture);
        return outboundChannelFuture;
    }

    private void resetState(HTTPCarbonMessage outboundResponseMsg) {
        outboundResponseMsg.removeHttpContentAsyncFuture();
        this.contentList.clear();
        this.contentLength = 0;
        this.headerWritten = false;
    }

    private boolean isKeepAlive() {
        if (this.keepAliveConfig == null || this.keepAliveConfig == KeepAliveConfig.AUTO) {
            String requestConnectionHeader = this.requestDataHolder.getConnectionHeaderValue();
            if (Float.valueOf(this.requestDataHolder.getHttpVersion()).floatValue() <= 1.0f) {
                return requestConnectionHeader != null && requestConnectionHeader.equalsIgnoreCase("keep-alive");
            }
            return requestConnectionHeader == null || !requestConnectionHeader.equalsIgnoreCase("close");
        }
        return this.keepAliveConfig == KeepAliveConfig.ALWAYS;
    }

    private void writeOutboundResponseHeaders(HTTPCarbonMessage outboundResponseMsg, boolean keepAlive) {
        HttpResponse response = Util.createHttpResponse(outboundResponseMsg, this.requestDataHolder.getHttpVersion(), this.serverName, keepAlive);
        this.headerWritten = true;
        this.sourceContext.write((Object)response);
    }

    @Override
    public void onError(Throwable throwable) {
        log.error("Couldn't send the outbound response", throwable);
    }

    public ChunkConfig getChunkConfig() {
        return this.chunkConfig;
    }

    public void setChunkConfig(ChunkConfig chunkConfig) {
        this.chunkConfig = chunkConfig;
    }
}

