/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.Http2PushPromise;

public class Http2OutboundRespListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(Http2OutboundRespListener.class);
    private HTTPCarbonMessage inboundRequestMsg;
    private ChannelHandlerContext ctx;
    private Http2ConnectionEncoder encoder;
    private int originalStreamId;
    private Http2Connection conn;
    private String serverName;
    private HttpResponseFuture outboundRespStatusFuture;

    public Http2OutboundRespListener(HTTPCarbonMessage inboundRequestMsg, ChannelHandlerContext ctx, Http2Connection conn, Http2ConnectionEncoder encoder, int streamId, String serverName) {
        this.inboundRequestMsg = inboundRequestMsg;
        this.ctx = ctx;
        this.conn = conn;
        this.encoder = encoder;
        this.originalStreamId = streamId;
        this.serverName = serverName;
        this.outboundRespStatusFuture = inboundRequestMsg.getHttpOutboundRespStatusFuture();
    }

    @Override
    public void onMessage(HTTPCarbonMessage outboundResponseMsg) {
        this.writeMessage(outboundResponseMsg, this.originalStreamId);
    }

    @Override
    public void onError(Throwable throwable) {
        log.error("Couldn't send the outbound response", throwable);
    }

    @Override
    public void onPushPromise(Http2PushPromise pushPromise) {
        this.ctx.channel().eventLoop().execute(() -> {
            try {
                int promisedStreamId = this.getNextStreamId();
                pushPromise.setPromisedStreamId(promisedStreamId);
                pushPromise.setStreamId(this.originalStreamId);
                HttpRequest httpRequest = pushPromise.getHttpRequest();
                httpRequest.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
                Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers((HttpMessage)httpRequest, (boolean)true);
                ChannelFuture channelFuture = this.encoder.writePushPromise(this.ctx, this.originalStreamId, promisedStreamId, http2Headers, 0, this.ctx.newPromise());
                this.encoder.flowController().writePendingBytes();
                this.ctx.flush();
                Util.checkForResponseWriteStatus(this.inboundRequestMsg, this.outboundRespStatusFuture, channelFuture);
            }
            catch (Exception ex) {
                String errorMsg = "Failed to send push promise : " + ex.getMessage().toLowerCase(Locale.ENGLISH);
                log.error(errorMsg, (Throwable)ex);
                this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(ex);
            }
        });
    }

    @Override
    public void onPushResponse(int promiseId, HTTPCarbonMessage outboundResponseMsg) {
        if (this.isValidStreamId(promiseId)) {
            this.writeMessage(outboundResponseMsg, promiseId);
        } else {
            this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(new ServerConnectorException("Promise is already rejected or stream is no longer valid"));
        }
    }

    private void writeMessage(HTTPCarbonMessage outboundResponseMsg, int streamId) {
        ResponseWriter writer = new ResponseWriter(streamId);
        this.ctx.channel().eventLoop().execute(() -> outboundResponseMsg.getHttpContentAsync().setMessageListener(httpContent -> this.ctx.channel().eventLoop().execute(() -> {
            try {
                writer.writeOutboundResponse(outboundResponseMsg, httpContent);
            }
            catch (Http2Exception ex) {
                String errorMsg = "Failed to send the outbound response : " + ex.getMessage().toLowerCase(Locale.ENGLISH);
                log.error(errorMsg, (Throwable)ex);
                this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(ex);
            }
        })));
    }

    private synchronized int getNextStreamId() {
        return this.conn.local().incrementAndGetNextStreamId();
    }

    private boolean isValidStreamId(int streamId) {
        return this.conn.stream(streamId) != null;
    }

    private class ResponseWriter {
        private boolean isHeaderWritten = false;
        private int streamId;

        public ResponseWriter(int streamId) {
            this.streamId = streamId;
        }

        private void writeOutboundResponse(HTTPCarbonMessage outboundResponseMsg, HttpContent httpContent) throws Http2Exception {
            if (!this.isHeaderWritten) {
                this.writeHeaders(outboundResponseMsg);
            }
            if (Util.isLastHttpContent(httpContent)) {
                this.writeData(httpContent, true);
            } else {
                this.writeData(httpContent, false);
            }
        }

        private void writeHeaders(HTTPCarbonMessage outboundResponseMsg) throws Http2Exception {
            outboundResponseMsg.getHeaders().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
            HttpResponse httpMessage = Util.createHttpResponse(outboundResponseMsg, "2.0", Http2OutboundRespListener.this.serverName, true);
            Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers((HttpMessage)httpMessage, (boolean)true);
            this.isHeaderWritten = true;
            ChannelFuture channelFuture = Http2OutboundRespListener.this.encoder.writeHeaders(Http2OutboundRespListener.this.ctx, this.streamId, http2Headers, 0, false, Http2OutboundRespListener.this.ctx.newPromise());
            Http2OutboundRespListener.this.encoder.flowController().writePendingBytes();
            Http2OutboundRespListener.this.ctx.flush();
            Util.addResponseWriteFailureListener(Http2OutboundRespListener.this.outboundRespStatusFuture, channelFuture);
        }

        private void writeData(HttpContent httpContent, boolean endStream) throws Http2Exception {
            ChannelFuture channelFuture = Http2OutboundRespListener.this.encoder.writeData(Http2OutboundRespListener.this.ctx, this.streamId, httpContent.content().retain(), 0, endStream, Http2OutboundRespListener.this.ctx.newPromise());
            Http2OutboundRespListener.this.encoder.flowController().writePendingBytes();
            Http2OutboundRespListener.this.ctx.flush();
            if (endStream) {
                Util.checkForResponseWriteStatus(Http2OutboundRespListener.this.inboundRequestMsg, Http2OutboundRespListener.this.outboundRespStatusFuture, channelFuture);
            } else {
                Util.addResponseWriteFailureListener(Http2OutboundRespListener.this.outboundRespStatusFuture, channelFuture);
            }
        }
    }
}

