/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.common.ssl;

import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;

public class SSLHandlerFactory {
    private final SSLContext sslContext;
    private SSLConfig sslConfig;
    private boolean needClientAuth;
    private KeyManagerFactory kmf;
    private TrustManagerFactory tmf;

    public SSLHandlerFactory(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        this.needClientAuth = sslConfig.isNeedClientAuth();
        String protocol = sslConfig.getSSLProtocol();
        try {
            KeyManager[] keyManagers = null;
            if (sslConfig.getKeyStore() != null) {
                KeyStore ks = this.getKeyStore(sslConfig.getKeyStore(), sslConfig.getKeyStorePass());
                this.kmf = KeyManagerFactory.getInstance(algorithm);
                if (ks != null) {
                    this.kmf.init(ks, sslConfig.getCertPass() != null ? sslConfig.getCertPass().toCharArray() : sslConfig.getKeyStorePass().toCharArray());
                    keyManagers = this.kmf.getKeyManagers();
                }
            }
            TrustManager[] trustManagers = null;
            if (sslConfig.getTrustStore() != null) {
                KeyStore tks = this.getKeyStore(sslConfig.getTrustStore(), sslConfig.getTrustStorePass());
                this.tmf = TrustManagerFactory.getInstance(algorithm);
                this.tmf.init(tks);
                trustManagers = this.tmf.getTrustManagers();
            }
            this.sslContext = SSLContext.getInstance(protocol);
            this.sslContext.init(keyManagers, trustManagers, null);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException("Failed to initialize the SSLContext", e);
        }
    }

    private KeyStore getKeyStore(File keyStore, String keyStorePassword) throws IOException {
        KeyStore ks = null;
        String tlsStoreType = this.sslConfig.getTLSStoreType();
        if (keyStore != null && keyStorePassword != null) {
            try (FileInputStream is = new FileInputStream(keyStore);){
                ks = KeyStore.getInstance(tlsStoreType);
                ks.load(is, keyStorePassword.toCharArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        return ks;
    }

    public SSLEngine buildServerSSLEngine() {
        SSLEngine engine = this.sslContext.createSSLEngine();
        engine.setUseClientMode(false);
        engine.setNeedClientAuth(this.needClientAuth);
        return this.addCommonConfigs(engine);
    }

    public ReferenceCountedOpenSslContext getServerReferenceCountedOpenSslContext(boolean enableOcsp) throws SSLException {
        ReferenceCountedOpenSslContext context = (ReferenceCountedOpenSslContext)SslContextBuilder.forServer((KeyManagerFactory)this.kmf).sslProvider(SslProvider.OPENSSL).enableOcsp(true).keyManager(this.kmf).trustManager(this.tmf).protocols(this.sslConfig.getEnableProtocols()).enableOcsp(enableOcsp).clientAuth(this.needClientAuth ? ClientAuth.REQUIRE : ClientAuth.NONE).build();
        return context;
    }

    public SSLEngine buildClientSSLEngine(String host, int port) {
        SSLEngine engine = this.sslContext.createSSLEngine(host, port);
        engine.setUseClientMode(true);
        return this.addCommonConfigs(engine);
    }

    private SSLEngine addCommonConfigs(SSLEngine engine) {
        if (this.sslConfig.getCipherSuites() != null && this.sslConfig.getCipherSuites().length > 0) {
            engine.setEnabledCipherSuites(this.sslConfig.getCipherSuites());
        }
        if (this.sslConfig.getEnableProtocols() != null && this.sslConfig.getEnableProtocols().length > 0) {
            engine.setEnabledProtocols(this.sslConfig.getEnableProtocols());
        }
        engine.setEnableSessionCreation(this.sslConfig.isEnableSessionCreation());
        return engine;
    }

    public ReferenceCountedOpenSslContext buildClientReferenceCountedOpenSslContext() throws SSLException {
        ReferenceCountedOpenSslContext context = (ReferenceCountedOpenSslContext)SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).enableOcsp(true).keyManager(this.kmf).trustManager(this.tmf).protocols(this.sslConfig.getEnableProtocols()).build();
        return context;
    }

    public SslContext createHttp2TLSContextForServer(boolean enableOcsp) throws SSLException {
        List<String> ciphers = this.sslConfig.getCipherSuites() != null && this.sslConfig.getCipherSuites().length > 0 ? Arrays.asList(this.sslConfig.getCipherSuites()) : Http2SecurityUtil.CIPHERS;
        SslProvider provider = SslProvider.OPENSSL;
        return SslContextBuilder.forServer((KeyManagerFactory)this.getKeyManagerFactory()).trustManager(this.getTrustStoreFactory()).sslProvider(provider).ciphers(ciphers, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).clientAuth(this.needClientAuth ? ClientAuth.REQUIRE : ClientAuth.NONE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).enableOcsp(enableOcsp).build();
    }

    public SslContext createHttp2TLSContextForClient(boolean enableOcsp) throws SSLException {
        SslProvider provider = SslProvider.OPENSSL;
        List<String> ciphers = this.sslConfig.getCipherSuites() != null && this.sslConfig.getCipherSuites().length > 0 ? Arrays.asList(this.sslConfig.getCipherSuites()) : Http2SecurityUtil.CIPHERS;
        return SslContextBuilder.forClient().sslProvider(provider).keyManager(this.kmf).trustManager(this.tmf).protocols(this.sslConfig.getEnableProtocols()).ciphers(ciphers, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).enableOcsp(enableOcsp).build();
    }

    private KeyManagerFactory getKeyManagerFactory() {
        return this.kmf;
    }

    private TrustManagerFactory getTrustStoreFactory() {
        return this.tmf;
    }

    public void setSNIServerNames(SSLEngine sslEngine, String peerHost) {
        SSLParameters sslParameters = new SSLParameters();
        ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>();
        serverNames.add(new SNIHostName(peerHost));
        sslParameters.setServerNames(serverNames);
        sslEngine.setSSLParameters(sslParameters);
    }

    public void setHostNameVerfication(SSLEngine sslEngine) {
        SSLParameters sslParams = sslEngine.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm("https");
        sslEngine.setSSLParameters(sslParams);
    }
}

