/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.websocket.CloseReason;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.internal.router.PatternPathRouter;
import org.wso2.msf4j.internal.websocket.CloseCodeImpl;
import org.wso2.msf4j.internal.websocket.EndpointDispatcher;
import org.wso2.msf4j.internal.websocket.EndpointsRegistryImpl;
import org.wso2.msf4j.internal.websocket.WebSocketPongMessage;
import org.wso2.msf4j.websocket.exception.WebSocketEndpointMethodReturnTypeException;
import org.wso2.transport.http.netty.contract.websocket.HandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.HandshakeListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketInitMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;

@Component(name="org.wso2.msf4j.internal.MSF4JWSConnectorListener", immediate=true, service={WebSocketConnectorListener.class})
public class MSF4JWSConnectorListener
implements WebSocketConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(MSF4JWSConnectorListener.class);

    public void onMessage(final WebSocketInitMessage webSocketInitMessage) {
        HandshakeFuture handshakeFuture = webSocketInitMessage.handshake();
        handshakeFuture.setHandshakeListener(new HandshakeListener(){

            public void onSuccess(Session session) {
                MSF4JWSConnectorListener.this.handleWebSocketHandshake(webSocketInitMessage, session);
            }

            public void onError(Throwable throwable) {
                log.error("Unexpected error occur while handshake.", throwable);
            }
        });
    }

    public void onMessage(WebSocketTextMessage webSocketTextMessage) {
        EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
        String uri = webSocketTextMessage.getTarget();
        PatternPathRouter.RoutableDestination<Object> routableEndpoint = endpointsRegistry.getRoutableEndpoint(uri);
        this.handleTextWebSocketMessage(webSocketTextMessage, routableEndpoint, webSocketTextMessage.getChannelSession());
    }

    public void onMessage(WebSocketBinaryMessage webSocketBinaryMessage) {
        EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
        String uri = webSocketBinaryMessage.getTarget();
        PatternPathRouter.RoutableDestination<Object> routableEndpoint = endpointsRegistry.getRoutableEndpoint(uri);
        this.handleBinaryWebSocketMessage(webSocketBinaryMessage, routableEndpoint, webSocketBinaryMessage.getChannelSession());
    }

    public void onMessage(WebSocketControlMessage webSocketControlMessage) {
        EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
        String uri = webSocketControlMessage.getTarget();
        PatternPathRouter.RoutableDestination<Object> routableEndpoint = endpointsRegistry.getRoutableEndpoint(uri);
        this.handleControlCarbonMessage(webSocketControlMessage, routableEndpoint, webSocketControlMessage.getChannelSession());
    }

    public void onMessage(WebSocketCloseMessage webSocketCloseMessage) {
        EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
        String uri = webSocketCloseMessage.getTarget();
        PatternPathRouter.RoutableDestination<Object> routableEndpoint = endpointsRegistry.getRoutableEndpoint(uri);
        this.handleCloseWebSocketMessage(webSocketCloseMessage, routableEndpoint, webSocketCloseMessage.getChannelSession());
    }

    public void onError(Throwable throwable) {
        log.error("Unexpected error occur.", throwable);
    }

    public void onIdleTimeout(WebSocketControlMessage webSocketControlMessage) {
    }

    private boolean handleWebSocketHandshake(WebSocketInitMessage carbonMessage, Session session) {
        String requestUri;
        EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
        PatternPathRouter.RoutableDestination<Object> routableEndpoint = endpointsRegistry.getRoutableEndpoint(requestUri = carbonMessage.getTarget());
        if (routableEndpoint == null) {
            throw new RuntimeException("Error while connecting to server. Routable endpoint is not registered for the request uri:" + requestUri);
        }
        Optional<Method> methodOptional = new EndpointDispatcher().getOnOpenMethod(routableEndpoint.getDestination());
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        try {
            LinkedList parameterList = new LinkedList();
            methodOptional.ifPresent(method -> {
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == Session.class) {
                        parameterList.add(session);
                    } else if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam != null) {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, routableEndpoint.getDestination(), parameterList, session);
            });
            return true;
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, session);
            return false;
        }
    }

    private void handleTextWebSocketMessage(WebSocketTextMessage textCarbonMessage, PatternPathRouter.RoutableDestination<Object> routableEndpoint, Session session) {
        if (routableEndpoint == null) {
            throw new RuntimeException("Error while handling the message. Routable endpoint is not registered for the request uri:" + textCarbonMessage.getTarget());
        }
        Object endpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnStringMessageMethod(endpoint);
        try {
            methodOptional.ifPresent(method -> {
                LinkedList<Object> parameterList = new LinkedList<Object>();
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam == null) {
                            parameterList.add(textCarbonMessage.getText());
                        } else {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else if (parameter.getType() == Session.class) {
                        parameterList.add(session);
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, endpoint, (List<Object>)parameterList, session);
            });
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, session);
        }
    }

    private void handleBinaryWebSocketMessage(WebSocketBinaryMessage binaryCarbonMessage, PatternPathRouter.RoutableDestination<Object> routableEndpoint, Session session) {
        if (routableEndpoint == null) {
            throw new RuntimeException("Error while handling the message. Routable endpoint is not registered for the request uri:" + binaryCarbonMessage.getTarget());
        }
        Object webSocketEndpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnBinaryMessageMethod(webSocketEndpoint);
        try {
            methodOptional.ifPresent(method -> {
                LinkedList<Object> parameterList = new LinkedList<Object>();
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == ByteBuffer.class) {
                        parameterList.add(binaryCarbonMessage.getByteBuffer());
                    } else if (parameter.getType() == byte[].class) {
                        ByteBuffer buffer = binaryCarbonMessage.getByteBuffer();
                        byte[] bytes = new byte[buffer.capacity()];
                        for (int i = 0; i < buffer.capacity(); ++i) {
                            bytes[i] = buffer.get();
                        }
                        parameterList.add(bytes);
                    } else if (parameter.getType() == Boolean.TYPE) {
                        parameterList.add(binaryCarbonMessage.isFinalFragment());
                    } else if (parameter.getType() == Session.class) {
                        parameterList.add(session);
                    } else if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam != null) {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, webSocketEndpoint, (List<Object>)parameterList, session);
            });
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, session);
        }
    }

    private void handleCloseWebSocketMessage(WebSocketCloseMessage closeCarbonMessage, PatternPathRouter.RoutableDestination<Object> routableEndpoint, Session session) {
        if (routableEndpoint == null) {
            throw new RuntimeException("Error while handling the message. Routable endpoint is not registered for the request uri:" + closeCarbonMessage.getTarget());
        }
        Object webSocketEndpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnCloseMethod(webSocketEndpoint);
        try {
            methodOptional.ifPresent(method -> {
                LinkedList<Object> parameterList = new LinkedList<Object>();
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == CloseReason.class) {
                        CloseCodeImpl closeCode = new CloseCodeImpl(closeCarbonMessage.getCloseCode());
                        CloseReason closeReason = new CloseReason((CloseReason.CloseCode)closeCode, closeCarbonMessage.getCloseReason());
                        parameterList.add(closeReason);
                    } else if (parameter.getType() == Session.class) {
                        parameterList.add(session);
                    } else if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam != null) {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, webSocketEndpoint, (List<Object>)parameterList, session);
            });
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, session);
        }
    }

    private void handleControlCarbonMessage(WebSocketControlMessage controlCarbonMessage, PatternPathRouter.RoutableDestination<Object> routableEndpoint, Session session) {
        if (routableEndpoint == null) {
            throw new RuntimeException("Error while handling the message. Routable endpoint is not registered for the request uri:" + controlCarbonMessage.getTarget());
        }
        Object webSocketEndpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnPongMessageMethod(webSocketEndpoint);
        try {
            methodOptional.ifPresent(method -> {
                LinkedList<Object> parameterList = new LinkedList<Object>();
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == PongMessage.class) {
                        parameterList.add(new WebSocketPongMessage(controlCarbonMessage.getPayload()));
                    } else if (parameter.getType() == Session.class) {
                        parameterList.add(session);
                    } else if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam != null) {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, webSocketEndpoint, (List<Object>)parameterList, session);
            });
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, session);
        }
    }

    private void handleError(Throwable throwable, PatternPathRouter.RoutableDestination<Object> routableEndpoint, Session session) {
        Object webSocketEndpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnErrorMethod(webSocketEndpoint);
        methodOptional.ifPresent(method -> {
            LinkedList<Object> parameterList = new LinkedList<Object>();
            Arrays.stream(method.getParameters()).forEach(parameter -> {
                if (parameter.getType() == Throwable.class) {
                    parameterList.add(throwable);
                } else if (parameter.getType() == Session.class) {
                    parameterList.add(session);
                } else if (parameter.getType() == String.class) {
                    PathParam pathParam = parameter.getAnnotation(PathParam.class);
                    if (pathParam != null) {
                        parameterList.add(paramValues.get(pathParam.value()));
                    }
                } else {
                    parameterList.add(null);
                }
            });
            this.executeMethod((Method)method, webSocketEndpoint, (List<Object>)parameterList, session);
        });
    }

    private void executeMethod(Method method, Object webSocketEndpoint, List<Object> parameterList, Session session) {
        block10: {
            try {
                if (method.getReturnType() == String.class) {
                    String returnStr = (String)method.invoke(webSocketEndpoint, parameterList.toArray());
                    session.getBasicRemote().sendText(returnStr);
                    break block10;
                }
                if (method.getReturnType() == ByteBuffer.class) {
                    ByteBuffer buffer = (ByteBuffer)method.invoke(webSocketEndpoint, parameterList.toArray());
                    session.getBasicRemote().sendBinary(buffer);
                    break block10;
                }
                if (method.getReturnType() == byte[].class) {
                    byte[] bytes = (byte[])method.invoke(webSocketEndpoint, parameterList.toArray());
                    session.getBasicRemote().sendBinary(ByteBuffer.wrap(bytes));
                    break block10;
                }
                if (method.getReturnType() == Void.TYPE) {
                    method.invoke(webSocketEndpoint, parameterList.toArray());
                    break block10;
                }
                if (method.getReturnType() == PongMessage.class) {
                    PongMessage pongMessage = (PongMessage)method.invoke(webSocketEndpoint, parameterList.toArray());
                    session.getBasicRemote().sendPong(pongMessage.getApplicationData());
                    break block10;
                }
                throw new WebSocketEndpointMethodReturnTypeException("Unknown return type.");
            }
            catch (IllegalAccessException e) {
                log.error("Illegal access exception occurred: " + e.toString());
            }
            catch (InvocationTargetException e) {
                log.error("Method invocation failed: " + e.toString());
            }
            catch (IOException e) {
                log.error("IOException occurred: " + e.toString());
            }
            catch (WebSocketEndpointMethodReturnTypeException e) {
                log.error("WebSocket method return type exception occurred: " + e.toString());
            }
        }
    }
}

