/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.websocket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.HandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contractimpl.websocket.HandshakeFutureImpl;
import org.wso2.transport.http.netty.internal.websocket.WebSocketSessionImpl;
import org.wso2.transport.http.netty.sender.websocket.WebSocketTargetHandler;

public class WebSocketClient {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClient.class);
    private WebSocketTargetHandler handler;
    private EventLoopGroup group;
    private final String url;
    private final String subProtocols;
    private final String target;
    private final int idleTimeout;
    private final Map<String, String> headers;
    private final WebSocketConnectorListener connectorListener;

    public WebSocketClient(String url, String target, String subProtocols, int idleTimeout, Map<String, String> headers, WebSocketConnectorListener connectorListener) {
        this.url = url;
        this.target = target;
        this.subProtocols = subProtocols;
        this.idleTimeout = idleTimeout;
        this.headers = headers;
        this.connectorListener = connectorListener;
    }

    public HandshakeFuture handshake() {
        final HandshakeFutureImpl handshakeFuture = new HandshakeFutureImpl();
        try {
            String host;
            URI uri = new URI(this.url);
            String scheme = uri.getScheme() == null ? "ws" : uri.getScheme();
            String string = host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
            final int port = uri.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : ("wss".equalsIgnoreCase(scheme) ? 443 : -1)) : uri.getPort();
            if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
                log.error("Only WS(S) is supported.");
                throw new SSLException("");
            }
            boolean ssl = "wss".equalsIgnoreCase(scheme);
            final SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
            this.group = new NioEventLoopGroup();
            DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
            if (this.headers != null) {
                this.headers.entrySet().forEach(arg_0 -> WebSocketClient.lambda$handshake$24((HttpHeaders)httpHeaders, arg_0));
            }
            final WebSocketClientHandshaker websocketHandshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, (String)this.subProtocols, (boolean)true, (HttpHeaders)httpHeaders);
            this.handler = new WebSocketTargetHandler(websocketHandshaker, ssl, this.url, this.target, this.connectorListener);
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (sslCtx != null) {
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                    }
                    p.addLast(new ChannelHandler[]{new HttpClientCodec()});
                    p.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
                    p.addLast(new ChannelHandler[]{WebSocketClientCompressionHandler.INSTANCE});
                    if (WebSocketClient.this.idleTimeout > 0) {
                        p.addLast(new ChannelHandler[]{new IdleStateHandler((long)WebSocketClient.this.idleTimeout, (long)WebSocketClient.this.idleTimeout, (long)WebSocketClient.this.idleTimeout, TimeUnit.MILLISECONDS)});
                    }
                    p.addLast(new ChannelHandler[]{WebSocketClient.this.handler});
                }
            });
            b.connect(uri.getHost(), port).sync();
            ChannelFuture future = this.handler.handshakeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    Throwable cause = future.cause();
                    if (future.isSuccess() && cause == null) {
                        WebSocketSessionImpl session = (WebSocketSessionImpl)WebSocketClient.this.handler.getChannelSession();
                        String actualSubProtocol = websocketHandshaker.actualSubprotocol();
                        WebSocketClient.this.handler.setActualSubProtocol(actualSubProtocol);
                        session.setNegotiatedSubProtocol(actualSubProtocol);
                        session.setIsOpen(true);
                        handshakeFuture.notifySuccess(session);
                    } else {
                        handshakeFuture.notifyError(cause);
                    }
                }
            }).sync();
            handshakeFuture.setChannelFuture(future);
        }
        catch (Throwable t) {
            handshakeFuture.notifyError(t);
        }
        return handshakeFuture;
    }

    private static /* synthetic */ void lambda$handshake$24(HttpHeaders httpHeaders, Map.Entry entry) {
        httpHeaders.add((String)entry.getKey(), entry.getValue());
    }
}

