/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.transport.http.netty.config.ListenerConfiguration;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.sender.channel.pool.ConnectionManager;

public final class HTTP2SourceHandler
extends Http2ConnectionHandler
implements Http2FrameListener {
    private static final Logger log = LoggerFactory.getLogger(HTTP2SourceHandler.class);
    private Map<Integer, HTTPCarbonMessage> streamIdRequestMap = PlatformDependent.newConcurrentHashMap();
    private ConnectionManager connectionManager;
    private ListenerConfiguration listenerConfiguration;
    private ChannelHandlerContext ctx;

    HTTP2SourceHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, ConnectionManager connectionManager, ListenerConfiguration listenerConfiguration) {
        super(decoder, encoder, initialSettings);
        this.listenerConfiguration = listenerConfiguration;
        this.connectionManager = connectionManager;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText()).set((Object)new AsciiString((CharSequence)"http-to-http2-upgrade"), (Object)new AsciiString((CharSequence)"true"));
            this.encoder().writeHeaders(ctx, 1, headers, 0, true, ctx.newPromise());
        }
        super.userEventTriggered(ctx, evt);
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        HTTPCarbonMessage cMsg = this.streamIdRequestMap.get(streamId);
        if (cMsg != null) {
            cMsg.addHttpContent((HttpContent)new DefaultLastHttpContent(data.retain()));
            if (endOfStream) {
                cMsg.setEndOfMsgAdded(true);
            }
        }
        return data.readableBytes() + padding;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        HTTPCarbonMessage cMsg = this.publishToMessageProcessor(streamId, headers);
        if (endOfStream) {
            cMsg.setEndOfMsgAdded(true);
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.close();
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionTermination(Integer.toString(ctx.hashCode()));
        }
    }

    private HTTPCarbonMessage publishToMessageProcessor(int streamId, Http2Headers headers) {
        CarbonMessageProcessor carbonMessageProcessor;
        HTTPCarbonMessage cMsg = this.setupCarbonMessage(streamId, headers);
        boolean continueRequest = true;
        if (continueRequest && (carbonMessageProcessor = HTTPTransportContextHolder.getInstance().getMessageProcessor(this.listenerConfiguration.getMessageProcessorId())) == null) {
            log.error("Cannot find registered MessageProcessor for forward the message");
        }
        return cMsg;
    }

    protected HTTPCarbonMessage setupCarbonMessage(int streamId, Http2Headers headers) {
        HTTPCarbonMessage cMsg = new HTTPCarbonMessage((HttpMessage)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, ""));
        cMsg.setProperty("PORT", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getPort());
        cMsg.setProperty("Host", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getHostName());
        cMsg.setProperty("scheme", this.listenerConfiguration.getScheme());
        cMsg.setProperty("HTTP_VERSION", "HTTP/2.0");
        cMsg.setProperty("LISTENER_PORT", ((InetSocketAddress)this.ctx.channel().localAddress()).getPort());
        cMsg.setProperty("LISTENER_INTERFACE_ID", this.listenerConfiguration.getId());
        cMsg.setProperty("PROTOCOL", "http");
        if (this.listenerConfiguration.getSslConfig() != null) {
            cMsg.setProperty("IS_SECURED_CONNECTION", true);
        } else {
            cMsg.setProperty("IS_SECURED_CONNECTION", false);
        }
        cMsg.setProperty("LOCAL_ADDRESS", this.ctx.channel().localAddress());
        cMsg.setProperty("LOCAL_NAME", ((InetSocketAddress)this.ctx.channel().localAddress()).getHostName());
        cMsg.setProperty("REMOTE_ADDRESS", this.ctx.channel().remoteAddress());
        cMsg.setProperty("REMOTE_HOST", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getHostName());
        cMsg.setProperty("REMOTE_PORT", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getPort());
        ChannelHandler handler = this.ctx.handler();
        cMsg.setProperty("CHANNEL_ID", ((HTTP2SourceHandler)handler).getListenerConfiguration().getId());
        cMsg.setProperty("STREAM_ID", streamId);
        if (headers.path() != null) {
            String path = ((CharSequence)headers.getAndRemove((Object)":path")).toString();
            cMsg.setProperty("TO", path);
            cMsg.setProperty("REQUEST_URL", path);
        }
        if (headers.method() != null) {
            String method = ((CharSequence)headers.getAndRemove((Object)":method")).toString();
            cMsg.setProperty("HTTP_METHOD", method);
        }
        headers.getAndRemove((Object)":authority");
        headers.getAndRemove((Object)":scheme");
        headers.forEach(k -> cMsg.setHeader(((CharSequence)k.getKey()).toString(), ((CharSequence)k.getValue()).toString()));
        this.streamIdRequestMap.put(streamId, cMsg);
        return cMsg;
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) {
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
    }

    public void onPingRead(ChannelHandlerContext ctx, ByteBuf data) {
    }

    public void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) {
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
        if (log.isDebugEnabled() && errorCode != 0L && debugData.isReadable()) {
            int contentLength = debugData.readableBytes();
            byte[] arr = new byte[contentLength];
            debugData.readBytes(arr);
            log.debug("Error occurred while closing the client connection " + new String(arr, 0, contentLength, CharsetUtil.UTF_8));
        }
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
    }

    public ListenerConfiguration getListenerConfiguration() {
        return this.listenerConfiguration;
    }
}

