/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonTransportInitializer;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.common.ssl.SSLHandlerFactory;
import org.wso2.transport.http.netty.config.RequestSizeValidationConfiguration;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.listener.CustomHttpContentCompressor;
import org.wso2.transport.http.netty.listener.CustomHttpObjectAggregator;
import org.wso2.transport.http.netty.listener.CustomHttpRequestDecoder;
import org.wso2.transport.http.netty.listener.HTTPTraceLoggingHandler;
import org.wso2.transport.http.netty.listener.SourceHandler;
import org.wso2.transport.http.netty.listener.WebSocketServerHandshakeHandler;

public class HTTPServerChannelInitializer
extends ChannelInitializer<SocketChannel>
implements CarbonTransportInitializer {
    private static final Logger log = LoggerFactory.getLogger(HTTPServerChannelInitializer.class);
    private int socketIdleTimeout;
    private boolean httpTraceLogEnabled;
    private String interfaceId;
    private SSLConfig sslConfig;
    private ServerConnectorFuture serverConnectorFuture;
    private RequestSizeValidationConfiguration requestSizeValidationConfig;

    public void setup(Map<String, String> parameters) {
    }

    public void initChannel(SocketChannel ch) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Initializing source channel pipeline");
        }
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslConfig != null) {
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(new SSLHandlerFactory(this.sslConfig).build()));
        }
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        this.configureHTTPPipeline(pipeline);
        if (this.socketIdleTimeout > 0) {
            pipeline.addBefore("SourceHandler", "idleStateHandler", (ChannelHandler)new IdleStateHandler((long)this.socketIdleTimeout, (long)this.socketIdleTimeout, (long)this.socketIdleTimeout, TimeUnit.MILLISECONDS));
        }
    }

    public void configureHTTPPipeline(ChannelPipeline pipeline) {
        if (this.requestSizeValidationConfig != null && this.requestSizeValidationConfig.isHeaderSizeValidation()) {
            pipeline.addLast("decoder", (ChannelHandler)new CustomHttpRequestDecoder(this.requestSizeValidationConfig));
        } else {
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        }
        if (this.requestSizeValidationConfig != null && this.requestSizeValidationConfig.isRequestSizeValidation()) {
            pipeline.addLast("custom-aggregator", (ChannelHandler)new CustomHttpObjectAggregator(this.requestSizeValidationConfig));
        }
        pipeline.addLast("compressor", (ChannelHandler)new CustomHttpContentCompressor());
        pipeline.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        if (this.httpTraceLogEnabled) {
            pipeline.addLast("http-trace-logger", (ChannelHandler)new HTTPTraceLoggingHandler("tracelog.http.downstream"));
        }
        pipeline.addLast("websocket-server-handshake-handler", (ChannelHandler)new WebSocketServerHandshakeHandler(this.serverConnectorFuture, this.interfaceId));
        try {
            pipeline.addLast("SourceHandler", (ChannelHandler)new SourceHandler(this.serverConnectorFuture, this.interfaceId));
        }
        catch (Exception e) {
            log.error("Cannot Create SourceHandler ", (Throwable)e);
        }
    }

    public boolean isServerInitializer() {
        return true;
    }

    public void setServerConnectorFuture(ServerConnectorFuture serverConnectorFuture) {
        this.serverConnectorFuture = serverConnectorFuture;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.socketIdleTimeout = idleTimeout;
    }

    public void setHttpTraceLogEnabled(boolean httpTraceLogEnabled) {
        this.httpTraceLogEnabled = httpTraceLogEnabled;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }

    public void setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
    }

    public void setSslConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public void setRequestSizeValidationConfig(RequestSizeValidationConfiguration requestSizeValidationConfig) {
        this.requestSizeValidationConfig = requestSizeValidationConfig;
    }
}

