/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.beanconversion;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.wso2.msf4j.beanconversion.BeanConversionException;
import org.wso2.msf4j.beanconversion.MediaTypeConverter;

public class TextPlainConverter
extends MediaTypeConverter {
    @Override
    public String[] getSupportedMediaTypes() {
        return new String[0];
    }

    @Override
    public ByteBuffer toMedia(Object object) {
        return ByteBuffer.wrap(object.toString().getBytes(Charset.defaultCharset()));
    }

    @Override
    public Object toObject(ByteBuffer content, Type targetType) {
        return Charset.defaultCharset().decode(content).toString();
    }

    @Override
    protected Object toObject(InputStream inputStream, Type targetType) throws BeanConversionException {
        try {
            return IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new BeanConversionException("Unable to perform string conversion", e);
        }
    }
}

