/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.net.SocketAddress;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.ProxyServerConfiguration;
import org.wso2.transport.http.netty.config.SenderConfiguration;
import org.wso2.transport.http.netty.listener.CustomHttpContentCompressor;
import org.wso2.transport.http.netty.listener.HTTPTraceLoggingHandler;
import org.wso2.transport.http.netty.sender.RedirectHandler;
import org.wso2.transport.http.netty.sender.TargetHandler;

public class HTTPClientInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(HTTPClientInitializer.class);
    private SSLEngine sslEngine;
    private TargetHandler handler;
    private boolean httpTraceLogEnabled;
    private boolean followRedirect;
    private int maxRedirectCount;
    private boolean chunkDisabled;
    private boolean isKeepAlive;
    private ProxyServerConfiguration proxyServerConfiguration;

    public HTTPClientInitializer(SenderConfiguration senderConfiguration, SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
        this.httpTraceLogEnabled = senderConfiguration.isHttpTraceLogEnabled();
        this.followRedirect = senderConfiguration.isFollowRedirect();
        this.maxRedirectCount = senderConfiguration.getMaxRedirectCount(5);
        this.chunkDisabled = senderConfiguration.isChunkDisabled();
        this.isKeepAlive = senderConfiguration.isKeepAlive();
        this.proxyServerConfiguration = senderConfiguration.getProxyServerConfiguration();
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.proxyServerConfiguration != null) {
            if (this.proxyServerConfiguration.getProxyUsername() != null && this.proxyServerConfiguration.getProxyPassword() != null) {
                ch.pipeline().addLast("proxyServer", (ChannelHandler)new HttpProxyHandler((SocketAddress)this.proxyServerConfiguration.getInetSocketAddress(), this.proxyServerConfiguration.getProxyUsername(), this.proxyServerConfiguration.getProxyPassword()));
            } else {
                ch.pipeline().addLast("proxyServer", (ChannelHandler)new HttpProxyHandler((SocketAddress)this.proxyServerConfiguration.getInetSocketAddress()));
            }
        }
        if (this.sslEngine != null) {
            log.debug("adding ssl handler");
            ch.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(this.sslEngine));
        }
        ch.pipeline().addLast("compressor", (ChannelHandler)new CustomHttpContentCompressor(this.chunkDisabled));
        ch.pipeline().addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
        ch.pipeline().addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
        ch.pipeline().addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        if (this.httpTraceLogEnabled) {
            ch.pipeline().addLast("http-trace-logger", (ChannelHandler)new HTTPTraceLoggingHandler("tracelog.http.upstream"));
        }
        if (this.followRedirect) {
            if (log.isDebugEnabled()) {
                log.debug("Follow Redirect is enabled, so adding the redirect handler to the pipeline.");
            }
            RedirectHandler redirectHandler = new RedirectHandler(this.sslEngine, this.httpTraceLogEnabled, this.maxRedirectCount, this.chunkDisabled);
            ch.pipeline().addLast("redirectHandler", (ChannelHandler)redirectHandler);
        }
        this.handler = new TargetHandler();
        this.handler.setKeepAlive(this.isKeepAlive);
        ch.pipeline().addLast("targetHandler", (ChannelHandler)this.handler);
    }

    public TargetHandler getTargetHandler() {
        return this.handler;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }
}

