/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.HttpOutboundRespListener;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;

public class SourceHandler
extends ChannelInboundHandlerAdapter {
    private static Logger log = LoggerFactory.getLogger(SourceHandler.class);
    protected ChannelHandlerContext ctx;
    private HTTPCarbonMessage sourceReqCmsg;
    private Map<String, GenericObjectPool> targetChannelPool;
    private ServerConnectorFuture serverConnectorFuture;
    private String interfaceId;
    private HandlerExecutor handlerExecutor;

    public SourceHandler(ServerConnectorFuture serverConnectorFuture, String interfaceId) throws Exception {
        this.serverConnectorFuture = serverConnectorFuture;
        this.interfaceId = interfaceId;
        this.targetChannelPool = new ConcurrentHashMap<String, GenericObjectPool>();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.handlerExecutor = HTTPTransportContextHolder.getInstance().getHandlerExecutor();
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
        this.ctx = ctx;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpMessage) {
            FullHttpMessage fullHttpMessage = (FullHttpMessage)msg;
            this.sourceReqCmsg = this.setupCarbonMessage((HttpMessage)fullHttpMessage);
            this.notifyRequestListener(this.sourceReqCmsg, ctx);
            ByteBuf content = ((FullHttpMessage)msg).content();
            this.sourceReqCmsg.addHttpContent((HttpContent)new DefaultLastHttpContent(content));
            if (this.handlerExecutor != null) {
                this.handlerExecutor.executeAtSourceRequestSending(this.sourceReqCmsg);
            }
        } else if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            this.sourceReqCmsg = this.setupCarbonMessage((HttpMessage)httpRequest);
            this.notifyRequestListener(this.sourceReqCmsg, ctx);
        } else if (this.sourceReqCmsg != null && msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            this.sourceReqCmsg.addHttpContent(httpContent);
            if (Util.isLastHttpContent(httpContent) && this.handlerExecutor != null) {
                this.handlerExecutor.executeAtSourceRequestSending(this.sourceReqCmsg);
            }
        }
    }

    private void notifyRequestListener(HTTPCarbonMessage httpRequestMsg, ChannelHandlerContext ctx) throws URISyntaxException {
        boolean continueRequest;
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceRequestReceiving(httpRequestMsg);
        }
        if (continueRequest = true) {
            if (this.serverConnectorFuture != null) {
                try {
                    ServerConnectorFuture outboundRespFuture = httpRequestMsg.getHttpResponseFuture();
                    outboundRespFuture.setHttpConnectorListener(new HttpOutboundRespListener(ctx, httpRequestMsg));
                    this.serverConnectorFuture.notifyHttpListener(httpRequestMsg);
                }
                catch (Exception e) {
                    log.error("Error while notifying listeners", (Throwable)e);
                }
            } else {
                log.error("Cannot find registered listener to forward the message");
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.close();
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceConnectionTermination(Integer.toString(ctx.hashCode()));
            this.handlerExecutor = null;
        }
        this.targetChannelPool.forEach((k, genericObjectPool) -> {
            try {
                this.targetChannelPool.remove(k).close();
            }
            catch (Exception e) {
                log.error("Couldn't close target channel socket connections", (Throwable)e);
            }
        });
    }

    public Map<String, GenericObjectPool> getTargetChannelPool() {
        return this.targetChannelPool;
    }

    public ChannelHandlerContext getInboundChannelContext() {
        return this.ctx;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        this.serverConnectorFuture.notifyErrorListener(cause);
    }

    private HTTPCarbonMessage setupCarbonMessage(HttpMessage httpMessage) throws URISyntaxException {
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceRequestReceiving(this.sourceReqCmsg);
        }
        this.sourceReqCmsg = new HttpCarbonRequest((HttpRequest)httpMessage);
        HttpRequest httpRequest = (HttpRequest)httpMessage;
        this.sourceReqCmsg.setProperty("CHNL_HNDLR_CTX", this.ctx);
        this.sourceReqCmsg.setProperty("SRC_HANDLER", (Object)this);
        this.sourceReqCmsg.setProperty("HTTP_VERSION", httpRequest.getProtocolVersion().text());
        this.sourceReqCmsg.setProperty("HTTP_METHOD", httpRequest.getMethod().name());
        InetSocketAddress localAddress = (InetSocketAddress)this.ctx.channel().localAddress();
        this.sourceReqCmsg.setProperty("LISTENER_PORT", localAddress.getPort());
        this.sourceReqCmsg.setProperty("LISTENER_INTERFACE_ID", this.interfaceId);
        this.sourceReqCmsg.setProperty("PROTOCOL", "http");
        boolean isSecuredConnection = false;
        if (this.ctx.channel().pipeline().get("ssl") != null) {
            isSecuredConnection = true;
        }
        this.sourceReqCmsg.setProperty("IS_SECURED_CONNECTION", isSecuredConnection);
        this.sourceReqCmsg.setProperty("LOCAL_ADDRESS", this.ctx.channel().localAddress());
        this.sourceReqCmsg.setProperty("REQUEST_URL", httpRequest.getUri());
        this.sourceReqCmsg.setProperty("TO", httpRequest.getUri());
        return this.sourceReqCmsg;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.close();
        }
    }
}

