/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.concurrent.GenericFutureListener;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contractimpl.HttpResponseStatusFuture;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.listener.RequestDataHolder;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class HttpOutboundRespListener
implements HttpConnectorListener {
    private ChannelHandlerContext sourceContext;
    private RequestDataHolder requestDataHolder;
    private HandlerExecutor handlerExecutor;
    private HTTPCarbonMessage inboundRequestMsg;

    public HttpOutboundRespListener(ChannelHandlerContext channelHandlerContext, HTTPCarbonMessage requestMsg) {
        this.sourceContext = channelHandlerContext;
        this.requestDataHolder = new RequestDataHolder(requestMsg);
        this.handlerExecutor = HTTPTransportContextHolder.getInstance().getHandlerExecutor();
        this.inboundRequestMsg = requestMsg;
    }

    @Override
    public void onMessage(HTTPCarbonMessage httpResponseMessage) {
        this.sourceContext.channel().eventLoop().execute(() -> {
            boolean keepAlive = this.isKeepAlive(httpResponseMessage);
            if (this.handlerExecutor != null) {
                this.handlerExecutor.executeAtSourceResponseReceiving(httpResponseMessage);
            }
            Util.setupTransferEncodingAndContentTypeForResponse(httpResponseMessage, this.requestDataHolder);
            HttpResponse response = Util.createHttpResponse(httpResponseMessage, keepAlive);
            this.sourceContext.write((Object)response);
            httpResponseMessage.getHttpContentAsync().setMessageListener(httpContent -> this.sourceContext.channel().eventLoop().execute(() -> {
                if (Util.isLastHttpContent(httpContent)) {
                    ChannelFuture outboundChannelFuture = this.sourceContext.writeAndFlush((Object)httpContent);
                    HttpResponseStatusFuture outboundRespStatusFuture = this.inboundRequestMsg.getHttpOutboundRespStatusFuture();
                    outboundChannelFuture.addListener(genericFutureListener -> {
                        if (genericFutureListener.cause() != null) {
                            outboundRespStatusFuture.notifyHttpListener(genericFutureListener.cause());
                        } else {
                            outboundRespStatusFuture.notifyHttpListener(this.inboundRequestMsg);
                        }
                    });
                    if (!keepAlive) {
                        outboundChannelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                    if (this.handlerExecutor != null) {
                        this.handlerExecutor.executeAtSourceResponseSending(httpResponseMessage);
                    }
                } else {
                    this.sourceContext.write((Object)httpContent);
                }
            }));
        });
        Util.prepareBuiltMessageForTransfer(httpResponseMessage);
    }

    private boolean isKeepAlive(HTTPCarbonMessage responseMsg) {
        String responseConnectionHeader = responseMsg.getHeader("Connection");
        String requestConnectionHeader = this.requestDataHolder.getConnectionHeader();
        return (responseConnectionHeader == null || !"Close".equalsIgnoreCase(responseConnectionHeader)) && (requestConnectionHeader == null || !"Close".equalsIgnoreCase(requestConnectionHeader));
    }

    @Override
    public void onError(Throwable throwable) {
    }
}

