/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Constants;
import org.wso2.transport.http.netty.common.HttpRoute;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.config.SenderConfiguration;
import org.wso2.transport.http.netty.contract.ClientConnectorException;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.HttpResponseFutureImpl;
import org.wso2.transport.http.netty.listener.SourceHandler;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.sender.channel.pool.ConnectionManager;

public class HttpClientConnectorImpl
implements HttpClientConnector {
    private static final Logger log = LoggerFactory.getLogger(HttpClientConnector.class);
    private ConnectionManager connectionManager;
    private SenderConfiguration senderConfiguration;
    private SSLConfig sslConfig;
    private int socketIdleTimeout;
    private boolean followRedirect;
    private boolean chunkDisabled;
    private boolean keepAlive;

    public HttpClientConnectorImpl(ConnectionManager connectionManager, SenderConfiguration senderConfiguration) {
        this.connectionManager = connectionManager;
        this.senderConfiguration = senderConfiguration;
        this.initTargetChannelProperties(senderConfiguration);
    }

    @Override
    public HttpResponseFuture connect() {
        return null;
    }

    @Override
    public HttpResponseFuture send(final HTTPCarbonMessage httpCarbonRequest) {
        final HttpResponseFutureImpl httpResponseFuture = new HttpResponseFutureImpl();
        SourceHandler srcHandler = (SourceHandler)((Object)httpCarbonRequest.getProperty("SRC_HANDLER"));
        if (srcHandler == null && log.isDebugEnabled()) {
            log.debug("SRC_HANDLER property not found in the message. Message is not originated from the HTTP Server connector");
        }
        try {
            final HttpRoute route = this.getTargetRoute(httpCarbonRequest);
            final TargetChannel targetChannel = this.connectionManager.borrowTargetChannel(route, srcHandler, this.senderConfiguration);
            targetChannel.getChannelFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (this.isValidateChannel(channelFuture)) {
                        targetChannel.setChannel(channelFuture.channel());
                        targetChannel.configTargetHandler(httpCarbonRequest, httpResponseFuture);
                        targetChannel.setEndPointTimeout(HttpClientConnectorImpl.this.socketIdleTimeout, HttpClientConnectorImpl.this.followRedirect);
                        targetChannel.setCorrelationIdForLogging();
                        targetChannel.setChunkDisabled(HttpClientConnectorImpl.this.chunkDisabled);
                        if (HttpClientConnectorImpl.this.followRedirect) {
                            HttpClientConnectorImpl.this.setChannelAttributes(channelFuture.channel(), httpCarbonRequest, httpResponseFuture, targetChannel);
                        }
                        if (!HttpClientConnectorImpl.this.keepAlive) {
                            httpCarbonRequest.setHeader("Connection", "Close");
                        }
                        Util.setupTransferEncodingForRequest(httpCarbonRequest, HttpClientConnectorImpl.this.chunkDisabled);
                        targetChannel.setRequestWritten(true);
                        targetChannel.writeContent(httpCarbonRequest);
                    } else {
                        this.notifyErrorState(channelFuture);
                    }
                }

                private boolean isValidateChannel(ChannelFuture channelFuture) throws Exception {
                    if (channelFuture.isDone() && channelFuture.isSuccess()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Created the connection to address: {}", (Object)(route.toString() + " " + "Original Channel ID is : " + channelFuture.channel().id()));
                        }
                        return true;
                    }
                    return false;
                }

                private void notifyErrorState(ChannelFuture channelFuture) {
                    ClientConnectorException cause = channelFuture.isDone() && channelFuture.isCancelled() ? new ClientConnectorException("Request Cancelled, " + route.toString(), HttpResponseStatus.BAD_GATEWAY.code()) : (!channelFuture.isDone() && !channelFuture.isSuccess() && !channelFuture.isCancelled() && channelFuture.cause() == null ? new ClientConnectorException("Connection timeout, " + route.toString(), HttpResponseStatus.BAD_GATEWAY.code()) : new ClientConnectorException("Connection refused, " + route.toString(), HttpResponseStatus.BAD_GATEWAY.code()));
                    if (channelFuture.cause() != null) {
                        cause.initCause(channelFuture.cause());
                    }
                    httpResponseFuture.notifyHttpListener(cause);
                }
            });
            Util.prepareBuiltMessageForTransfer(httpCarbonRequest);
        }
        catch (Exception failedCause) {
            httpResponseFuture.notifyHttpListener(failedCause);
        }
        return httpResponseFuture;
    }

    @Override
    public boolean close() {
        return false;
    }

    private HttpRoute getTargetRoute(HTTPCarbonMessage httpCarbonMessage) {
        int port;
        String host;
        Object hostProperty = httpCarbonMessage.getProperty("Host");
        if (hostProperty != null && hostProperty instanceof String) {
            host = (String)hostProperty;
        } else {
            host = "localhost";
            httpCarbonMessage.setProperty("Host", "localhost");
            log.debug("Cannot find property HOST of type string, hence using localhost as the host");
        }
        Object intProperty = httpCarbonMessage.getProperty("PORT");
        if (intProperty != null && intProperty instanceof Integer) {
            port = (Integer)intProperty;
        } else {
            port = this.sslConfig != null ? 443 : 80;
            httpCarbonMessage.setProperty("PORT", port);
            log.debug("Cannot find property PORT of type integer, hence using " + port);
        }
        return new HttpRoute(host, port);
    }

    private void setChannelAttributes(Channel channel, HTTPCarbonMessage httpCarbonRequest, HttpResponseFuture httpResponseFuture, TargetChannel targetChannel) {
        channel.attr(Constants.ORIGINAL_REQUEST).set((Object)httpCarbonRequest);
        channel.attr(Constants.RESPONSE_FUTURE_OF_ORIGINAL_CHANNEL).set((Object)httpResponseFuture);
        channel.attr(Constants.TARGET_CHANNEL_REFERENCE).set((Object)targetChannel);
        channel.attr(Constants.ORIGINAL_CHANNEL_START_TIME).set((Object)System.currentTimeMillis());
        channel.attr(Constants.ORIGINAL_CHANNEL_TIMEOUT).set((Object)this.socketIdleTimeout);
    }

    private void initTargetChannelProperties(SenderConfiguration senderConfiguration) {
        this.chunkDisabled = senderConfiguration.isChunkDisabled();
        this.followRedirect = senderConfiguration.isFollowRedirect();
        this.socketIdleTimeout = senderConfiguration.getSocketIdleTimeout(60000);
        this.sslConfig = senderConfiguration.getSslConfig();
        this.keepAlive = senderConfiguration.isKeepAlive();
    }
}

